/*
 * Decompiled with CFR 0.152.
 */
package hhapplet;

import hhapplet.ButtonPushEvent;
import hhapplet.ButtonPushEventListener;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Vector;

public class CanvasButton
extends Canvas {
    protected Rectangle inside;
    protected Image img = null;
    protected Vector listeners = new Vector();
    protected boolean button_push_state = false;

    public void paint(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.bounds().width, this.bounds().height);
        if (this.img != null) {
            graphics.drawImage(this.img, 2, 2, null);
        }
        if (this.button_push_state) {
            this.paintBorderIn(graphics);
            return;
        }
        this.paintBorderOut(graphics);
    }

    public CanvasButton(Image image) {
        this();
        this.img = image;
    }

    public CanvasButton() {
        this.setBackground(new Color(192, 192, 192));
    }

    public void paintBorderOut(Graphics graphics) {
        Rectangle rectangle = this.bounds();
        Color color = this.getBackground().brighter();
        Color color2 = color.darker();
        Color color3 = color2.darker();
        Color color4 = color3.darker();
        graphics.setColor(color);
        graphics.drawLine(0, 0, rectangle.width - 1, 0);
        graphics.drawLine(0, 0, 0, rectangle.height - 1);
        graphics.setColor(color2);
        graphics.drawLine(1, 1, rectangle.width - 2, 1);
        graphics.drawLine(1, 1, 1, rectangle.height - 2);
        graphics.setColor(color4);
        graphics.drawLine(rectangle.width - 2, 1, rectangle.width - 2, rectangle.height - 2);
        graphics.drawLine(1, rectangle.height - 2, rectangle.width - 2, rectangle.height - 2);
        graphics.setColor(color3);
        graphics.drawLine(rectangle.width - 1, 1, rectangle.width - 1, rectangle.height - 1);
        graphics.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paintBorderIn(Graphics graphics) {
        Rectangle rectangle = this.bounds();
        Color color = this.getBackground().brighter();
        Color color2 = color.darker();
        Color color3 = color2.darker();
        Color color4 = color3.darker();
        graphics.setColor(color4);
        graphics.drawLine(0, 0, rectangle.width - 1, 0);
        graphics.drawLine(0, 0, 0, rectangle.height - 1);
        graphics.setColor(color3);
        graphics.drawLine(1, 1, rectangle.width - 2, 1);
        graphics.drawLine(1, 1, 1, rectangle.height - 2);
        graphics.setColor(color2);
        graphics.drawLine(rectangle.width - 2, 1, rectangle.width - 2, rectangle.height - 2);
        graphics.drawLine(1, rectangle.height - 2, rectangle.width - 2, rectangle.height - 2);
        graphics.setColor(color);
        graphics.drawLine(rectangle.width - 1, 1, rectangle.width - 1, rectangle.height - 1);
        graphics.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
    }

    public void removeButtonPushEventListener(ButtonPushEventListener buttonPushEventListener) {
        this.listeners.removeElement(buttonPushEventListener);
    }

    public Dimension preferredSize() {
        if (this.img != null) {
            return new Dimension(this.img.getWidth(this) + 4, this.img.getHeight(this) + 4);
        }
        return new Dimension(20, 20);
    }

    public void addButtonPushEventListener(ButtonPushEventListener buttonPushEventListener) {
        this.listeners.addElement(buttonPushEventListener);
    }

    public boolean handleEvent(Event event) {
        if (event.id == 501) {
            this.button_push_state = true;
            this.repaint();
            return true;
        }
        if (event.id == 502 && this.button_push_state) {
            this.button_push_state = false;
            this.repaint();
            Rectangle rectangle = this.bounds();
            rectangle.x = 0;
            rectangle.y = 0;
            if (rectangle.inside(event.x, event.y)) {
                this.doAction(event);
            }
            return true;
        }
        if (event.id == 506) {
            Rectangle rectangle = this.bounds();
            rectangle.x = 0;
            rectangle.y = 0;
            if (!rectangle.inside(event.x, event.y)) {
                if (this.button_push_state) {
                    this.button_push_state = false;
                    this.repaint();
                }
            } else if (!this.button_push_state) {
                this.button_push_state = true;
                this.repaint();
            }
            return true;
        }
        return false;
    }

    protected void doAction(Event event) {
        Vector vector;
        ButtonPushEvent buttonPushEvent = new ButtonPushEvent(this, event.x, event.y);
        CanvasButton canvasButton = this;
        synchronized (canvasButton) {
            vector = (Vector)this.listeners.clone();
            Object var6_5 = null;
        }
        int n = 0;
        while (n < vector.size()) {
            ButtonPushEventListener buttonPushEventListener = (ButtonPushEventListener)this.listeners.elementAt(n);
            buttonPushEventListener.notifyButtonPushEvent(buttonPushEvent);
            ++n;
        }
    }
}

