/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.Notifier;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.Notifier.DelayedBroadcaster;
import com.apcc.m11.components.Notifier.ITriggerConsumer;
import com.apcc.m11.components.Notifier.NotifierRules;
import com.apcc.m11.ds.services.messageBroadcastGroup.AllRecipients;
import com.apcc.m11.ds.services.messageBroadcastGroup.Recipient;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class Broadcaster
implements ITriggerConsumer {
    private static final String kAllRecipients = new ObjectId(AllRecipients.kOid).toString();
    private Vector theDelayedBroadcasters;
    private String theApplicationName;
    private String theExecutable;
    private NotifierRules theNotifierRules;
    private Hashtable theRecipients;

    public Broadcaster(String string, String string2, NotifierRules notifierRules) {
        this.theApplicationName = string;
        this.theExecutable = string2;
        this.theDelayedBroadcasters = new Vector();
        this.theRecipients = new Hashtable();
        this.theNotifierRules = notifierRules;
    }

    @Override
    public void triggerOccurred(Event event, int n) {
        this.theNotifierRules.eventOccurred(event.getObjectId());
        this.broadcastNow(event, n);
    }

    @Override
    public synchronized void triggerCanceled(Event event) {
        this.cancelBroadcast(event.getObjectId());
    }

    public void addRecipient(Recipient recipient) throws NullPointerException {
        if (recipient == null) {
            throw new NullPointerException();
        }
        String string = recipient.getEventToNotifyOn().toString();
        this.removeRecipient(recipient);
        Vector<Recipient> vector = (Vector<Recipient>)this.theRecipients.get(string.toString());
        if (vector == null) {
            vector = new Vector<Recipient>();
        }
        vector.addElement(recipient);
        this.theRecipients.put(string.toString(), vector);
    }

    public void removeRecipient(Recipient recipient) {
        if (recipient == null) {
            throw new NullPointerException();
        }
        this.removeASingleRecipient(recipient);
    }

    public Vector getRecipients(ObjectId objectId) {
        return (Vector)this.theRecipients.get(objectId.toString());
    }

    public Hashtable getAllRecipients() {
        return (Hashtable)this.theRecipients.clone();
    }

    public void cancelBroadcast(ObjectId objectId) {
        Enumeration enumeration = this.theDelayedBroadcasters.elements();
        while (enumeration.hasMoreElements()) {
            DelayedBroadcaster delayedBroadcaster = (DelayedBroadcaster)enumeration.nextElement();
            ObjectId objectId2 = delayedBroadcaster.getTriggerId();
            if (!objectId2.equals((Object)objectId)) continue;
            delayedBroadcaster.cancelBroadcast();
            delayedBroadcaster.interrupt();
        }
    }

    public void broadcastNow(Event event, int n) {
        DelayedBroadcaster delayedBroadcaster;
        Vector vector = (Vector)this.theRecipients.get(event.getObjectId().toString());
        Recipient recipient = null;
        Vector<Recipient> vector2 = new Vector<Recipient>();
        for (int i = 0; i < vector.size(); ++i) {
            Recipient recipient2 = (Recipient)vector.elementAt(i);
            if (recipient2.getAddress().equals(kAllRecipients)) {
                recipient = recipient2;
                continue;
            }
            vector2.addElement(recipient2);
        }
        if (recipient != null) {
            delayedBroadcaster = new DelayedBroadcaster(this.theApplicationName, this.theExecutable, n, recipient.getPeriodicInterval(), event, Locale.getDefault(), this.theNotifierRules);
            this.theDelayedBroadcasters.addElement(delayedBroadcaster);
            delayedBroadcaster.start();
        }
        if (vector2.size() > 0) {
            delayedBroadcaster = new DelayedBroadcaster(this.theApplicationName, this.theExecutable, n, event, vector2, this.theNotifierRules);
            this.theDelayedBroadcasters.addElement(delayedBroadcaster);
            delayedBroadcaster.start();
        }
    }

    public void stop() {
        Enumeration enumeration = this.theRecipients.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            ObjectId objectId = ((Recipient)vector.firstElement()).getEventToNotifyOn();
            this.cancelBroadcast(objectId);
        }
    }

    public void removeAllRecipients(ObjectId objectId) {
        this.theRecipients.remove(objectId.toString());
    }

    public void removeASingleRecipient(Recipient recipient) {
        String string = recipient.getEventToNotifyOn().toString();
        Vector vector = (Vector)this.theRecipients.get(string.toString());
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            String string2 = recipient.getAddress();
            while (enumeration.hasMoreElements()) {
                Recipient recipient2 = (Recipient)enumeration.nextElement();
                if (!recipient2.getAddress().equals(string2)) continue;
                vector.removeElement(recipient2);
            }
            this.theRecipients.put(string.toString(), vector);
        }
    }
}

