/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.Notifier;

import com.apcc.m11.arch.FormatterException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.Notifier.NotifierRules;
import com.apcc.m11.ds.services.messageBroadcastGroup.Recipient;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DelayedBroadcaster
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger(DelayedBroadcaster.class);
    private static final int kSecondsToMilliSecondsConversion = 1000;
    private static final String kComponentName = "DelayedBroadcaster";
    private static final String kFieldSepartor = " ";
    private static final String kAllRecipients = "ALL";
    private static final String kSpecificRecipients = "SPECIFIC";
    private String theApplicationName = null;
    private boolean theBroadcastIsEnabled = true;
    private boolean theNotifyAllUsers = true;
    private Vector theRecipients = null;
    private int theDelayTime = 0;
    private Event theEvent;
    private String theExecutable = null;
    private static Locale theLocale = null;
    private int thePeriodicInterval = 0;
    private NotifierRules theNotifierRules;

    public DelayedBroadcaster(String string, String string2, int n, int n2, Event event, Locale locale, NotifierRules notifierRules) {
        this.theExecutable = string2;
        this.theEvent = event;
        this.theDelayTime = n;
        this.thePeriodicInterval = n2;
        this.theApplicationName = "\"" + string + "\"";
        if (theLocale == null) {
            theLocale = locale;
        }
        this.theNotifyAllUsers = true;
        this.theNotifierRules = notifierRules;
    }

    public DelayedBroadcaster(String string, String string2, int n, Event event, Vector vector, NotifierRules notifierRules) {
        this.theExecutable = string2;
        this.theEvent = event;
        this.theDelayTime = n;
        this.theApplicationName = "\"" + string + "\"";
        this.theRecipients = vector;
        this.thePeriodicInterval = ((Recipient)this.theRecipients.firstElement()).getPeriodicInterval();
        this.theNotifyAllUsers = false;
        if (theLocale == null) {
            theLocale = Locale.getDefault();
        }
        this.theNotifierRules = notifierRules;
    }

    @Override
    public void run() {
        try {
            DelayedBroadcaster.sleep(this.theDelayTime * 1000);
            if (this.thePeriodicInterval > 0) {
                int n = this.thePeriodicInterval * 1000;
                while (this.isBroadcastEnabled()) {
                    this.broadcast_message();
                    DelayedBroadcaster.sleep(n);
                }
            } else if (this.isBroadcastEnabled()) {
                this.broadcast_message();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void cancelBroadcast() {
        this.disableBroadcast();
    }

    public ObjectId getTriggerId() {
        return this.theEvent.getObjectId();
    }

    private synchronized void disableBroadcast() {
        this.theBroadcastIsEnabled = false;
    }

    private synchronized boolean isBroadcastEnabled() {
        return this.theBroadcastIsEnabled;
    }

    private void broadcast_message() {
        if (this.theNotifierRules.okToNotify(this.theEvent)) {
            this.theNotifierRules.notificationOccurred(this.theEvent.getObjectId());
            IFormatter iFormatter = this.theEvent.getFormatter();
            try {
                Object object;
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(this.theExecutable);
                arrayList.add("\"" + iFormatter.format((Object)this.theEvent, theLocale) + "\"");
                arrayList.add(this.theApplicationName);
                if (this.theNotifyAllUsers) {
                    arrayList.add("\"ALL\"");
                } else {
                    arrayList.add("\"SPECIFIC\"");
                    object = this.theRecipients.elements();
                    while (object.hasMoreElements()) {
                        Recipient recipient = (Recipient)object.nextElement();
                        arrayList.add("\"" + recipient.getAddress() + "\"");
                    }
                }
                LOGGER.debug(arrayList);
                try {
                    object = new ProcessBuilder(arrayList);
                    LOGGER.debug("Notifier command: {}", (Object)this.theExecutable);
                    ((ProcessBuilder)object).start();
                }
                catch (Exception exception) {
                    LOGGER.debug("Could not launch notifier executable", (Throwable)exception);
                }
            }
            catch (FormatterException formatterException) {
                LOGGER.debug("Format Exception for event: (event): {}", (Object)this.theEvent, (Object)formatterException);
            }
            catch (UnsupportedLocaleException unsupportedLocaleException) {
                LOGGER.debug("Unsupported locale {} for event: (event): {}", (Object)theLocale, (Object)this.theEvent, (Object)unsupportedLocaleException);
            }
            catch (Exception exception) {
                LOGGER.debug("General exception:", (Throwable)exception);
            }
        }
    }

    public static void setLocale(Locale locale) {
        theLocale = locale;
    }
}

