/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.Notifier;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.VariableBinding;
import com.apcc.m11.arch.application.Directory;
import com.apcc.m11.arch.component.ComponentFailureException;
import com.apcc.m11.arch.component.ComponentID;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataConsumer;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.arch.m11component.IM11Component;
import com.apcc.m11.arch.m11component.M11ComponentSynchronizer;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.arch.storage.StorageEntryException;
import com.apcc.m11.components.Notifier.Broadcaster;
import com.apcc.m11.components.Notifier.NotifierRules;
import com.apcc.m11.components.Notifier.Trigger;
import com.apcc.m11.ds.arch.application.Name;
import com.apcc.m11.ds.arch.interfaces.DataConsumer;
import com.apcc.m11.ds.arch.interfaces.DataSource;
import com.apcc.m11.ds.arch.interfaces.EventConsumer;
import com.apcc.m11.ds.services.messageBroadcastGroup.AddRule;
import com.apcc.m11.ds.services.messageBroadcastGroup.BroadcastNow;
import com.apcc.m11.ds.services.messageBroadcastGroup.CancelBroadcast;
import com.apcc.m11.ds.services.messageBroadcastGroup.Group;
import com.apcc.m11.ds.services.messageBroadcastGroup.ListOfNotificationRecipients;
import com.apcc.m11.ds.services.messageBroadcastGroup.Recipient;
import com.apcc.m11.ds.services.messageBroadcastGroup.RegisterRecipientForNotification;
import com.apcc.m11.ds.services.messageBroadcastGroup.RemoveRule;
import com.apcc.m11.ds.services.messageBroadcastGroup.RuleObject;
import com.apcc.m11.ds.services.messageBroadcastGroup.UnRegisterAllRecipientsForNotification;
import com.apcc.m11.ds.services.messageBroadcastGroup.UnRegisterRecipientForNotification;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Notifier
implements IM11Component,
IDataSource,
IDataConsumer {
    private static final Logger LOGGER = LogManager.getLogger(Notifier.class);
    private static final String kComponentName = "Notifier";
    private static final String kComponentID = "Notifier";
    private static final String kTriggersIdentifier = "Triggers";
    private static final String kExecutableIdentifier = "NotifierExe";
    private static final String kRulesIdentifier = "NotifierRules";
    private static final String kComponentVersion = "1.0.0";
    private NotifierRules theNotifierRules = null;
    private Trigger theTriggers = null;
    private M11ComponentSynchronizer theState = null;
    private IDataSource theDataSource = null;
    private IPermanentStorage thePermanentStorage = null;
    private Broadcaster theBroadcaster = null;

    public void init(IPermanentStorage iPermanentStorage) throws ComponentFailureException {
        block4: {
            LOGGER.debug("In Notifier:  In Init ");
            this.thePermanentStorage = iPermanentStorage;
            this.theTriggers = new Trigger();
            this.theNotifierRules = new NotifierRules();
            Hashtable hashtable = null;
            try {
                hashtable = (Hashtable)this.thePermanentStorage.readData(this.getComponentID(), kRulesIdentifier);
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    Vector vector = (Vector)hashtable.get(string);
                    Enumeration enumeration2 = vector.elements();
                    while (enumeration2.hasMoreElements()) {
                        this.theNotifierRules.addRule(new ObjectId(string), (ObjectId)enumeration2.nextElement());
                    }
                }
            }
            catch (Exception exception) {
                if (hashtable == null) break block4;
                LOGGER.debug("Init:  could not read from permanent storage (theNotifierRules.getAllRules): {}", (Object)hashtable);
            }
        }
    }

    public void start() throws ComponentFailureException {
        LOGGER.debug("In Notifier:  In start at the beginning ");
        this.initializeInternalObjects();
        LOGGER.debug("In Notifier:  Started ");
        this.theState.setState(2);
    }

    public void stop() {
        this.theState.setState(1);
        this.theDataSource = null;
        if (this.theTriggers != null) {
            this.theTriggers.stop();
            this.theTriggers = null;
        }
        if (this.theBroadcaster != null) {
            this.theBroadcaster.stop();
            this.theBroadcaster = null;
        }
    }

    public Object getInterface(ObjectId objectId) throws InvalidObjectIdException {
        Object object = null;
        if (objectId.equals((Object)DataSource.kOid)) {
            object = this;
        } else if (objectId.equals((Object)EventConsumer.kOid)) {
            object = this.theTriggers;
        } else if (objectId.equals((Object)DataConsumer.kOid)) {
            object = this;
        } else {
            LOGGER.debug("Bad interface ID: {}", (Object)objectId);
            throw new InvalidObjectIdException("Interface Not Supported");
        }
        return object;
    }

    public String getComponentName() {
        return "Notifier";
    }

    public ComponentID getComponentID() {
        return new ComponentID("Notifier");
    }

    public String getComponentVersion() {
        return kComponentVersion;
    }

    public void setDataSource(IDataSource iDataSource) {
        this.theDataSource = iDataSource;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GetResult get(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult = new GetResult();
        if (this.theState.getState() == 2) {
            if (!objectId.equals((Object)ListOfNotificationRecipients.kOid)) throw new InvalidObjectIdException("Object ID Not Supported");
            getResult.setValue((Object)this.theBroadcaster.getAllRecipients());
            return getResult;
        } else {
            getResult.setError();
        }
        return getResult;
    }

    public GetResult get(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult;
        block7: {
            block6: {
                getResult = new GetResult();
                if (this.theState.getState() != 2) break block6;
                switch (n) {
                    case 0: {
                        getResult = this.get(objectId);
                        break block7;
                    }
                    case 1: {
                        Availability availability = new Availability(true);
                        getResult.setValue((Object)availability);
                        break block7;
                    }
                    case 2: {
                        getResult = new GetResult();
                        getResult.setError();
                        break block7;
                    }
                    case 3: {
                        getResult = new GetResult();
                        getResult.setError();
                        break block7;
                    }
                    default: {
                        LOGGER.debug("Get:  bad ID or type: {}, {}", (Object)objectId, (Object)n);
                        throw new InvalidObjectIdException();
                    }
                }
            }
            LOGGER.debug("Get:  Notifier not initialized");
            getResult.setError();
        }
        return getResult;
    }

    public GetResult get(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        throw new InvalidObjectIdException("This component does not support this method.");
    }

    public SetResult set(ObjectId objectId, Object object) throws InvalidValueException, InvalidObjectIdException, CommunicationException {
        LOGGER.debug("In Notifier: oid {}", (Object)objectId);
        SetResult setResult = new SetResult();
        if (this.theState.getState() == 2) {
            if (objectId == null) {
                throw new InvalidObjectIdException("Object ID Not Supported");
            }
            if (object == null) {
                throw new InvalidValueException();
            }
            if (objectId.equals((Object)RegisterRecipientForNotification.kOid)) {
                Hashtable hashtable;
                LOGGER.debug("In Notifier: Register For Notification: {}", object);
                Recipient recipient = (Recipient)object;
                LOGGER.debug("Periodic delay time = {}", (Object)recipient.getPeriodicInterval());
                try {
                    LOGGER.debug("Adding recipient to Broadcaster");
                    this.theBroadcaster.addRecipient(recipient);
                    LOGGER.debug("Creating VariableBinding for trigger");
                    hashtable = new VariableBinding(recipient.getEventToNotifyOn(), (Object)new Integer(recipient.getInitialDelay()));
                    LOGGER.debug("Adding trigger to Triggers");
                    this.theTriggers.addTrigger((VariableBinding)hashtable);
                }
                catch (Exception exception) {
                    LOGGER.debug("Register recipient Exception", (Throwable)exception);
                }
                try {
                    LOGGER.debug("Writing triggers to m11.cfg");
                    hashtable = this.theBroadcaster.getAllRecipients();
                    if (hashtable == null) {
                        LOGGER.debug("Recipients Hashtable is null");
                        throw new InvalidValueException();
                    }
                    LOGGER.debug("Component ID: {}", (Object)this.getComponentID().getID());
                    LOGGER.debug("Identifier: {}", (Object)kTriggersIdentifier);
                    LOGGER.debug("Hashtable: {}", (Object)hashtable);
                    this.thePermanentStorage.writeData(this.getComponentID(), kTriggersIdentifier, (Object)hashtable);
                    LOGGER.debug("Setting SetResult to successful");
                    setResult.setSuccessful(true);
                }
                catch (Exception exception) {
                    LOGGER.debug("Set:  could not write to permanent storage (Register Trigger)", (Throwable)exception);
                    throw new InvalidValueException();
                }
            }
            if (objectId.equals((Object)UnRegisterRecipientForNotification.kOid)) {
                Recipient recipient = (Recipient)object;
                this.theBroadcaster.removeRecipient(recipient);
                VariableBinding variableBinding = new VariableBinding(recipient.getEventToNotifyOn(), (Object)new Integer(recipient.getInitialDelay()));
                this.theTriggers.removeTrigger(variableBinding);
                try {
                    this.thePermanentStorage.writeData(this.getComponentID(), kTriggersIdentifier, (Object)this.theBroadcaster.getAllRecipients());
                    setResult.setSuccessful(true);
                }
                catch (Exception exception) {
                    LOGGER.debug("Set:  could not write to permanent storage (Unregister Trigger): {}", (Object)this.theTriggers);
                    throw new InvalidValueException();
                }
                this.theBroadcaster.cancelBroadcast(variableBinding.getObjectId());
            } else if (objectId.equals((Object)BroadcastNow.kOid)) {
                this.theBroadcaster.broadcastNow((Event)object, 0);
                setResult.setSuccessful(true);
            } else if (objectId.equals((Object)CancelBroadcast.kOid)) {
                this.theBroadcaster.cancelBroadcast((ObjectId)object);
                setResult.setSuccessful(true);
            } else {
                if (objectId.equals((Object)AddRule.kOid)) {
                    RuleObject ruleObject = (RuleObject)object;
                    this.theNotifierRules.addRule(ruleObject.getAffectedEvent(), ruleObject.getRuleEvent());
                    try {
                        this.thePermanentStorage.writeData(this.getComponentID(), kRulesIdentifier, (Object)this.theNotifierRules.getAllRules());
                        setResult.setSuccessful(true);
                    }
                    catch (Exception exception) {
                        LOGGER.debug("Set:  could not write to permanent storage (Add Rule): {}", (Object)this.theNotifierRules.getAllRules());
                        throw new InvalidValueException();
                    }
                }
                if (objectId.equals((Object)RemoveRule.kOid)) {
                    RuleObject ruleObject = (RuleObject)object;
                    this.theNotifierRules.removeRule(ruleObject.getAffectedEvent(), ruleObject.getRuleEvent());
                    try {
                        this.thePermanentStorage.writeData(this.getComponentID(), kRulesIdentifier, (Object)this.theNotifierRules.getAllRules());
                        setResult.setSuccessful(true);
                    }
                    catch (Exception exception) {
                        LOGGER.debug("Set:  could not write to permanent storage (Remove Rule): {}", (Object)this.theNotifierRules.getAllRules());
                        throw new InvalidValueException();
                    }
                }
                if (objectId.equals((Object)UnRegisterAllRecipientsForNotification.kOid)) {
                    ObjectId objectId2 = (ObjectId)object;
                    VariableBinding variableBinding = new VariableBinding(objectId2, null);
                    this.theBroadcaster.removeAllRecipients(objectId2);
                    this.theTriggers.removeTrigger(variableBinding);
                    try {
                        this.thePermanentStorage.writeData(this.getComponentID(), kTriggersIdentifier, (Object)this.theBroadcaster.getAllRecipients());
                        setResult.setSuccessful(true);
                    }
                    catch (Exception exception) {
                        LOGGER.debug("Set:  could not write to permanent storage (Remove All Triggers): {}", (Object)this.theNotifierRules.getAllRules());
                        throw new InvalidValueException();
                    }
                    this.theBroadcaster.cancelBroadcast(variableBinding.getObjectId());
                } else {
                    LOGGER.debug("Set:  Notifier not initialized");
                    throw new InvalidObjectIdException("Object ID Not Supported");
                }
            }
        }
        return setResult;
    }

    public Enumeration getSupportedOids() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.addElement(Group.kOid);
        return vector.elements();
    }

    private void initializeInternalObjects() throws ComponentFailureException {
        Object object;
        String string = null;
        Directory directory = new Directory(this.thePermanentStorage);
        Object object2 = directory.getExeDirectory();
        String string2 = "notifier";
        try {
            LOGGER.debug("initializeInternalObjects() - Reading notifier script...");
            string2 = (String)this.thePermanentStorage.readData(this.getComponentID(), kExecutableIdentifier);
        }
        catch (StorageEntryException storageEntryException) {
            try {
                this.thePermanentStorage.writeData(this.getComponentID(), kExecutableIdentifier, (Object)string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object2 = (String)object2 + File.separator + string2;
        try {
            LOGGER.debug("In Notifier:  getting app name");
            object = this.theDataSource.get(Name.kOid);
            string = (String)object.getValue();
        }
        catch (Exception exception) {
            LOGGER.debug("{} initializeInternalObjects:  could not GET application name", (Object)"Notifier");
        }
        if (string == null || object2 == null) {
            LOGGER.error("initializeInternalObjects() - Failed to find application name or exe path. Component start failed.");
            throw new ComponentFailureException();
        }
        LOGGER.debug("In Notifier:  setting up broadcaster");
        this.theBroadcaster = new Broadcaster(string, (String)object2, this.theNotifierRules);
        LOGGER.debug("In Notifier:  initializing triggers");
        this.theTriggers.setConsumer(this.theBroadcaster);
        this.theState = new M11ComponentSynchronizer(1);
        object = null;
        try {
            object = (Hashtable)this.thePermanentStorage.readData(this.getComponentID(), kTriggersIdentifier);
            Enumeration enumeration = ((Hashtable)object).elements();
            while (enumeration.hasMoreElements()) {
                Vector vector = (Vector)enumeration.nextElement();
                Enumeration enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    Recipient recipient = (Recipient)enumeration2.nextElement();
                    this.theBroadcaster.addRecipient(recipient);
                    this.theTriggers.addTrigger(new VariableBinding(recipient.getEventToNotifyOn(), (Object)new Integer(recipient.getInitialDelay())));
                }
            }
        }
        catch (Exception exception) {
            LOGGER.debug("initialize_internal_objects:  could not read from permanent storage", (Throwable)exception);
        }
        LOGGER.debug("In Notifier:   Internal Objects OK");
    }
}

