/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.Notifier;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class NotifierRules {
    private Hashtable theRules = new Hashtable();
    private Hashtable theEventsThatHaveOccurred = new Hashtable();
    private Hashtable thePendingEvents = new Hashtable();

    NotifierRules() {
    }

    public synchronized void addRule(ObjectId objectId, ObjectId objectId2) {
        Vector<ObjectId> vector = (Vector<ObjectId>)this.theRules.get(objectId.toString());
        if (vector == null) {
            vector = new Vector<ObjectId>();
        }
        if (!vector.contains(objectId2)) {
            vector.addElement(objectId2);
        }
        this.theRules.put(objectId.toString(), vector);
    }

    public synchronized void removeRule(ObjectId objectId, ObjectId objectId2) {
        Vector vector = (Vector)this.theRules.get(objectId.toString());
        if (vector != null) {
            ObjectId objectId3 = objectId2;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ObjectId objectId4 = (ObjectId)enumeration.nextElement();
                if (!objectId3.equals((Object)objectId4)) continue;
                vector.removeElement(objectId4);
            }
            vector.addElement(objectId2);
            this.theRules.put(objectId.toString(), vector);
        }
    }

    public synchronized void eventOccurred(ObjectId objectId) {
        this.theEventsThatHaveOccurred.remove(objectId.toString());
        this.thePendingEvents.put(objectId.toString(), new Date());
    }

    public synchronized void notificationOccurred(ObjectId objectId) {
        this.theEventsThatHaveOccurred.put(objectId.toString(), new Date());
    }

    public synchronized boolean okToNotify(Event event) {
        boolean bl = false;
        Vector vector = (Vector)this.theRules.get(event.getObjectId().toString());
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            Date date = (Date)this.thePendingEvents.get(event.getObjectId().toString());
            while (enumeration.hasMoreElements()) {
                Date date2;
                ObjectId objectId = (ObjectId)enumeration.nextElement();
                Object v = this.theEventsThatHaveOccurred.get(objectId.toString());
                if (v == null || !(date2 = (Date)v).before(date)) continue;
                bl = true;
                this.clear_occurred_events(vector);
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public synchronized Hashtable getAllRules() {
        return this.theRules;
    }

    private void clear_occurred_events(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ObjectId objectId = (ObjectId)enumeration.nextElement();
            Object v = this.theEventsThatHaveOccurred.get(objectId.toString());
            if (v == null) continue;
            this.theEventsThatHaveOccurred.remove(objectId.toString());
        }
    }
}

