/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.autoupdate;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.FormatterException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.RegistrationException;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.arch.component.ComponentFailureException;
import com.apcc.m11.arch.component.ComponentID;
import com.apcc.m11.arch.component.IComponent;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataConsumer;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.arch.event.IEventConsumer;
import com.apcc.m11.arch.event.IEventProducer;
import com.apcc.m11.arch.m11component.IM11Component;
import com.apcc.m11.arch.m11component.M11ComponentSynchronizer;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.components.autoupdate.SoftwareUpdateChecker;
import com.apcc.m11.components.autoupdate.SoftwareUpdateCheckerHTTPS;
import com.apcc.m11.components.autoupdate.UpdateAvailableEvent;
import com.apcc.m11.components.autoupdate.UpdateIntervalValidator;
import com.apcc.m11.components.webserver.model.SSHActionTrigger;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.arch.interfaces.Component;
import com.apcc.m11.ds.arch.interfaces.DataConsumer;
import com.apcc.m11.ds.arch.interfaces.DataSource;
import com.apcc.m11.ds.arch.interfaces.EventProducer;
import com.apcc.m11.ds.arch.interfaces.M11Component;
import com.apcc.m11.ds.powersource.Identification;
import com.apcc.m11.ds.services.softwareupdate.SoftwareUpdateGroup;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.AuthHelper;
import com.apcc.pcns.configservice.TrafficLightColours;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.configservice.validation.URLValidator;
import com.apcc.pcns.snmp.PcnsTrapGenerator;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AutoUpdateComponent
implements IM11Component,
IComponent,
IDataSource,
IDataConsumer,
IEventProducer {
    private static final String UPDATES_WAIT_TEXT = "Updates.WaitText";
    public static final String DEFAULT_UPDATE_INTERVAL_STR = "7";
    public static final int DEFAULT_UPDATE_INTERVAL = 7;
    public static final int MIN_INTERVAL = 1;
    public static final int MAX_INTERVAL_DAYS = 365;
    public static final int MAX_INTERVAL_SECONDS = Integer.MAX_VALUE;
    private static final Logger logger = LogManager.getLogger(AutoUpdateComponent.class);
    private static final String kComponentName = "SoftwareUpdate";
    private static final String kComponentVersion = "1.0.0";
    public static final String DEFAULT_UPDATE_URL = "https://updates.apc.com/pcns/autoupdate.cfm";
    public static final String DEFAULT_SKU_SEARCH_KEYWORD = "all";
    private M11ComponentSynchronizer theState = new M11ComponentSynchronizer(1);
    private ConfigurationManager config;
    protected IPermanentStorage theM11Storage;
    public static final ComponentID kComponentId = new ComponentID("SoftwareUpdate");
    public static final String kProxyUsername = "UpdateFrequency";
    public static final String kProxyPassword = "UpdateNumber";
    private Boolean updatesEnabled;
    private String updateServerURL;
    private Boolean devBuild;
    private String skuName;
    private long updateInterval;
    private String updateURL;
    private String updateDes;
    private String updateVersion;
    private Date lastChecked;
    private Integer status;
    private SoftwareUpdateChecker checker;
    private Vector<IEventConsumer> theEventConsumers = new Vector();
    protected IDataSource theDataSource;
    private ScheduledFuture<?> future;
    private ServiceManager services;
    private EventListener<ConfigurationEvent> configListener;
    private static String SEPERATOR = ",";
    private static String VALUE_SEPERATOR = "-";

    public void init(IPermanentStorage iPermanentStorage) throws ComponentFailureException {
        if (iPermanentStorage == null) {
            throw new ComponentFailureException("Permanent storage can't be null.");
        }
        this.theM11Storage = iPermanentStorage;
        this.updateURL = null;
        this.updateDes = null;
        this.updateVersion = null;
        this.status = 0;
        if (!AutoUpdateComponent.isJapanese()) {
            if (this.services == null) {
                this.services = ServiceManager.getInstance();
            }
            this.config = this.services.getConfigurationManager();
            this.loadConfiguration();
        }
    }

    public void start() throws ComponentFailureException {
        if (!AutoUpdateComponent.isJapanese()) {
            this.configListener = new EventListener<ConfigurationEvent>(){

                public void onEvent(ConfigurationEvent configurationEvent) {
                    logger.trace("onEvent.  Type: {}, {} : {}", (Object)configurationEvent.getEventType(), (Object)configurationEvent.getPropertyName(), configurationEvent.getPropertyValue());
                    try {
                        if (!AutoUpdateComponent.isJapanese() && !configurationEvent.isBeforeUpdate() && StringUtils.startsWith((CharSequence)configurationEvent.getPropertyName(), (CharSequence)AutoUpdateComponent.kComponentName)) {
                            AutoUpdateComponent.this.loadConfiguration();
                        }
                    }
                    catch (Exception exception) {
                        logger.error("onEvent", (Throwable)exception);
                    }
                }
            };
            this.config.addEventListener(ConfigurationEvent.SET_PROPERTY, this.configListener);
            this.checker = new SoftwareUpdateCheckerHTTPS(this.updateServerURL, this.services.getTrustStoreManager());
            this.checker.setProduct_name("PCNS");
            this.checker.setProduct_version(this.services.getProductVersion().getVersion());
            if (this.devBuild.booleanValue()) {
                this.checker.setDev_build("1");
            }
            if (this.skuName != null) {
                this.checker.setSkuName(this.skuName);
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AutoUpdateComponent.this.doCheckForUpdate();
                }
            };
            this.initOverviewPanelSoftwareUpdateStatus();
            ServiceManager.getInstance().getThreadService().scheduleAtFixedRate(runnable, TimeUnit.MILLISECONDS.convert(10L, TimeUnit.MINUTES), this.updateInterval, TimeUnit.MILLISECONDS);
            this.theState.setState(2);
        }
    }

    private void initOverviewPanelSoftwareUpdateStatus() {
        AuthHelper authHelper = ServiceManager.getInstance().getAuthHelper();
        String string = authHelper.getSoftwareUpdateResponseText();
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(Locale.getDefault());
        if (StringUtils.isBlank((CharSequence)string)) {
            authHelper.setSoftwareUpdateStatus(TrafficLightColours.RED);
            authHelper.setSoftwareUpdateResponseText(resourceBundleWrapper.getResourceBundle().getString(UPDATES_WAIT_TEXT));
        }
    }

    public String getTags() {
        String string;
        Object object = SEPERATOR;
        String string2 = this.config.getString("NetworkManagementCard", "mode", "");
        if (!string2.isEmpty()) {
            object = (String)object + string2 + SEPERATOR;
        }
        if (this.config.containsKey("Networking", "VirtualInstall") && !StringUtils.isBlank((CharSequence)(string = this.config.getString("Networking", "VirtualInstall")))) {
            object = (String)object + string + SEPERATOR;
        }
        if (this.config.containsKey("HostDetails", "hyperconverged_support")) {
            string = this.config.getString("HostDetails", "hyperconverged_support", "");
            if (!string.isEmpty() && !"none".equals(string)) {
                object = (String)object + "HCI_" + string + SEPERATOR;
            }
        } else if (((String)object).contains(",Nutanix,")) {
            object = (String)object + "HCI_Nutanix" + SEPERATOR;
        }
        if (this.services.getVsanUtils() != null && this.services.getVsanUtils().isVsanCluster()) {
            object = (String)object + "vSAN" + SEPERATOR;
        }
        if (this.config.containsKey("HostDetails", "ConfigurationMode") && !(string = this.config.getString("HostDetails", "ConfigurationMode", "")).isEmpty()) {
            object = (String)object + string + SEPERATOR;
        }
        if (this.services.getVirtualConfigurationManager() != null && this.services.getVirtualConfigurationManager().isVCSA()) {
            object = (String)object + "vCSAonVM" + SEPERATOR;
        }
        if (this.services.getVirtualConfigurationManager() != null && this.services.getVirtualConfigurationManager().isDelayMaintenanceModeEnabled()) {
            object = (String)object + "DelayMaint" + SEPERATOR;
        }
        if (this.services.getVirtualConfigurationManager() != null && this.services.getVirtualConfigurationManager().isSkipMaintenanceModeEnabled()) {
            object = (String)object + "SkipMaint" + SEPERATOR;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        Integer n = null;
        Map<String, Object> map = this.config.getProperties();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getKey().endsWith(".enable_guest_vm_migration") && BooleanUtils.toBoolean((String)entry.getValue().toString())) {
                bl = true;
            }
            if (entry.getKey().endsWith(".enable_guest_vm_vapp_shutdown") && BooleanUtils.toBoolean((String)entry.getValue().toString())) {
                bl2 = true;
            }
            if (entry.getKey().endsWith(".enable_guest_vm_vapp_startup") && BooleanUtils.toBoolean((String)entry.getValue().toString())) {
                bl3 = true;
            }
            if (entry.getKey().endsWith(".uvm_startup_enable") && BooleanUtils.toBoolean((String)entry.getValue().toString())) {
                bl3 = true;
            }
            if (entry.getKey().endsWith(".cvm_startup_enable") && BooleanUtils.toBoolean((String)entry.getValue().toString())) {
                bl11 = true;
            }
            if (entry.getKey().endsWith(".ssh_action_sequence") && SSHActionTrigger.ON_STARTUP.getIniSetting().equals(entry.getValue())) {
                bl4 = true;
            }
            if (entry.getKey().endsWith(".ssh_action_sequence") && SSHActionTrigger.BEFORE_HOST_SHUTDOWN.getIniSetting().equals(entry.getValue())) {
                bl6 = true;
            }
            if (entry.getKey().endsWith(".ssh_action_sequence") && SSHActionTrigger.BEFORE_VM_SHUTDOWN.getIniSetting().equals(entry.getValue())) {
                bl7 = true;
            }
            if (entry.getKey().endsWith(".ssh_action_sequence") && SSHActionTrigger.AFTER_HOST_SHUTDOWN.getIniSetting().equals(entry.getValue())) {
                bl5 = true;
            }
            if (entry.getKey().endsWith(".afs_shutdown_enable") && BooleanUtils.toBoolean((String)entry.getValue().toString())) {
                bl8 = true;
            }
            if (entry.getKey().endsWith(".afs_startup_enable") && BooleanUtils.toBoolean((String)entry.getValue().toString())) {
                bl9 = true;
            }
            if (entry.getKey().endsWith(".ongoing_replication_abort_delay_enable") && BooleanUtils.toBoolean((String)entry.getValue().toString())) {
                bl10 = true;
            }
            if (entry.getKey().endsWith(".enable_vsan_ftt") && BooleanUtils.toBoolean((String)entry.getValue().toString())) {
                bl12 = true;
            }
            if (!entry.getKey().endsWith(".vsan_ftt_level")) continue;
            int n2 = Integer.parseInt(entry.getValue().toString());
            if (n != null && n <= n2) continue;
            n = n2;
        }
        if (bl) {
            object = (String)object + "vmMigration" + SEPERATOR;
        }
        if (bl2) {
            object = (String)object + "vmShutdown" + SEPERATOR;
        }
        if (bl3) {
            object = (String)object + "vmStartup" + SEPERATOR;
        }
        if (bl4) {
            object = (String)object + "sshActionStart" + SEPERATOR;
        }
        if (bl6) {
            object = (String)object + "sshActionBeforeHost" + SEPERATOR;
        }
        if (bl5) {
            object = (String)object + "sshActionAfterHost" + SEPERATOR;
        }
        if (bl11) {
            object = (String)object + "cvmStartup" + SEPERATOR;
        }
        if (bl8) {
            object = (String)object + "AFSStop" + SEPERATOR;
        }
        if (bl9) {
            object = (String)object + "AFSStart" + SEPERATOR;
        }
        if (bl10) {
            object = (String)object + "AbortPD" + SEPERATOR;
        }
        if (bl12) {
            object = (String)object + "FTT" + SEPERATOR;
        }
        if (n != null) {
            object = (String)object + "FTTlevel" + VALUE_SEPERATOR + n + SEPERATOR;
        }
        if (this.services.getVMPrioritizationUtils() != null && this.services.getVMPrioritizationUtils().isVMPrioritizationEnabled()) {
            object = (String)object + "vmPriority" + SEPERATOR;
        }
        if (this.config.containsKey("SNMP", "SNMPv1_Enabled") && this.config.getBoolean("SNMP", "SNMPv1_Enabled", false).booleanValue()) {
            object = (String)object + "SNMPv1" + SEPERATOR;
        }
        if (this.config.containsKey("SNMP", "SNMPv3_Enabled") && this.config.getBoolean("SNMP", "SNMPv3_Enabled", false).booleanValue()) {
            object = (String)object + "SNMPv3" + SEPERATOR;
        }
        if (this.config.containsKey("SNMP", "TrapReceiver_1_Enabled")) {
            object = (String)object + "SNMPTrap" + SEPERATOR;
        }
        if (((String)object).equals(SEPERATOR)) {
            object = "";
        }
        logger.info("feature tags:" + (String)object);
        return object;
    }

    public void stop() {
        if (this.future != null) {
            this.future.cancel(false);
        }
        if (this.configListener != null) {
            this.config.removeEventListener(ConfigurationEvent.SET_PROPERTY, this.configListener);
        }
    }

    public Object getInterface(ObjectId objectId) throws InvalidObjectIdException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        AutoUpdateComponent autoUpdateComponent = null;
        if (objectId.equals((Object)DataSource.kOid)) {
            autoUpdateComponent = this;
        } else if (objectId.equals((Object)DataConsumer.kOid)) {
            autoUpdateComponent = this;
        } else if (objectId.equals((Object)EventProducer.kOid)) {
            autoUpdateComponent = this;
        } else {
            logger.trace("getInterface: bad interfac ID (anInterfaceID)");
            throw new InvalidObjectIdException("Interface Not Supported");
        }
        return autoUpdateComponent;
    }

    public String getComponentName() {
        return kComponentName;
    }

    public ComponentID getComponentID() {
        return kComponentId;
    }

    public String getComponentVersion() {
        return kComponentVersion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GetResult get(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        GetResult getResult = new GetResult();
        if (this.theState.getState() != 2) throw new InvalidObjectIdException("Unsupported operation.");
        if (objectId.equals((Object)SoftwareUpdateGroup.AutoUpdateEnabled.getObjectId())) {
            getResult.setValue((Object)this.updatesEnabled);
            return getResult;
        } else if (objectId.equals((Object)SoftwareUpdateGroup.Proxy.getObjectId())) {
            String string = SoftwareUpdateCheckerHTTPS.getHTTPSProxy();
            if (string == null) {
                string = "";
            }
            getResult.setValue((Object)string);
            return getResult;
        } else if (objectId.equals((Object)SoftwareUpdateGroup.ProxyPort.getObjectId())) {
            Integer n = SoftwareUpdateCheckerHTTPS.getHTTPSProxyPort();
            String string = "";
            if (n != null) {
                string = n.toString();
            }
            getResult.setValue((Object)string);
            return getResult;
        } else if (objectId.equals((Object)SoftwareUpdateGroup.IsUpdateAvailable.getObjectId())) {
            getResult.setValue((Object)this.updateURL);
            return getResult;
        } else if (objectId.equals((Object)SoftwareUpdateGroup.UpdateVersion.getObjectId())) {
            getResult.setValue((Object)this.updateVersion);
            return getResult;
        } else if (objectId.equals((Object)SoftwareUpdateGroup.LastChecked.getObjectId())) {
            getResult.setValue((Object)this.lastChecked);
            return getResult;
        } else if (objectId.equals((Object)SoftwareUpdateGroup.UpdateURL.getObjectId())) {
            getResult.setValue((Object)this.updateURL);
            return getResult;
        } else if (objectId.equals((Object)SoftwareUpdateGroup.UpdateDescription.getObjectId())) {
            getResult.setValue((Object)this.updateDes);
            return getResult;
        } else if (objectId.equals((Object)SoftwareUpdateGroup.UpdateStatus.getObjectId())) {
            getResult.setValue((Object)this.status);
            return getResult;
        } else if (objectId.equals((Object)SoftwareUpdateGroup.CheckForUpdate.getObjectId())) {
            if (AutoUpdateComponent.isJapanese()) {
                getResult.setError();
                return getResult;
            } else {
                Boolean bl = this.updatesEnabled;
                this.updatesEnabled = true;
                getResult.setValue((Object)this.doCheckForUpdate());
                this.updatesEnabled = bl;
            }
            return getResult;
        } else {
            if (!objectId.equals((Object)SoftwareUpdateGroup.UpdateInterval.getObjectId())) throw new InvalidObjectIdException("Unsupported operation.");
            getResult.setValue((Object)this.updateInterval);
        }
        return getResult;
    }

    public GetResult get(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult;
        block7: {
            block6: {
                getResult = new GetResult();
                if (this.theState.getState() != 2) break block6;
                switch (n) {
                    case 0: {
                        getResult = this.get(objectId);
                        break block7;
                    }
                    case 1: {
                        getResult.setValue((Object)Availability.AVAILABLE);
                        break block7;
                    }
                    case 2: {
                        getResult = new GetResult();
                        getResult.setError();
                        break block7;
                    }
                    case 3: {
                        getResult = new GetResult();
                        getResult.setError();
                        break block7;
                    }
                    default: {
                        logger.trace("Get:  bad ID or type");
                        throw new InvalidObjectIdException();
                    }
                }
            }
            logger.trace("Get:  event logger not initialized");
            getResult.setError();
        }
        return getResult;
    }

    public GetResult get(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        throw new InvalidObjectIdException("This component does not support this method.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SetResult set(ObjectId objectId, Object object) throws InvalidValueException, InvalidObjectIdException, CommunicationException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        SetResult setResult = new SetResult();
        if (this.theState.getState() != 2) throw new InvalidObjectIdException("Unsupported operation.");
        if (objectId.equals((Object)SoftwareUpdateGroup.AutoUpdateEnabled.getObjectId())) {
            if (AutoUpdateComponent.isJapanese()) {
                setResult.setSuccessful(true);
                return setResult;
            } else if (object instanceof Boolean) {
                Boolean bl = (Boolean)object;
                if (bl.booleanValue() && !this.updatesEnabled.booleanValue()) {
                    this.updatesEnabled = Boolean.TRUE;
                    this.doCheckForUpdate();
                }
                this.updatesEnabled = bl;
                this.config.setProperty(kComponentName, "enableUpdateCheck", this.updatesEnabled);
                setResult.setSuccessful(true);
                return setResult;
            } else {
                setResult.setSuccessful(false);
            }
            return setResult;
        } else if (objectId.equals((Object)SoftwareUpdateGroup.Proxy.getObjectId())) {
            if (AutoUpdateComponent.isJapanese()) {
                setResult.setSuccessful(true);
                return setResult;
            } else {
                logger.debug("Setting Proxy");
                if (object == null) {
                    SoftwareUpdateCheckerHTTPS.setHTTPProxy(null);
                    setResult.setSuccessful(true);
                    return setResult;
                } else if (object instanceof String) {
                    SoftwareUpdateCheckerHTTPS.setHTTPProxy((String)object);
                    setResult.setSuccessful(true);
                    return setResult;
                } else {
                    setResult.setSuccessful(false);
                }
            }
            return setResult;
        } else {
            if (!objectId.equals((Object)SoftwareUpdateGroup.ProxyPort.getObjectId())) throw new InvalidObjectIdException("Unsupported operation.");
            if (AutoUpdateComponent.isJapanese()) {
                setResult.setSuccessful(true);
                return setResult;
            } else {
                logger.debug("Setting Proxy Port");
                if (object == null) {
                    SoftwareUpdateCheckerHTTPS.setHTTPProxyPort(null);
                    setResult.setSuccessful(true);
                    return setResult;
                } else if (object instanceof String) {
                    SoftwareUpdateCheckerHTTPS.setHTTPProxyPort((String)object);
                    setResult.setSuccessful(true);
                    return setResult;
                } else {
                    setResult.setSuccessful(false);
                }
            }
        }
        return setResult;
    }

    public Enumeration<ObjectId> getSupportedOids() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.addElement(SoftwareUpdateGroup.getGroup());
        return vector.elements();
    }

    public void setDataSource(IDataSource iDataSource) {
        this.theDataSource = iDataSource;
    }

    private void loadConfiguration() {
        this.updatesEnabled = this.config.getBoolean(kComponentName, "enableUpdateCheck", (boolean)Boolean.FALSE);
        URLValidator uRLValidator = new URLValidator(DEFAULT_UPDATE_URL);
        try {
            this.updateServerURL = this.config.getString(kComponentName, "updateServerURL", uRLValidator);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error((Object)illegalArgumentException);
        }
        catch (ConversionException conversionException) {
            logger.error((Object)conversionException);
        }
        UpdateIntervalValidator updateIntervalValidator = new UpdateIntervalValidator(DEFAULT_UPDATE_INTERVAL_STR);
        try {
            String string = this.config.getString(kComponentName, "updateCheckInterval", updateIntervalValidator);
            this.updateInterval = 0L;
            if (string.endsWith("s")) {
                this.updateInterval = Integer.parseInt(string.replace("s", ""));
                this.updateInterval = TimeUnit.MILLISECONDS.convert(this.updateInterval, TimeUnit.SECONDS);
            } else {
                this.updateInterval = Integer.parseInt(string);
                this.updateInterval = TimeUnit.MILLISECONDS.convert(this.updateInterval, TimeUnit.DAYS);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error((Object)illegalArgumentException);
        }
        catch (ConversionException conversionException) {
            logger.error((Object)conversionException);
        }
        this.devBuild = this.config.getBoolean(kComponentName, "devBuild", (boolean)Boolean.FALSE);
        this.skuName = this.config.getString(kComponentName, "skuSearchKeyword", DEFAULT_SKU_SEARCH_KEYWORD);
    }

    public Object getInstanceOf(ObjectId objectId) throws InvalidObjectIdException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        AutoUpdateComponent autoUpdateComponent = null;
        if (objectId.equals((Object)M11Component.kOid)) {
            autoUpdateComponent = this;
        } else if (objectId.equals((Object)Component.kOid)) {
            autoUpdateComponent = this;
        } else {
            logger.warn("Invalid Instance " + objectId.toString());
            throw new InvalidObjectIdException();
        }
        return autoUpdateComponent;
    }

    public void registerEventConsumer(IEventConsumer iEventConsumer) throws RegistrationException {
        this.theEventConsumers.addElement(iEventConsumer);
    }

    public void unRegisterEventConsumer(IEventConsumer iEventConsumer) throws RegistrationException {
        if (!this.theEventConsumers.removeElement(iEventConsumer)) {
            throw new RegistrationException(2);
        }
    }

    public void postEvent(Event event) {
        if (event.getObjectId() == null) {
            logger.warn("Attempted to send a null event");
        } else {
            Enumeration<IEventConsumer> enumeration = this.theEventConsumers.elements();
            logger.info("Sending " + String.valueOf(event));
            while (enumeration.hasMoreElements()) {
                IEventConsumer iEventConsumer = enumeration.nextElement();
                iEventConsumer.update(event);
            }
        }
    }

    protected int doCheckForUpdate() {
        logger.trace("doCheckForUpdate: started");
        int n = 1;
        if (this.updatesEnabled.booleanValue() && !AutoUpdateComponent.isJapanese()) {
            Object object;
            Object object2;
            this.checker.setServerURL(this.updateServerURL);
            boolean bl = true;
            try {
                object2 = this.theDataSource.get(Identification.FirmwareRevision.getObjectId());
                if (object2.getValue() instanceof String) {
                    object = (String)object2.getValue();
                    this.checker.setUps_fw((String)object);
                } else if (object2.getValue() instanceof Vector) {
                    object = (Vector)object2.getValue();
                    if (((Vector)object).isEmpty()) {
                        bl = false;
                    } else {
                        this.checker.setUps_fw((String)((Vector)object).firstElement());
                    }
                } else {
                    this.checker.setUps_fw(object2.getValue().getClass().getName());
                }
            }
            catch (InvalidObjectIdException invalidObjectIdException) {
                logger.debug("Unable to load FW value");
                bl = false;
            }
            catch (CommunicationException communicationException) {
                logger.debug("Unable to load FW value");
                bl = false;
            }
            if (!bl) {
                this.status = 5;
                return 1;
            }
            this.checker.setUniqueid(this.services.getProductVersion().getServerID());
            try {
                object2 = this.theDataSource.get(Identification.ModelName.getObjectId());
                if (object2.getValue() instanceof String) {
                    object = (String)object2.getValue();
                    this.checker.setUps_model((String)object);
                } else {
                    this.checker.setUps_model(object2.getValue().getClass().getName());
                }
            }
            catch (InvalidObjectIdException invalidObjectIdException) {
                logger.debug("Unable to load Model value");
            }
            catch (CommunicationException communicationException) {
                logger.debug("Unable to load Model value");
            }
            try {
                object2 = this.theDataSource.get(Identification.SerialNumber.getObjectId());
                if (object2.getValue() instanceof String) {
                    object = (String)object2.getValue();
                    this.checker.setUps_serial_no((String)object);
                } else {
                    this.checker.setUps_serial_no(object2.getValue().getClass().getName());
                }
            }
            catch (InvalidObjectIdException invalidObjectIdException) {
                logger.debug("Unable to load serial no");
            }
            catch (CommunicationException communicationException) {
                logger.debug("Unable to load serial No");
            }
            this.checker.setTags(this.getTags());
            this.lastChecked = new Date();
            if (this.checker.checkForUpdate().booleanValue()) {
                object2 = this.checker.getUpdateURL();
                object = this.checker.getUpdateDesc();
                if (object2 != null && !((String)object2).equals(this.updateURL) || object != null && !((String)object).equals(this.updateDes)) {
                    this.updateURL = object2;
                    this.updateDes = object;
                    this.updateVersion = this.checker.getUpdateVersion();
                    UpdateAvailableEvent updateAvailableEvent = new UpdateAvailableEvent(this.updateVersion, this.updateURL, this.updateDes);
                    String string = updateAvailableEvent.toString();
                    try {
                        string = updateAvailableEvent.getFormatter().format((Object)updateAvailableEvent);
                    }
                    catch (FormatterException formatterException) {
                        logger.error("Unable to get text for update event.  Using toString", (Throwable)formatterException);
                    }
                    catch (UnsupportedLocaleException unsupportedLocaleException) {
                        logger.error("Unable to get local for update event.  Using toString", (Throwable)unsupportedLocaleException);
                    }
                    this.services.getApplicationErrorHandler().put(string);
                    PcnsTrapGenerator.getInstance(this.theM11Storage, this.services).startTrap(PcnsTrapGenerator.pcnsUpdateAvailableTrap, string, false, 0, 10, 3);
                    n = this.updateURL != null && this.updateDes != null ? 4 : (this.updateDes == null ? 2 : 3);
                } else {
                    logger.debug("No new update Required");
                }
            }
            this.status = this.checker.getStatus();
        }
        logger.trace("doCheckForUpdate: completed");
        return n;
    }

    public static boolean isJapanese() {
        return ServiceManager.getInstance().getWebServerUtils().isJapanese();
    }

    @Generated
    public void setServices(ServiceManager serviceManager) {
        this.services = serviceManager;
    }
}

