/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.autoupdate;

import com.apcc.m11.components.autoupdate.SoftwareUpdateChecker;
import com.apcc.m11.util.Base64;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.AuthHelper;
import com.apcc.pcns.configservice.TrafficLightColours;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.trustmanagement.TrustStoreManager;
import com.apcc.pcns.util.OSVersionInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.crypto.KeyGenerator;
import javax.net.ssl.HttpsURLConnection;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;

public class SoftwareUpdateCheckerHTTPS
extends SoftwareUpdateChecker {
    private static final String UPDATES_UPS_INFO_MISSING = "Updates.UPSInfoMissing";
    private static final String UPDATES_UNABLE_TO_CONNECT = "Updates.UnableToConnect";
    private static final String UPDATES_INVALID_URL = "Updates.InvalidUrl";
    private static final String UPDATES_INVALID_RESPONSE = "Updates.InvalidResponse";
    private static final String UPDATES_AVAILABLE_UPDATES_NONE = "Updates.AvailableUpdatesNone";
    private static final Logger logger = LogManager.getLogger(SoftwareUpdateCheckerHTTPS.class);
    private static final String kEncodingParam = "UTF-8";
    public static final Class KEEP_ME = Security.class;
    private static final String kUpdateDelimeter = "&";
    private static final String kValueDelimeter = "=";
    private static final String kURL = "URL";
    private static final String kDesc = "DESC";
    private static final String kVer = "VER";
    private String kNoUpdateAvailable = "OK";
    private String kMalformedRequest = "Malformed Request";
    private static final String kProductNameField = "ProductName";
    private static final String kProductVersionField = "ProductVersion";
    private static final String kDevBuildField = "DevBuild";
    private static final String kSkuName = "SKUName";
    private static final String kOSNameField = "OSName";
    private static final String kOSEditionField = "OSEdition";
    private static final String kOSVersionField = "OSVersion";
    private static final String kJVMVersionField = "JVMVersion";
    private static final String kLanguageField = "Language";
    private static final String kCountryField = "Country";
    private static final String kServerUID = "ServerID";
    private static final String kUPSModelField = "UPSModel";
    private static final String kUPSSerialNoField = "UPSSerialNo";
    private static final String kUPSFWField = "UPSFWRev";
    private static final String kTagsField = "Tags";
    private TrustStoreManager trustStoreManager;

    public SoftwareUpdateCheckerHTTPS(String string, @NonNull TrustStoreManager trustStoreManager) {
        super(string);
        if (trustStoreManager == null) {
            throw new IllegalArgumentException("trustStoreManager is marked non-null but is null");
        }
        this.trustStoreManager = trustStoreManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean checkForUpdate() {
        Boolean bl;
        block30: {
            logger.info("checkForUpdate() - {}", (Object)this.serverURL);
            bl = Boolean.FALSE;
            HttpURLConnection httpURLConnection = null;
            PrintStream printStream = null;
            try {
                Object object;
                Object object2;
                String string;
                String string2;
                Object object3;
                URL uRL = new URL(this.serverURL);
                String string3 = SoftwareUpdateCheckerHTTPS.getHTTPSProxy();
                if (string3 != null) {
                    object3 = SoftwareUpdateCheckerHTTPS.getHTTPSProxyPort();
                    logger.debug("checkForUpdate() -Using proxy:" + string3 + ":" + (Integer)object3);
                    string2 = ServiceManager.getInstance().getVirtualConfigurationManager().getProxyUsername();
                    string = ServiceManager.getInstance().getVirtualConfigurationManager().getProxyPassword();
                    if (string2 != null) {
                        object2 = new Authenticator(){

                            @Override
                            public PasswordAuthentication getPasswordAuthentication() {
                                return new PasswordAuthentication(string2, string.toCharArray());
                            }
                        };
                        Authenticator.setDefault((Authenticator)object2);
                    }
                    object2 = new InetSocketAddress(string3, ((Integer)object3).intValue());
                    object = new Proxy(Proxy.Type.HTTP, (SocketAddress)object2);
                    httpURLConnection = (HttpsURLConnection)uRL.openConnection((Proxy)object);
                } else {
                    logger.debug("checkForUpdate() - No Proxy Configured");
                    httpURLConnection = (HttpsURLConnection)uRL.openConnection();
                }
                httpURLConnection.setReadTimeout(10000);
                httpURLConnection.setRequestMethod("GET");
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setDoInput(true);
                ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(this.trustStoreManager.makeSSLSocketFactory());
                object3 = httpURLConnection.getOutputStream();
                printStream = new PrintStream((OutputStream)object3);
                string2 = URLEncoder.encode(this.product_name, kEncodingParam);
                string = URLEncoder.encode(this.product_version, kEncodingParam);
                object2 = URLEncoder.encode(this.dev_build, kEncodingParam);
                object = URLEncoder.encode(this.skuName, kEncodingParam);
                String string4 = URLEncoder.encode(this.ups_model, kEncodingParam);
                String string5 = URLEncoder.encode(this.ups_serial_no, kEncodingParam);
                String string6 = URLEncoder.encode(this.ups_fw, kEncodingParam);
                String string7 = URLEncoder.encode(this.tags, kEncodingParam);
                String string8 = URLEncoder.encode(this.uniqueid, kEncodingParam);
                OSVersionInfo oSVersionInfo = OSVersionInfo.getOSVersionInfo();
                String string9 = oSVersionInfo.getName();
                String string10 = URLEncoder.encode(string9, kEncodingParam);
                String string11 = URLEncoder.encode(oSVersionInfo.getEdition(), kEncodingParam);
                String string12 = oSVersionInfo.getVersion();
                String string13 = URLEncoder.encode(string12, kEncodingParam);
                String string14 = System.getProperty("java.version") + " " + System.getProperty("java.vendor");
                String string15 = URLEncoder.encode(string14, kEncodingParam);
                String string16 = Locale.getDefault().getLanguage();
                String string17 = URLEncoder.encode(string16, kEncodingParam);
                String string18 = Locale.getDefault().getCountry();
                String string19 = URLEncoder.encode(string18, kEncodingParam);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("ProductName=" + string2 + kUpdateDelimeter);
                stringBuilder.append("ProductVersion=" + string + kUpdateDelimeter);
                if (this.dev_build.equals("1")) {
                    stringBuilder.append("DevBuild=" + (String)object2 + kUpdateDelimeter);
                }
                stringBuilder.append("SKUName=" + (String)object + kUpdateDelimeter);
                stringBuilder.append("OSName=" + string10 + kUpdateDelimeter);
                stringBuilder.append("OSEdition=" + string11 + kUpdateDelimeter);
                stringBuilder.append("OSVersion=" + string13 + kUpdateDelimeter);
                stringBuilder.append("JVMVersion=" + string15 + kUpdateDelimeter);
                stringBuilder.append("Language=" + string17 + kUpdateDelimeter);
                stringBuilder.append("Country=" + string19 + kUpdateDelimeter);
                stringBuilder.append("UPSModel=" + string4 + kUpdateDelimeter);
                stringBuilder.append("UPSSerialNo=" + string5 + kUpdateDelimeter);
                stringBuilder.append("UPSFWRev=" + string6 + kUpdateDelimeter);
                stringBuilder.append("Tags=" + string7 + kUpdateDelimeter);
                stringBuilder.append("ServerID=" + string8);
                logger.info("checkForUpdate() - Software Update Check Request: {}", (Object)stringBuilder.toString());
                printStream.println(stringBuilder.toString());
                httpURLConnection.connect();
                this.status = 1;
                if (httpURLConnection.getResponseCode() == 200) {
                    InputStream inputStream = null;
                    BufferedReader bufferedReader = null;
                    InputStreamReader inputStreamReader = null;
                    try {
                        Map<String, List<String>> map = httpURLConnection.getHeaderFields();
                        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                            String string20 = entry.getKey();
                            List<String> list = entry.getValue();
                            logger.info("Response Header: {} - {}", (Object)string20, list);
                        }
                        inputStream = httpURLConnection.getInputStream();
                        inputStreamReader = new InputStreamReader(inputStream);
                        bufferedReader = new BufferedReader(inputStreamReader);
                        Object object4 = bufferedReader.readLine();
                        logger.info("Response Body: {}", object4);
                        if (object4 != null) {
                            if (((String)(object4 = ((String)object4).trim())).equalsIgnoreCase(this.kNoUpdateAvailable)) {
                                logger.debug("checkForUpdate() - No update available");
                                this.updateURL = null;
                                this.updateDesc = null;
                            } else if (((String)object4).startsWith(this.kMalformedRequest)) {
                                logger.error("checkForUpdate() - Malformed Request:" + stringBuilder.toString());
                                this.updateURL = null;
                                this.updateDesc = null;
                            } else {
                                logger.debug("update available");
                                this.parseUpdatePath((String)object4);
                                bl = Boolean.TRUE;
                            }
                        }
                        logger.info("checkForUpdate() - Update URL: {}", (Object)StringUtils.defaultIfBlank((CharSequence)this.updateURL, (CharSequence)""));
                        logger.info("checkForUpdate() - Update Version: {}", (Object)StringUtils.defaultIfBlank((CharSequence)this.updateVersion, (CharSequence)""));
                        logger.info("checkForUpdate() - Update Description: {}", (Object)StringUtils.defaultIfBlank((CharSequence)this.updateDesc, (CharSequence)""));
                        break block30;
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                            inputStream = null;
                        }
                        if (bufferedReader != null) {
                            bufferedReader.close();
                            bufferedReader = null;
                        }
                        if (inputStreamReader != null) {
                            inputStreamReader.close();
                            inputStreamReader = null;
                        }
                    }
                }
                if (httpURLConnection.getResponseCode() == 500) {
                    logger.error("checkForUpdate() - Received http error response:{} from {} request:{}", (Object)httpURLConnection.getResponseCode(), (Object)this.serverURL, (Object)stringBuilder.toString());
                    this.status = 4;
                } else {
                    logger.error("checkForUpdate() - Received http error response:{} from {}", (Object)httpURLConnection.getResponseCode(), (Object)this.serverURL);
                    this.status = 4;
                }
            }
            catch (MalformedURLException malformedURLException) {
                logger.error((Object)malformedURLException);
                this.status = 2;
            }
            catch (IOException iOException) {
                logger.error((Object)iOException);
                this.status = 3;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.error((Object)illegalArgumentException);
                this.status = 3;
            }
            finally {
                if (printStream != null) {
                    printStream.close();
                }
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
        }
        this.updateOverviewPanelMessages(bl);
        logger.debug("checkForUpdate() - end");
        return bl;
    }

    private void updateOverviewPanelMessages(Boolean bl) {
        AuthHelper authHelper = ServiceManager.getInstance().getAuthHelper();
        if (bl.booleanValue()) {
            authHelper.setSoftwareUpdateStatus(TrafficLightColours.YELLOW);
            authHelper.setSoftwareUpdateResponseText(this.updateDesc);
        } else {
            authHelper.setSoftwareUpdateStatus(TrafficLightColours.RED);
            switch (this.status) {
                case 4: {
                    authHelper.setSoftwareUpdateResponseText(this.resources.getResourceBundle().getString(UPDATES_INVALID_RESPONSE));
                    break;
                }
                case 2: {
                    authHelper.setSoftwareUpdateResponseText(this.resources.getResourceBundle().getString(UPDATES_INVALID_URL));
                    break;
                }
                case 3: {
                    authHelper.setSoftwareUpdateResponseText(this.resources.getResourceBundle().getString(UPDATES_UNABLE_TO_CONNECT));
                    break;
                }
                case 5: {
                    authHelper.setSoftwareUpdateResponseText(this.resources.getResourceBundle().getString(UPDATES_UPS_INFO_MISSING));
                    break;
                }
                default: {
                    authHelper.setSoftwareUpdateStatus(TrafficLightColours.GREEN);
                    authHelper.setSoftwareUpdateResponseText(this.resources.getResourceBundle().getString(UPDATES_AVAILABLE_UPDATES_NONE));
                }
            }
        }
    }

    private void parseUpdatePath(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, kUpdateDelimeter);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, kValueDelimeter, true);
                if (stringTokenizer2.countTokens() < 3) continue;
                String string3 = stringTokenizer2.nextToken();
                stringTokenizer2.nextToken();
                StringBuilder stringBuilder = new StringBuilder(stringTokenizer2.nextToken());
                while (stringTokenizer2.hasMoreTokens()) {
                    stringBuilder.append(stringTokenizer2.nextToken());
                }
                if (string3.equals(kURL)) {
                    this.updateURL = Jsoup.clean((String)new String(Base64.decode((char[])stringBuilder.toString().toCharArray())), (Safelist)Safelist.basic());
                    try {
                        new URL(this.updateURL);
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.updateURL = null;
                        this.status = 4;
                    }
                    continue;
                }
                if (string3.equals(kDesc)) {
                    this.updateDesc = Jsoup.clean((String)new String(Base64.decode((char[])stringBuilder.toString().toCharArray())), (Safelist)Safelist.basic());
                    continue;
                }
                if (!string3.equals(kVer)) continue;
                this.updateVersion = Jsoup.clean((String)new String(Base64.decode((char[])stringBuilder.toString().toCharArray())), (Safelist)Safelist.basic());
            }
        }
    }

    public String getRandomNumber() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("DES");
            keyGenerator.init(new SecureRandom());
            return keyGenerator.generateKey().toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.error((Object)noSuchAlgorithmException);
            return null;
        }
    }

    public static synchronized void setHTTPProxy(String string) {
        String string2 = SoftwareUpdateCheckerHTTPS.getHTTPSProxy();
        if (string == null) {
            if (string2 != null) {
                ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
                configurationManager.setProperty("SoftwareUpdate", "updateProxy", "");
            }
        } else if (!string.equals(string2)) {
            ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
            configurationManager.setProperty("SoftwareUpdate", "updateProxy", string);
        }
    }

    public static synchronized void setHTTPProxyPort(String string) {
        Integer n = SoftwareUpdateCheckerHTTPS.getHTTPSProxyPort();
        if (string != null || n != 80) {
            if (string == null || string.equals("")) {
                ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
                configurationManager.setProperty("SoftwareUpdate", "updateProxyPort", null);
            } else if (n == null || !string.equals(n.toString())) {
                ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
                configurationManager.setProperty("SoftwareUpdate", "updateProxyPort", Integer.valueOf(string));
            }
        }
    }

    public static String getHTTPSProxy() {
        String string = null;
        ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
        try {
            if (configurationManager.containsKey("SoftwareUpdate", "updateProxy") && (string = configurationManager.getString("SoftwareUpdate", "updateProxy")).trim().equals("")) {
                string = null;
            }
        }
        catch (ConversionException conversionException) {
            logger.error((Object)conversionException);
        }
        return string;
    }

    public static Integer getHTTPSProxyPort() {
        Integer n = 80;
        ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
        try {
            if (configurationManager.containsKey("SoftwareUpdate", "updateProxyPort")) {
                String string = configurationManager.getString("SoftwareUpdate", "updateProxyPort");
                if (string == null || string.trim().equals("")) {
                    logger.debug("Using default update proxy port 80");
                } else {
                    logger.debug("Converting to int port value:" + string);
                    n = configurationManager.getInt("SoftwareUpdate", "updateProxyPort");
                }
            }
        }
        catch (ConversionException conversionException) {
            logger.error((Object)conversionException);
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.debug("Update Proxy Port missing.  Probably blank");
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
        return n;
    }

    @Generated
    public void setTrustStoreManager(TrustStoreManager trustStoreManager) {
        this.trustStoreManager = trustStoreManager;
    }
}

