/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.commandfilerunner;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.VariableBinding;
import com.apcc.m11.arch.component.ComponentFailureException;
import com.apcc.m11.arch.component.ComponentID;
import com.apcc.m11.arch.component.IComponent;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataConsumer;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.arch.m11component.IM11Component;
import com.apcc.m11.arch.m11component.M11ComponentSynchronizer;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.components.commandfilerunner.Executor;
import com.apcc.m11.components.commandfilerunner.Trigger;
import com.apcc.m11.ds.arch.interfaces.Component;
import com.apcc.m11.ds.arch.interfaces.DataConsumer;
import com.apcc.m11.ds.arch.interfaces.DataSource;
import com.apcc.m11.ds.arch.interfaces.EventConsumer;
import com.apcc.m11.ds.arch.interfaces.M11Component;
import com.apcc.m11.ds.events.flexevents.EventLists;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import com.apcc.m11.ds.services.commandExecution.CommandExecution;
import com.apcc.m11.ds.services.commandExecution.CommandFile;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.ConfigurationKeys;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.configservice.validation.IntRangeSetValidator;
import com.apcc.pcns.configservice.validation.UserFilePathValidator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.configuration2.reloading.ReloadingEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommandFileRunner
implements IM11Component,
IComponent,
IDataSource,
IDataConsumer {
    private static final Logger logger = LogManager.getLogger(CommandFileRunner.class);
    private static final String kComponentName = "CommandFileRunner";
    private static final String kComponentID = "CommandFileRunner";
    private static final String kComponentVersion = "1.0.0";
    private Trigger theTriggers = null;
    private M11ComponentSynchronizer theState = null;
    private IDataSource theDataSource = null;
    private Executor theExecutor = null;
    private EventListener<ConfigurationEvent> configEventListener;
    private EventListener<ReloadingEvent> configReloadEventListener;

    public void init(IPermanentStorage iPermanentStorage) throws ComponentFailureException {
        if (iPermanentStorage == null) {
            throw new ComponentFailureException("Permanent storage can't be null.");
        }
        logger.trace("In Command File Runner:  In Init ");
        this.theTriggers = new Trigger();
        this.initialize_internal_objects();
    }

    public void start() throws ComponentFailureException {
        logger.trace("In command file runner:  Started ");
        if (this.configEventListener == null) {
            this.configEventListener = new EventListener<ConfigurationEvent>(){

                public void onEvent(ConfigurationEvent configurationEvent) {
                    try {
                        if (!configurationEvent.isBeforeUpdate() && StringUtils.endsWithAny((CharSequence)configurationEvent.getPropertyName(), (CharSequence[])new CharSequence[]{"_enableCommandFile", "_commandFilePath", "_commandFileDelay", "_commandFileDuration"})) {
                            CommandFileRunner.this.loadConfiguration();
                        }
                    }
                    catch (Exception exception) {
                        logger.error("onEvent", (Throwable)exception);
                    }
                }
            };
        }
        if (this.configReloadEventListener == null) {
            this.configReloadEventListener = new EventListener<ReloadingEvent>(){

                public void onEvent(ReloadingEvent reloadingEvent) {
                    try {
                        CommandFileRunner.this.loadConfiguration();
                    }
                    catch (Exception exception) {
                        logger.error("onEvent", (Throwable)exception);
                    }
                }
            };
        }
        ServiceManager.getInstance().getConfigurationManager().addEventListener(ConfigurationEvent.SET_PROPERTY, this.configEventListener);
        ServiceManager.getInstance().getConfigurationManager().addReloadingEventListener(ReloadingEvent.ANY, this.configReloadEventListener);
        this.theState.setState(2);
        this.theExecutor.setDataSource(this.theDataSource);
    }

    public void stop() {
        ServiceManager.getInstance().getConfigurationManager().removeEventListener(ConfigurationEvent.SET_PROPERTY, this.configEventListener);
        ServiceManager.getInstance().getConfigurationManager().removeReloadingEventListener(ReloadingEvent.ANY, this.configReloadEventListener);
        this.theState.setState(1);
        this.theDataSource = null;
        this.theTriggers.stop();
        this.theTriggers = null;
        this.theExecutor.stop();
        this.theExecutor = null;
    }

    public Object getInterface(ObjectId objectId) throws InvalidObjectIdException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        Object object = null;
        if (objectId.equals((Object)DataSource.kOid)) {
            object = this;
        } else if (objectId.equals((Object)EventConsumer.kOid)) {
            object = this.theTriggers;
        } else if (objectId.equals((Object)DataConsumer.kOid)) {
            object = this;
        } else {
            logger.trace("getInterface: bad interfac ID (anInterfaceID)");
            throw new InvalidObjectIdException("Interface Not Supported");
        }
        return object;
    }

    public String getComponentName() {
        return "CommandFileRunner";
    }

    public ComponentID getComponentID() {
        return new ComponentID("CommandFileRunner");
    }

    public String getComponentVersion() {
        return kComponentVersion;
    }

    public void setDataSource(IDataSource iDataSource) {
        this.theDataSource = iDataSource;
    }

    public GetResult get(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        GetResult getResult = new GetResult();
        if (this.theState.getState() == 2) {
            if (!objectId.equals((Object)CommandExecution.ListOfCommandObjects.getObjectId())) {
                throw new InvalidObjectIdException("Unsupported operation.");
            }
        } else {
            throw new InvalidObjectIdException("Unsupported operation.");
        }
        getResult.setValue(this.theExecutor.getAllCommandFiles());
        return getResult;
    }

    public GetResult get(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult;
        block8: {
            block7: {
                if (objectId == null) {
                    throw new InvalidObjectIdException("ObjectId can't be null.");
                }
                getResult = new GetResult();
                if (this.theState.getState() != 2) break block7;
                switch (n) {
                    case 0: {
                        getResult = this.get(objectId);
                        break block8;
                    }
                    case 1: {
                        getResult.setValue((Object)Availability.AVAILABLE);
                        break block8;
                    }
                    case 2: {
                        getResult = new GetResult();
                        getResult.setError();
                        break block8;
                    }
                    case 3: {
                        getResult = new GetResult();
                        getResult.setError();
                        break block8;
                    }
                    default: {
                        logger.trace("Get:  bad ID or type");
                        throw new InvalidObjectIdException();
                    }
                }
            }
            logger.warn("Get:  command file runner not initialized");
            getResult.setError();
        }
        return getResult;
    }

    public GetResult get(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        throw new InvalidObjectIdException("This component does not support this method.");
    }

    public SetResult set(ObjectId objectId, Object object) throws InvalidValueException, InvalidObjectIdException, CommunicationException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        logger.trace("In command file runner: oid - " + objectId.toString());
        SetResult setResult = new SetResult();
        if (this.theState.getState() == 2) {
            if (objectId.equals((Object)CommandExecution.RegisterCommandToExecute.getObjectId())) {
                logger.trace("In command file runner: Register For Notification: aValue ");
                CommandFile commandFile = (CommandFile)object;
                this.theExecutor.addCommandFile(commandFile);
                VariableBinding variableBinding = new VariableBinding(commandFile.getEventToExecuteOn(), (Object)commandFile.getInitialDelay());
                this.theTriggers.addTrigger(variableBinding);
                this.writeCommandFilesToIni(this.theExecutor.getAllCommandFiles());
                setResult.setSuccessful(true);
            } else if (objectId.equals((Object)CommandExecution.UnRegisterCommandToExecute.getObjectId())) {
                CommandFile commandFile = (CommandFile)object;
                this.theExecutor.removeCommand(commandFile);
                VariableBinding variableBinding = new VariableBinding(commandFile.getEventToExecuteOn(), (Object)commandFile.getInitialDelay());
                this.theTriggers.removeTrigger(variableBinding);
                this.writeCommandFilesToIni(this.theExecutor.getAllCommandFiles());
                setResult.setSuccessful(true);
            } else if (objectId.equals((Object)CommandExecution.ExecuteNow.getObjectId())) {
                this.theExecutor.executeNow((Event)object, 0);
                setResult.setSuccessful(true);
            } else if (objectId.equals((Object)CommandExecution.CancelExecution.getObjectId())) {
                this.theExecutor.cancelExecution((ObjectId)object);
                setResult.setSuccessful(true);
            } else {
                throw new InvalidObjectIdException("Unsupported operation.");
            }
        }
        return setResult;
    }

    public Enumeration<ObjectId> getSupportedOids() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.addElement(CommandExecution.getGroup());
        return vector.elements();
    }

    private void initialize_internal_objects() throws ComponentFailureException {
        logger.trace("In command file runner:  setting up executor");
        this.theExecutor = new Executor(this.theDataSource, ServiceManager.getInstance().getOperatingSystemEventLogger());
        logger.trace("In command file runner:  initializing triggers");
        this.theTriggers.setConsumer(this.theExecutor);
        this.theState = new M11ComponentSynchronizer(1);
        this.loadConfiguration();
    }

    private void loadConfiguration() {
        this.theExecutor.removeAllCommands();
        this.theTriggers.removeAllTriggers();
        Hashtable<String, Vector<CommandFile>> hashtable = null;
        try {
            hashtable = this.readCommandFilesFromIni();
            Enumeration<Vector<CommandFile>> enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                Vector<CommandFile> vector = enumeration.nextElement();
                Enumeration<CommandFile> enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    CommandFile commandFile = enumeration2.nextElement();
                    this.theExecutor.addCommandFile(commandFile);
                    this.theTriggers.addTrigger(new VariableBinding(commandFile.getEventToExecuteOn(), (Object)commandFile.getInitialDelay()));
                }
            }
        }
        catch (Exception exception) {
            logger.warn("initialize_internal_objects:  could not read from permanent storage");
            logger.warn((Object)exception);
        }
    }

    private void writeCommandFilesToIni(Hashtable<String, Vector<CommandFile>> hashtable) {
        ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
        Map<ObjectId, String> map = EventLists.getAllEventsMap();
        for (Map.Entry<ObjectId, String> entry : map.entrySet()) {
            ObjectId objectId = entry.getKey();
            String string = entry.getValue();
            String string2 = objectId.toString();
            ConfigurationKeys configurationKeys = new ConfigurationKeys(string);
            Vector<CommandFile> vector = hashtable.get(string2);
            if (vector == null || vector.isEmpty()) {
                configurationManager.setProperty(configurationKeys.getSection(), configurationKeys.getEnableCommandFileKey(), Boolean.FALSE);
                continue;
            }
            UserFilePathValidator userFilePathValidator = new UserFilePathValidator();
            CommandFile commandFile = vector.firstElement();
            if (userFilePathValidator.isValid(commandFile.getPath(), true)) {
                configurationManager.setProperty(configurationKeys.getSection(), configurationKeys.getCommandFilePathKey(), commandFile.getPath());
                configurationManager.setProperty(configurationKeys.getSection(), configurationKeys.getCommandFileDelayKey(), commandFile.getInitialDelay());
                configurationManager.setProperty(configurationKeys.getSection(), configurationKeys.getCommandFileDurationKey(), commandFile.getPeriodicInterval());
                configurationManager.setProperty(configurationKeys.getSection(), configurationKeys.getEnableCommandFileKey(), Boolean.TRUE);
                continue;
            }
            logger.warn("writeCommandFilesToIni() - Invalid file path detected.  Write to INI for event: {} {} is rejected.", (Object)configurationKeys.getSection(), (Object)configurationKeys.getCommandFilePathKey());
            configurationManager.setProperty(configurationKeys.getSection(), configurationKeys.getEnableCommandFileKey(), Boolean.FALSE);
        }
    }

    private Hashtable<String, Vector<CommandFile>> readCommandFilesFromIni() {
        logger.debug("Reading command file params from ini");
        Hashtable<String, Vector<CommandFile>> hashtable = new Hashtable<String, Vector<CommandFile>>();
        ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
        VirtualConfigurationManager virtualConfigurationManager = ServiceManager.getInstance().getVirtualConfigurationManager();
        Map<ObjectId, String> map = EventLists.getAllEventsMap();
        for (Map.Entry<ObjectId, String> entry : map.entrySet()) {
            ObjectId objectId = entry.getKey();
            if (objectId == null || objectId.toString().equalsIgnoreCase(ShutdownEvents.ShutdownStarting.getObjectId().toString())) continue;
            String string = entry.getValue();
            String string2 = objectId.toString();
            ConfigurationKeys configurationKeys = new ConfigurationKeys(string);
            boolean bl = configurationManager.getBoolean(configurationKeys.getSection(), configurationKeys.getEnableCommandFileKey(), (boolean)Boolean.FALSE);
            logger.debug("Event: " + string2 + " is enabled: " + bl);
            if (!bl) continue;
            try {
                String string3 = virtualConfigurationManager.getShutdownCommandFile(configurationKeys.getSection(), configurationKeys.getCommandFilePathKey());
                int n = this.getInitialDelay(string);
                int n2 = this.getExecutionTime(string);
                CommandFile commandFile = new CommandFile(string3, objectId, n, n2);
                Vector<CommandFile> vector = new Vector<CommandFile>();
                vector.add(commandFile);
                hashtable.put(string2, vector);
            }
            catch (IllegalArgumentException | IllegalStateException | ConversionException throwable) {
                logger.error((Object)throwable);
            }
        }
        return hashtable;
    }

    private int getExecutionTime(String string) {
        int n = 0;
        ConfigurationKeys configurationKeys = new ConfigurationKeys(string);
        IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(0);
        intRangeSetValidator.add(0, 7200);
        try {
            n = ServiceManager.getInstance().getConfigurationManager().getInt(configurationKeys.getSection(), configurationKeys.getCommandFileDurationKey(), intRangeSetValidator);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error((Object)illegalArgumentException);
            n = 0;
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error((Object)noSuchElementException);
            n = 0;
        }
        catch (ConversionException conversionException) {
            logger.error((Object)conversionException);
            n = 0;
        }
        return n;
    }

    private int getInitialDelay(String string) {
        int n = 0;
        ConfigurationKeys configurationKeys = new ConfigurationKeys(string);
        IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(0);
        intRangeSetValidator.add(0, 172800);
        try {
            n = ServiceManager.getInstance().getConfigurationManager().getInt(configurationKeys.getSection(), configurationKeys.getCommandFileDelayKey(), intRangeSetValidator);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error((Object)illegalArgumentException);
            n = 0;
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.trace((Object)noSuchElementException);
            n = 0;
        }
        catch (ConversionException conversionException) {
            logger.error((Object)conversionException);
            n = 0;
        }
        return n;
    }

    public Object getInstanceOf(ObjectId objectId) throws InvalidObjectIdException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        CommandFileRunner commandFileRunner = null;
        if (objectId.equals((Object)M11Component.kOid)) {
            commandFileRunner = this;
        } else if (objectId.equals((Object)Component.kOid)) {
            commandFileRunner = this;
        } else {
            logger.warn("Invalid Instance " + objectId.toString());
            throw new InvalidObjectIdException();
        }
        return commandFileRunner;
    }
}

