/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.commandfilerunner;

import com.apcc.m11.arch.FormatterException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.arch.datasource.IDataConsumer;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.commandfilerunner.ReadBufferThread;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.ds.services.commandExecution.CommandFile;
import com.apcc.m11.ds.services.omaha.IFlexEventDescriptor;
import com.apcc.m11.ds.services.omaha.Omaha;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.oslogger.OperatingSystemEventLogger;
import com.apcc.pcns.util.CountdownTimer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Vector;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DelayedExecutor
extends Thread
implements IDataConsumer {
    private static final Logger LOGGER = LogManager.getLogger(DelayedExecutor.class);
    private IDataSource theDataSource;
    private static final String kDefaultLogFile = "cmdfile.log";
    private String theLogFile = "cmdfile.log";
    private boolean theExecutionIsEnabled = true;
    private Vector<CommandFile> theCommandList = null;
    private int theDelayTime = 0;
    private Event theEvent;
    private int thePeriodicInterval = 0;
    private String theEventText;
    @NonNull
    private OperatingSystemEventLogger osLogger;

    public DelayedExecutor(@NonNull OperatingSystemEventLogger operatingSystemEventLogger, Vector<CommandFile> vector, Event event, int n, int n2) {
        this(operatingSystemEventLogger, vector, event, n, n2, null);
        if (operatingSystemEventLogger == null) {
            throw new IllegalArgumentException("osLogger is marked non-null but is null");
        }
    }

    public DelayedExecutor(@NonNull OperatingSystemEventLogger operatingSystemEventLogger, Vector<CommandFile> vector, Event event, int n, int n2, String string) {
        if (operatingSystemEventLogger == null) {
            throw new IllegalArgumentException("osLogger is marked non-null but is null");
        }
        this.osLogger = operatingSystemEventLogger;
        this.theCommandList = vector;
        this.theEvent = event;
        this.theDelayTime = n;
        this.thePeriodicInterval = n2;
        this.theEventText = string;
    }

    public void setDataSource(IDataSource iDataSource) {
        this.theDataSource = iDataSource;
    }

    @Override
    public void run() {
        LOGGER.debug("run: {}", (Object)this.theEvent.getObjectId());
        new CountdownTimer(this.theDelayTime).sleep();
        LOGGER.debug("run now: {}", (Object)this.theEvent.getObjectId());
        if (this.thePeriodicInterval > 0) {
            while (this.isExecutionEnabled()) {
                this.execute_command();
                new CountdownTimer(this.thePeriodicInterval).sleep();
            }
        } else if (this.isExecutionEnabled()) {
            this.execute_command();
        }
    }

    public void stayExecution() {
        this.disableExecution();
    }

    public ObjectId getTriggerId() {
        return this.theEvent.getObjectId();
    }

    private synchronized void disableExecution() {
        this.theExecutionIsEnabled = false;
    }

    private synchronized boolean isExecutionEnabled() {
        return this.theExecutionIsEnabled;
    }

    private void execute_command() {
        LOGGER.debug("execute_command");
        Runtime runtime = Runtime.getRuntime();
        Enumeration<CommandFile> enumeration = this.theCommandList.elements();
        this.deleteLogFile(this.theLogFile);
        while (enumeration.hasMoreElements()) {
            CommandFile commandFile = enumeration.nextElement();
            String string = StringUtils.trim((String)commandFile.getPath());
            if (string.length() <= 0) continue;
            try {
                Object object;
                Object object2;
                Cloneable cloneable;
                String[] stringArray;
                LOGGER.debug("preparing to run command file {}", (Object)string);
                IFlexEventDescriptor iFlexEventDescriptor = null;
                try {
                    stringArray = this.theDataSource.get(Omaha.FlexEventList.getObjectId());
                    cloneable = (Vector)stringArray.getValue();
                    object2 = ((Vector)cloneable).iterator();
                    while (object2.hasNext()) {
                        object = (IFlexEventDescriptor)object2.next();
                        if (!object.getObjectId().equals((Object)this.theEvent.getObjectId())) continue;
                        iFlexEventDescriptor = object;
                        break;
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("Unable to get event Description");
                }
                stringArray = null;
                cloneable = Locale.getDefault();
                stringArray = this.theEvent instanceof AdvancedGroupEvent ? new String[7] : new String[5];
                stringArray[0] = string;
                this.theEvent.getFormatter();
                if (iFlexEventDescriptor != null) {
                    stringArray[1] = iFlexEventDescriptor.getHMTLId();
                    stringArray[2] = iFlexEventDescriptor.getDescriptionFormatter().format((Object)this.theEvent);
                } else {
                    object2 = this.theEvent.getFormatter();
                    if (object2 != null) {
                        try {
                            stringArray[1] = object2.format((Object)this.theEvent, (Locale)cloneable);
                            stringArray[2] = object2.format((Object)this.theEvent, (Locale)cloneable);
                        }
                        catch (Exception exception) {}
                    } else {
                        LOGGER.error("No event formatter for event: {}", (Object)this.theEvent.getObjectId().toString());
                        stringArray[1] = this.theEvent.getObjectId().toString();
                        stringArray[2] = this.theEvent.toString();
                    }
                }
                if (this.theEvent.getFormatter() != null) {
                    try {
                        stringArray[2] = this.theEvent.getFormatter().format((Object)this.theEvent, (Locale)cloneable);
                    }
                    catch (MissingResourceException missingResourceException) {
                        stringArray[2] = " UNKNOWN";
                    }
                }
                stringArray[3] = this.theEvent.getTimestampFormatter().format((Object)this.theEvent.getTimestamp(), (Locale)cloneable);
                stringArray[4] = String.valueOf(this.theDelayTime);
                LOGGER.debug("preparing to run command file: {}", (Object)stringArray[0]);
                LOGGER.debug("arg1: {}", (Object)stringArray[1]);
                LOGGER.debug("arg2: {}", (Object)stringArray[2]);
                LOGGER.debug("arg3: {}", (Object)stringArray[3]);
                LOGGER.debug("arg4: {}", (Object)stringArray[4]);
                if (this.theEvent instanceof AdvancedGroupEvent) {
                    object2 = (AdvancedGroupEvent)this.theEvent;
                    stringArray[5] = Integer.toString(((AdvancedGroupEvent)((Object)object2)).getGroup());
                    stringArray[6] = ((AdvancedGroupEvent)((Object)object2)).getGroupName();
                    LOGGER.debug("arg5: {}", (Object)stringArray[5]);
                    LOGGER.debug("arg6: {}", (Object)stringArray[6]);
                }
                if (this.theEventText != null && !this.theEventText.trim().isEmpty()) {
                    ServiceManager.getInstance().getApplicationErrorHandler().put(this.theEventText);
                }
                object2 = runtime.exec(stringArray);
                object = new BufferedInputStream(((Process)object2).getInputStream());
                BufferedInputStream bufferedInputStream = new BufferedInputStream(((Process)object2).getErrorStream());
                ReadBufferThread readBufferThread = new ReadBufferThread((BufferedInputStream)object, this.theLogFile);
                ReadBufferThread readBufferThread2 = new ReadBufferThread(bufferedInputStream, this.theLogFile);
                readBufferThread.start();
                readBufferThread2.start();
            }
            catch (FormatterException | UnsupportedLocaleException | IOException throwable) {
                LOGGER.warn("Could not launch command file {}", (Object)commandFile.getPath(), (Object)throwable);
                this.osLogger.warn("Oslogger.CommandFile.Error", "110", commandFile.getPath());
            }
        }
    }

    private synchronized void deleteLogFile(String string) {
        File file = new File("cmdfile.cfg");
        if (file.exists()) {
            return;
        }
        File file2 = new File(string);
        if (file2.exists() && !file2.delete()) {
            LOGGER.info("Failed to delete: {}", (Object)file2.getName());
        }
    }

    @Generated
    public void setOsLogger(@NonNull OperatingSystemEventLogger operatingSystemEventLogger) {
        if (operatingSystemEventLogger == null) {
            throw new IllegalArgumentException("osLogger is marked non-null but is null");
        }
        this.osLogger = operatingSystemEventLogger;
    }
}

