/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.commandfilerunner;

import com.apcc.m11.arch.FormatterException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.arch.datasource.IDataConsumer;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.commandfilerunner.DelayedExecutor;
import com.apcc.m11.components.commandfilerunner.ITriggerConsumer;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import com.apcc.m11.ds.services.commandExecution.CommandFile;
import com.apcc.pcns.oslogger.OperatingSystemEventLogger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Executor
implements ITriggerConsumer,
IDataConsumer {
    private static final Logger logger = LogManager.getLogger(Executor.class);
    private static final String kResourceBundle = "com.apcc.m11.components.shutdowner.i18n.ShutdownFormatters";
    private IDataSource theDataSource;
    private OperatingSystemEventLogger osLogger;
    private Vector<DelayedExecutor> theDelayedExecutors;
    private Hashtable<String, Vector<CommandFile>> theCommandFiles;

    public Executor(IDataSource iDataSource, OperatingSystemEventLogger operatingSystemEventLogger) {
        this.osLogger = operatingSystemEventLogger;
        this.theDelayedExecutors = new Vector();
        this.theCommandFiles = new Hashtable();
        this.theDataSource = iDataSource;
    }

    public void setDataSource(IDataSource iDataSource) {
        this.theDataSource = iDataSource;
    }

    @Override
    public void triggerOccurred(Event event, int n) {
        this.executeNow(event, n);
    }

    @Override
    public synchronized void triggerCanceled(Event event) {
        this.cancelExecution(event.getObjectId());
    }

    public void addCommandFile(CommandFile commandFile) {
        ObjectId objectId = commandFile.getEventToExecuteOn();
        Vector<CommandFile> vector = new Vector<CommandFile>();
        this.removeCommand(commandFile);
        vector.addElement(commandFile);
        this.theCommandFiles.put(objectId.toString(), vector);
    }

    public void removeCommand(CommandFile commandFile) {
        ObjectId objectId = commandFile.getEventToExecuteOn();
        this.theCommandFiles.remove(objectId.toString());
    }

    public void removeAllCommands() {
        this.theCommandFiles.clear();
    }

    public Vector<CommandFile> getCommandFiles(ObjectId objectId) {
        return this.theCommandFiles.get(objectId.toString());
    }

    public Hashtable<String, Vector<CommandFile>> getAllCommandFiles() {
        return (Hashtable)this.theCommandFiles.clone();
    }

    public void cancelExecution(ObjectId objectId) {
        logger.debug("cancelExecution:" + String.valueOf(objectId));
        Enumeration<DelayedExecutor> enumeration = this.theDelayedExecutors.elements();
        while (enumeration.hasMoreElements()) {
            DelayedExecutor delayedExecutor = enumeration.nextElement();
            ObjectId objectId2 = delayedExecutor.getTriggerId();
            if (!objectId2.equals((Object)objectId)) continue;
            logger.info("Execution canceled by:" + String.valueOf(objectId));
            delayedExecutor.stayExecution();
            delayedExecutor.interrupt();
            this.theDelayedExecutors.remove(delayedExecutor);
        }
    }

    public void executeNow(Event event, int n) {
        Vector<CommandFile> vector = this.theCommandFiles.get(event.getObjectId().toString());
        logger.info("Execution triggered by:" + String.valueOf(event.getObjectId()));
        Event event2 = Utils.formatRunCommandFile(event, kResourceBundle, ShutdownEvents.CmdFileStarting.getObjectId(), 0);
        String string = "";
        if (vector != null && !vector.isEmpty()) {
            string = vector.get(0).getPath();
        }
        try {
            string = event2.getFormatter().format((Object)event2);
        }
        catch (FormatterException formatterException) {
            logger.warn("Unable to format command file message");
        }
        catch (UnsupportedLocaleException unsupportedLocaleException) {
            logger.warn("Unable to format command file message for Locale");
        }
        DelayedExecutor delayedExecutor = new DelayedExecutor(this.osLogger, vector, event, n, 0, string);
        delayedExecutor.setDataSource(this.theDataSource);
        this.theDelayedExecutors.addElement(delayedExecutor);
        delayedExecutor.start();
        Enumeration<DelayedExecutor> enumeration = this.theDelayedExecutors.elements();
        while (enumeration.hasMoreElements()) {
            DelayedExecutor delayedExecutor2 = enumeration.nextElement();
            if (delayedExecutor2.isAlive()) continue;
            logger.trace("Cleaning out completed DelayedExecutor:" + String.valueOf(delayedExecutor2.getTriggerId()));
            this.theDelayedExecutors.remove(delayedExecutor2);
        }
        logger.info("Pending Script count:" + this.theDelayedExecutors.size());
    }

    public void stop() {
        Enumeration<String> enumeration = this.theCommandFiles.keys();
        while (enumeration.hasMoreElements()) {
            this.cancelExecution(new ObjectId(enumeration.nextElement()));
        }
    }
}

