/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.commandfilerunner;

import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.RegistrationException;
import com.apcc.m11.arch.VariableBinding;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.arch.event.IEventConsumer;
import com.apcc.m11.arch.event.IEventProducer;
import com.apcc.m11.components.commandfilerunner.ITriggerConsumer;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Trigger
implements IEventConsumer {
    private static final Logger logger = LogManager.getLogger(Trigger.class);
    private Vector<VariableBinding> theTriggers = null;
    private IEventProducer theEventProducer = null;
    private ITriggerConsumer theTriggerConsumer;

    public Trigger(ITriggerConsumer iTriggerConsumer) {
        this.theTriggerConsumer = iTriggerConsumer;
        this.theTriggers = new Vector();
    }

    public Trigger() {
        this.theTriggers = new Vector();
    }

    public void setConsumer(ITriggerConsumer iTriggerConsumer) {
        this.theTriggerConsumer = iTriggerConsumer;
    }

    public void registerEventProducer(IEventProducer iEventProducer) throws RegistrationException {
        this.theEventProducer = iEventProducer;
        this.theEventProducer.registerEventConsumer((IEventConsumer)this);
    }

    public void unRegisterEventProducer(IEventProducer iEventProducer) throws RegistrationException {
        this.theEventProducer.unRegisterEventConsumer((IEventConsumer)this);
    }

    public Enumeration<ObjectId> getConsumedEvents() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        Enumeration<VariableBinding> enumeration = this.theTriggers.elements();
        while (enumeration.hasMoreElements()) {
            VariableBinding variableBinding = enumeration.nextElement();
            vector.addElement(variableBinding.getObjectId());
        }
        return vector.elements();
    }

    public void update(Event event) {
        if (this.isCancelEvent(event)) {
            logger.debug("cancel event" + String.valueOf(event.getObjectId()));
            this.theTriggerConsumer.triggerCanceled(event);
        } else if (this.isTriggerEvent(event)) {
            logger.debug("set event" + String.valueOf(event.getObjectId()));
            int n = 0;
            ObjectId objectId = null;
            try {
                objectId = event.getObjectId();
                n = this.get_trigger_delay_time(objectId);
                this.theTriggerConsumer.triggerOccurred(event, n);
            }
            catch (InvalidObjectIdException invalidObjectIdException) {
                logger.trace("update: bad trigger (object_id,delay_time)", (Throwable)invalidObjectIdException);
            }
        }
    }

    public Vector<VariableBinding> getTriggers() {
        return this.theTriggers;
    }

    public void addTrigger(VariableBinding variableBinding) {
        try {
            this.delete_trigger(variableBinding);
            if (this.theEventProducer != null) {
                this.theEventProducer.unRegisterEventConsumer((IEventConsumer)this);
                this.theTriggers.addElement(variableBinding);
                this.theEventProducer.registerEventConsumer((IEventConsumer)this);
            } else {
                this.theTriggers.addElement(variableBinding);
            }
        }
        catch (RegistrationException registrationException) {
            logger.trace("addTrigger (aVarBind), model", (Throwable)registrationException);
        }
    }

    public void removeTrigger(VariableBinding variableBinding) {
        try {
            if (this.theEventProducer != null) {
                this.theEventProducer.unRegisterEventConsumer((IEventConsumer)this);
            }
            this.delete_trigger(variableBinding);
            if (this.theEventProducer != null) {
                this.theEventProducer.registerEventConsumer((IEventConsumer)this);
            }
        }
        catch (RegistrationException registrationException) {
            logger.trace("removeTrigger (aVarBind), model", (Throwable)registrationException);
        }
    }

    public void removeAllTriggers() {
        try {
            if (this.theEventProducer != null) {
                this.theEventProducer.unRegisterEventConsumer((IEventConsumer)this);
            }
            this.theTriggers.clear();
            if (this.theEventProducer != null) {
                this.theEventProducer.registerEventConsumer((IEventConsumer)this);
            }
        }
        catch (RegistrationException registrationException) {
            logger.trace("removeAllTriggers (aVarBind), model", (Throwable)registrationException);
        }
    }

    public void stop() {
        try {
            this.theEventProducer.unRegisterEventConsumer((IEventConsumer)this);
        }
        catch (Exception exception) {
            logger.trace("stop could not unregister with event producer", (Throwable)exception);
        }
    }

    private int get_trigger_delay_time(ObjectId objectId) throws InvalidObjectIdException {
        int n = 0;
        Enumeration<VariableBinding> enumeration = this.theTriggers.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements() && !bl) {
            VariableBinding variableBinding = enumeration.nextElement();
            if (!variableBinding.getObjectId().equals((Object)objectId)) continue;
            n = (Integer)variableBinding.getValue();
            bl = true;
        }
        if (!bl) {
            throw new InvalidObjectIdException();
        }
        return n;
    }

    private boolean isCancelEvent(Event event) {
        boolean bl = false;
        if (!event.isActive()) {
            Enumeration<VariableBinding> enumeration = this.theTriggers.elements();
            ObjectId objectId = event.getObjectId();
            while (enumeration.hasMoreElements()) {
                VariableBinding variableBinding = enumeration.nextElement();
                if (!objectId.equals((Object)variableBinding.getObjectId())) continue;
                bl = true;
            }
        }
        return bl;
    }

    private boolean isTriggerEvent(Event event) {
        boolean bl = false;
        if (event.isActive()) {
            Enumeration<VariableBinding> enumeration = this.theTriggers.elements();
            ObjectId objectId = event.getObjectId();
            while (enumeration.hasMoreElements()) {
                VariableBinding variableBinding = enumeration.nextElement();
                if (!objectId.equals((Object)variableBinding.getObjectId())) continue;
                bl = true;
            }
        }
        return bl;
    }

    private void delete_trigger(VariableBinding variableBinding) {
        int n = this.theTriggers.size();
        boolean bl = false;
        for (int i = 0; i <= n - 1 && !bl; ++i) {
            VariableBinding variableBinding2 = this.theTriggers.elementAt(i);
            if (!variableBinding.getObjectId().equals((Object)variableBinding2.getObjectId())) continue;
            this.theTriggers.removeElementAt(i);
            i = -1;
            n = this.theTriggers.size();
        }
    }
}

