/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.eventlogger;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.RegistrationException;
import com.apcc.m11.arch.VariableBinding;
import com.apcc.m11.arch.component.ComponentFailureException;
import com.apcc.m11.arch.component.ComponentID;
import com.apcc.m11.arch.component.IComponent;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.arch.event.IEventProducer;
import com.apcc.m11.arch.m11component.IM11Component;
import com.apcc.m11.arch.m11component.M11ComponentSynchronizer;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.components.eventlogger.Trigger;
import com.apcc.m11.components.eventlogger.logger.IndependentLogger;
import com.apcc.m11.ds.arch.interfaces.Component;
import com.apcc.m11.ds.arch.interfaces.DataConsumer;
import com.apcc.m11.ds.arch.interfaces.DataSource;
import com.apcc.m11.ds.arch.interfaces.EventConsumer;
import com.apcc.m11.ds.arch.interfaces.M11Component;
import com.apcc.m11.ds.events.flexevents.EventLists;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import com.apcc.m11.ds.events.flexevents.powersource.MultipleEvent;
import com.apcc.m11.ds.services.eventlogginggroup.EventLoggingGroup;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.ConfigurationKeys;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.configservice.validation.IntRangeSetValidator;
import com.apcc.pcns.util.CountdownTimer;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.configuration2.reloading.ReloadingEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EventLogger
implements IM11Component,
IComponent,
IDataSource {
    private static final Logger logger = LogManager.getLogger(EventLogger.class);
    private static final String kComponentName = "Event Logger";
    private static final String kComponentVersion = "1.0.0";
    private static final int DEFAULT_LOG_SIZE = 1000;
    public static final int MIN_LOG_SIZE = 500;
    public static final int MAX_LOG_SIZE = 10000;
    private Trigger theTriggers = null;
    private M11ComponentSynchronizer theState = new M11ComponentSynchronizer(1);
    private IndependentLogger theIndependentLogger = null;
    private Integer theLogSize = null;
    private String theLogLocation = null;
    private ConfigurationManager config = ServiceManager.getInstance().getConfigurationManager();
    private EventListener<ConfigurationEvent> configEventListener;
    private EventListener<ReloadingEvent> configReloadListener;

    public void init(IPermanentStorage iPermanentStorage) throws ComponentFailureException {
        if (iPermanentStorage == null) {
            throw new ComponentFailureException("Permanent storage can't be null.");
        }
        try {
            this.theIndependentLogger = new IndependentLogger(iPermanentStorage, ServiceManager.getInstance());
        }
        catch (IOException iOException) {
            logger.error("init:  Independent logger failure", (Throwable)iOException);
            throw new ComponentFailureException("Independent Logger failure");
        }
        this.theTriggers = new Trigger();
        this.theTriggers.addTriggerConsumer(this.theIndependentLogger);
        this.theTriggers.addTriggerConsumer(ServiceManager.getInstance().getOperatingSystemEventLogger());
        this.loadConfiguration();
        VariableBinding variableBinding = new VariableBinding(ShutdownEvents.GroupTurnOffStarting.getObjectId(), (Object)0);
        this.theTriggers.addTrigger(variableBinding);
        variableBinding = new VariableBinding(ShutdownEvents.CmdFileStarting.getObjectId(), (Object)0);
        this.theTriggers.addTrigger(variableBinding);
        variableBinding = new VariableBinding(ShutdownEvents.ShutdownCmdFileStarting.getObjectId(), (Object)0);
        this.theTriggers.addTrigger(variableBinding);
        variableBinding = new VariableBinding(ShutdownEvents.CmdFileDone.getObjectId(), (Object)0);
        this.theTriggers.addTrigger(variableBinding);
        variableBinding = new VariableBinding(MultipleEvent.SingleUPSEvent.getObjectId(), (Object)0);
        this.theTriggers.addTrigger(variableBinding);
    }

    public void start() throws ComponentFailureException {
        if (this.configEventListener == null) {
            this.configEventListener = new EventListener<ConfigurationEvent>(){

                public void onEvent(ConfigurationEvent configurationEvent) {
                    try {
                        if (!configurationEvent.isBeforeUpdate() && StringUtils.startsWithAny((CharSequence)configurationEvent.getPropertyName(), (CharSequence[])new CharSequence[]{"EventLog", "_enableLogging"})) {
                            EventLogger.this.loadConfiguration();
                        }
                    }
                    catch (Exception exception) {
                        logger.error("onEvent", (Throwable)exception);
                    }
                }
            };
        }
        if (this.configReloadListener == null) {
            this.configReloadListener = new EventListener<ReloadingEvent>(){

                public void onEvent(ReloadingEvent reloadingEvent) {
                    try {
                        EventLogger.this.loadConfiguration();
                    }
                    catch (Exception exception) {
                        logger.error("onEvent", (Throwable)exception);
                    }
                }
            };
        }
        this.config.addEventListener(ConfigurationEvent.SET_PROPERTY, this.configEventListener);
        this.config.addReloadingEventListener(ReloadingEvent.ANY, this.configReloadListener);
        this.theIndependentLogger.start();
        CountdownTimer.seconds(1L).sleep();
        this.theState.setState(2);
        ServiceManager.getInstance().getApplicationErrorHandler().setPaused(false);
    }

    public void stop() {
        this.config.removeEventListener(ConfigurationEvent.SET_PROPERTY, this.configEventListener);
        this.config.removeReloadingEventListener(ReloadingEvent.ANY, this.configReloadListener);
        ServiceManager.getInstance().getApplicationErrorHandler().setPaused(true);
        this.theState.setState(1);
        if (this.theTriggers != null) {
            this.theTriggers.stop();
            this.theTriggers = null;
        }
        if (this.theIndependentLogger != null) {
            this.theIndependentLogger.stop_logging();
            this.theIndependentLogger = null;
        }
    }

    public Object getInterface(ObjectId objectId) throws InvalidObjectIdException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        Object object = null;
        if (objectId.equals((Object)DataSource.kOid)) {
            object = this;
        } else if (objectId.equals((Object)EventConsumer.kOid)) {
            object = this.theTriggers;
        } else if (objectId.equals((Object)DataConsumer.kOid)) {
            object = ServiceManager.getInstance().getApplicationErrorHandler();
        } else {
            logger.trace("getInterface: bad interfac ID (anInterfaceID)");
            throw new InvalidObjectIdException("Interface Not Supported");
        }
        return object;
    }

    public String getComponentName() {
        return kComponentName;
    }

    public ComponentID getComponentID() {
        return new ComponentID("EventLogger");
    }

    public String getComponentVersion() {
        return kComponentVersion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GetResult get(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        GetResult getResult = new GetResult();
        if (this.theState.getState() != 2) throw new InvalidObjectIdException("Unsupported operation.");
        if (!objectId.equals((Object)EventLoggingGroup.ListOfEventsToLog.getObjectId())) {
            if (objectId.equals((Object)EventLoggingGroup.LoggedEvents.getObjectId())) {
                return this.theIndependentLogger.get(objectId);
            }
            if (objectId.equals((Object)EventLoggingGroup.LogFileMaximumSize.getObjectId())) {
                return this.theIndependentLogger.get(objectId);
            }
            if (!objectId.equals((Object)EventLoggingGroup.LogFileLocation.getObjectId())) throw new InvalidObjectIdException("Unsupported operation.");
            return this.theIndependentLogger.get(objectId);
        }
        getResult.setValue(this.theTriggers.getTriggers());
        return getResult;
    }

    public GetResult get(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult;
        block7: {
            block6: {
                getResult = new GetResult();
                if (this.theState.getState() != 2) break block6;
                switch (n) {
                    case 0: {
                        getResult = this.get(objectId);
                        break block7;
                    }
                    case 1: {
                        getResult.setValue((Object)Availability.AVAILABLE);
                        break block7;
                    }
                    case 2: {
                        getResult = new GetResult();
                        getResult.setError();
                        break block7;
                    }
                    case 3: {
                        getResult = new GetResult();
                        getResult.setError();
                        break block7;
                    }
                    default: {
                        logger.trace("Get:  bad ID or type");
                        throw new InvalidObjectIdException();
                    }
                }
            }
            logger.trace("Get:  event logger not initialized");
            getResult.setError();
        }
        return getResult;
    }

    public GetResult get(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        throw new InvalidObjectIdException("This component does not support this method.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized SetResult set(ObjectId objectId, Object object) throws InvalidValueException, InvalidObjectIdException, CommunicationException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        SetResult setResult = new SetResult();
        if (this.theState.getState() != 2) throw new InvalidObjectIdException("Unsupported operation.");
        if (objectId.equals((Object)EventLoggingGroup.RegisterEventToLog.getObjectId())) {
            VariableBinding variableBinding = (VariableBinding)object;
            this.theTriggers.addTrigger(variableBinding);
            String string = variableBinding.getObjectId().toString();
            String string2 = EventLists.getEventNameForObjectId(variableBinding.getObjectId());
            logger.debug("Recieved RegisterEventToLog for event: " + string + " name: " + string2);
            ConfigurationKeys configurationKeys = new ConfigurationKeys(string2);
            ServiceManager.getInstance().getConfigurationManager().setProperty(configurationKeys.getSection(), configurationKeys.getEnableLoggingKey(), Boolean.TRUE);
            setResult.setSuccessful(true);
            return setResult;
        } else if (objectId.equals((Object)EventLoggingGroup.UnRegisterEventToLog.getObjectId())) {
            VariableBinding variableBinding = (VariableBinding)object;
            this.theTriggers.removeTrigger(variableBinding);
            String string = variableBinding.getObjectId().toString();
            String string3 = EventLists.getEventNameForObjectId(variableBinding.getObjectId());
            logger.debug("Recieved UnregisterEventToLog for event: " + string + " name: " + string3);
            ConfigurationKeys configurationKeys = new ConfigurationKeys(string3);
            ServiceManager.getInstance().getConfigurationManager().setProperty(configurationKeys.getSection(), configurationKeys.getEnableLoggingKey(), Boolean.FALSE);
            setResult.setSuccessful(true);
            return setResult;
        } else {
            if (objectId.equals((Object)EventLoggingGroup.EraseLogFile.getObjectId())) {
                logger.debug("Received EraseLogFile request");
                return this.theIndependentLogger.set(objectId, object);
            }
            if (objectId.equals((Object)EventLoggingGroup.LogFileLocation.getObjectId())) {
                setResult = this.theIndependentLogger.set(objectId, object);
                this.theLogLocation = (String)object;
                logger.debug("Setting LogFileLocation to: " + this.theLogLocation);
                ServiceManager.getInstance().getConfigurationManager().setProperty("EventLog", "logfile", this.theLogLocation);
                return setResult;
            } else if (objectId.equals((Object)EventLoggingGroup.LogFileMaximumSize.getObjectId())) {
                Integer n = (Integer)object;
                n = Math.max(500, n);
                this.theLogSize = n = Integer.valueOf(Math.min(n, 10000));
                setResult = this.theIndependentLogger.set(objectId, this.theLogSize);
                logger.debug("Setting log size to: " + this.theLogSize);
                ServiceManager.getInstance().getConfigurationManager().setProperty("EventLog", "logsize", this.theLogSize);
                return setResult;
            } else {
                if (!objectId.equals((Object)EventLoggingGroup.LogApplicationError.getObjectId())) throw new InvalidObjectIdException("Unsupported operation.");
                logger.debug("Recieved notification of bad INI value: " + String.valueOf(object));
                return this.theIndependentLogger.set(EventLoggingGroup.LogEvent.getObjectId(), object);
            }
        }
    }

    public Enumeration<ObjectId> getSupportedOids() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.addElement(EventLoggingGroup.getGroup());
        return vector.elements();
    }

    private int getLogSize() {
        int n;
        IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(1000);
        intRangeSetValidator.add(500, 10000);
        try {
            n = this.config.getInt("EventLog", "logsize", intRangeSetValidator);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error((Object)illegalArgumentException);
            n = 1000;
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error((Object)noSuchElementException);
            n = 1000;
        }
        catch (ConversionException conversionException) {
            logger.error((Object)conversionException);
            n = 1000;
        }
        return n;
    }

    private synchronized void loadConfiguration() {
        logger.debug("loadConfiguration");
        this.theLogSize = this.getLogSize();
        try {
            this.theLogLocation = this.config.getString("EventLog", "logfile");
        }
        catch (ConversionException conversionException) {
            logger.error((Object)conversionException);
        }
        if (this.theIndependentLogger != null) {
            try {
                this.theIndependentLogger.set(EventLoggingGroup.LogFileMaximumSize.getObjectId(), this.theLogSize);
                this.theIndependentLogger.set(EventLoggingGroup.LogFileLocation.getObjectId(), this.theLogLocation);
            }
            catch (InvalidValueException invalidValueException) {
                logger.error((Object)invalidValueException);
            }
            catch (InvalidObjectIdException invalidObjectIdException) {
                logger.error((Object)invalidObjectIdException);
            }
            catch (CommunicationException communicationException) {
                logger.error((Object)communicationException);
            }
        }
        Map<ObjectId, String> map = EventLists.getAllEventsMap();
        IEventProducer iEventProducer = this.theTriggers.getEventProducer();
        if (iEventProducer != null) {
            try {
                this.theTriggers.unRegisterEventProducer(iEventProducer);
            }
            catch (RegistrationException registrationException) {
                logger.error("ERROR unregistering event producer");
            }
        }
        for (Map.Entry<ObjectId, String> entry : map.entrySet()) {
            ObjectId objectId = entry.getKey();
            String string = entry.getValue();
            ConfigurationKeys configurationKeys = new ConfigurationKeys(string);
            boolean bl = this.config.getBoolean(configurationKeys.getSection(), configurationKeys.getEnableLoggingKey(), (boolean)Boolean.TRUE);
            if (bl) {
                VariableBinding variableBinding = new VariableBinding(objectId, (Object)0);
                this.theTriggers.addTrigger(variableBinding);
                continue;
            }
            this.theTriggers.removeTrigger(new VariableBinding(objectId, (Object)0));
        }
        if (iEventProducer != null) {
            try {
                this.theTriggers.registerEventProducer(iEventProducer);
            }
            catch (RegistrationException registrationException) {
                logger.error("ERROR registering event producer");
            }
        }
    }

    public Object getInstanceOf(ObjectId objectId) throws InvalidObjectIdException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        EventLogger eventLogger = null;
        if (objectId.equals((Object)M11Component.kOid)) {
            eventLogger = this;
        } else if (objectId.equals((Object)Component.kOid)) {
            eventLogger = this;
        } else {
            logger.warn("Invalid Instance " + objectId.toString());
            throw new InvalidObjectIdException();
        }
        return eventLogger;
    }
}

