/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.eventlogger;

import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.RegistrationException;
import com.apcc.m11.arch.VariableBinding;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.arch.event.IEventConsumer;
import com.apcc.m11.arch.event.IEventProducer;
import com.apcc.m11.components.eventlogger.ITriggerConsumer;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Trigger
implements IEventConsumer {
    private static final Logger logger = LogManager.getLogger(Trigger.class);
    private Vector<VariableBinding> theTriggers = null;
    private IEventProducer theEventProducer = null;
    private Set<ITriggerConsumer> triggerConsumers = new HashSet<ITriggerConsumer>();

    public Trigger() {
        this.theTriggers = new Vector();
    }

    public void addTriggerConsumer(@NonNull ITriggerConsumer iTriggerConsumer) {
        if (iTriggerConsumer == null) {
            throw new IllegalArgumentException("aTriggerConsumer is marked non-null but is null");
        }
        this.triggerConsumers.add(iTriggerConsumer);
    }

    public void removeTriggerConsumer(@NonNull ITriggerConsumer iTriggerConsumer) {
        if (iTriggerConsumer == null) {
            throw new IllegalArgumentException("aTriggerConsumer is marked non-null but is null");
        }
        this.triggerConsumers.remove(iTriggerConsumer);
    }

    public void registerEventProducer(IEventProducer iEventProducer) throws RegistrationException {
        this.theEventProducer = iEventProducer;
        this.theEventProducer.registerEventConsumer((IEventConsumer)this);
    }

    public IEventProducer getEventProducer() {
        return this.theEventProducer;
    }

    public void unRegisterEventProducer(IEventProducer iEventProducer) throws RegistrationException {
        if (this.theEventProducer == null) {
            throw new RegistrationException("Event Producer not found");
        }
        this.theEventProducer.unRegisterEventConsumer((IEventConsumer)this);
        this.theEventProducer = null;
    }

    public Enumeration<ObjectId> getConsumedEvents() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        Enumeration<VariableBinding> enumeration = this.theTriggers.elements();
        while (enumeration.hasMoreElements()) {
            VariableBinding variableBinding = enumeration.nextElement();
            vector.addElement(variableBinding.getObjectId());
        }
        return vector.elements();
    }

    public void update(Event event) {
        block5: {
            block4: {
                if (!this.isCancelEvent(event)) break block4;
                for (ITriggerConsumer iTriggerConsumer : this.triggerConsumers) {
                    iTriggerConsumer.triggerCanceled(event);
                }
                break block5;
            }
            if (!this.isTriggerEvent(event)) break block5;
            int n = 0;
            ObjectId objectId = null;
            try {
                objectId = event.getObjectId();
                n = this.get_trigger_delay_time(objectId);
                logger.trace("Received Trigger event " + objectId.toString());
                for (ITriggerConsumer iTriggerConsumer : this.triggerConsumers) {
                    iTriggerConsumer.triggerOccurred(event, n);
                }
            }
            catch (InvalidObjectIdException invalidObjectIdException) {
                logger.error("update: bad trigger (object_id,delay_time)", (Throwable)invalidObjectIdException);
            }
        }
    }

    public Vector<VariableBinding> getTriggers() {
        return this.theTriggers;
    }

    public void addTrigger(VariableBinding variableBinding) {
        this.delete_trigger(variableBinding);
        if (this.theEventProducer != null) {
            try {
                this.theEventProducer.unRegisterEventConsumer((IEventConsumer)this);
            }
            catch (RegistrationException registrationException) {
                logger.error("addTrigger unRegister failed.  This may not cause any issues. " + registrationException.getMessage(), (Throwable)registrationException);
            }
            this.theTriggers.addElement(variableBinding);
            try {
                this.theEventProducer.registerEventConsumer((IEventConsumer)this);
            }
            catch (RegistrationException registrationException) {
                logger.error("addTrigger register failed" + registrationException.getMessage(), (Throwable)registrationException);
            }
        } else {
            this.theTriggers.addElement(variableBinding);
        }
    }

    public void removeTrigger(VariableBinding variableBinding) {
        try {
            if (this.theEventProducer != null) {
                this.theEventProducer.unRegisterEventConsumer((IEventConsumer)this);
                this.delete_trigger(variableBinding);
                this.theEventProducer.registerEventConsumer((IEventConsumer)this);
            } else {
                this.delete_trigger(variableBinding);
            }
        }
        catch (RegistrationException registrationException) {
            logger.error("removeTrigger (aVarBind), model", (Throwable)registrationException);
        }
        catch (NullPointerException nullPointerException) {
            logger.error("Event Producer not found", (Throwable)nullPointerException);
        }
    }

    private int get_trigger_delay_time(ObjectId objectId) throws InvalidObjectIdException {
        int n = 0;
        Enumeration<VariableBinding> enumeration = this.theTriggers.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements() && !bl) {
            VariableBinding variableBinding = enumeration.nextElement();
            if (!variableBinding.getObjectId().equals((Object)objectId)) continue;
            n = (Integer)variableBinding.getValue();
            bl = true;
        }
        if (!bl) {
            throw new InvalidObjectIdException();
        }
        return n;
    }

    private boolean isCancelEvent(Event event) {
        boolean bl = false;
        if (!event.isActive()) {
            Enumeration<VariableBinding> enumeration = this.theTriggers.elements();
            ObjectId objectId = event.getObjectId();
            while (enumeration.hasMoreElements()) {
                VariableBinding variableBinding = enumeration.nextElement();
                if (!objectId.equals((Object)variableBinding.getObjectId())) continue;
                bl = true;
            }
        }
        return bl;
    }

    private boolean isTriggerEvent(Event event) {
        boolean bl = false;
        if (event.isActive()) {
            Enumeration<VariableBinding> enumeration = this.theTriggers.elements();
            ObjectId objectId = event.getObjectId();
            while (enumeration.hasMoreElements()) {
                VariableBinding variableBinding = enumeration.nextElement();
                if (!objectId.equals((Object)variableBinding.getObjectId())) continue;
                bl = true;
            }
        }
        return bl;
    }

    private void delete_trigger(VariableBinding variableBinding) {
        int n = this.theTriggers.size();
        boolean bl = false;
        for (int i = 0; i <= n - 1 && !bl; ++i) {
            VariableBinding variableBinding2 = this.theTriggers.elementAt(i);
            if (!variableBinding.getObjectId().equals((Object)variableBinding2.getObjectId())) continue;
            this.theTriggers.removeElementAt(i);
            i = -1;
            n = this.theTriggers.size();
        }
    }

    public void stop() {
        try {
            this.theEventProducer.unRegisterEventConsumer((IEventConsumer)this);
        }
        catch (Exception exception) {
            logger.error("stop could not unregister with event producer", (Throwable)exception);
        }
    }
}

