/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.eventlogger.logger;

import com.apcc.m11.ds.services.eventlogginggroup.ILogAccessor;
import java.util.List;
import java.util.NoSuchElementException;

public class FileLogAccessor
implements ILogAccessor {
    private boolean theOrderIsAscending = true;
    private List theLoggedData = null;
    private int theTotalElements = 0;
    private int theCurrentElemPtr = 0;

    public FileLogAccessor(List list) {
        this.theLoggedData = list;
        this.theTotalElements = this.getSize();
        this.theCurrentElemPtr = 0;
    }

    @Override
    public Object getNext() throws NoSuchElementException {
        Object object = this.theOrderIsAscending ? this.getNextElement() : this.getPreviousElement();
        return object;
    }

    @Override
    public void reverseOrder() {
        if (this.theOrderIsAscending) {
            this.theOrderIsAscending = false;
            if (this.theCurrentElemPtr > 0) {
                --this.theCurrentElemPtr;
            }
        } else {
            this.theOrderIsAscending = true;
            if (this.theCurrentElemPtr < this.theTotalElements) {
                ++this.theCurrentElemPtr;
            }
        }
    }

    @Override
    public int getSize() {
        return this.theLoggedData.size();
    }

    public List getAll() {
        return this.theLoggedData;
    }

    @Override
    public void goBottom() {
        this.theCurrentElemPtr = this.getSize();
    }

    @Override
    public void goTop() {
        this.theCurrentElemPtr = 0;
    }

    @Override
    public boolean hasMoreElements() {
        boolean bl = false;
        if (this.theOrderIsAscending) {
            if (this.theCurrentElemPtr < this.theTotalElements) {
                bl = true;
            }
        } else if (this.theCurrentElemPtr > 0) {
            bl = true;
        }
        return bl;
    }

    private Object getNextElement() throws NoSuchElementException {
        Object var1_1 = null;
        if (this.theCurrentElemPtr < this.theTotalElements) {
            var1_1 = this.theLoggedData.get(this.theCurrentElemPtr);
            ++this.theCurrentElemPtr;
        } else {
            throw new NoSuchElementException("End of elements");
        }
        return var1_1;
    }

    private Object getPreviousElement() throws NoSuchElementException {
        Object var1_1 = null;
        if (this.theCurrentElemPtr > 0) {
            --this.theCurrentElemPtr;
        } else {
            throw new NoSuchElementException("No previous element");
        }
        var1_1 = this.theLoggedData.get(this.theCurrentElemPtr);
        return var1_1;
    }
}

