/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.eventlogger.logger;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.components.eventlogger.ITriggerConsumer;
import com.apcc.m11.components.eventlogger.logger.TextFileLogger;
import com.apcc.m11.components.eventlogger.logger.commands.ICommand;
import com.apcc.m11.components.eventlogger.logger.commands.ilogger.GetCommand;
import com.apcc.m11.components.eventlogger.logger.commands.ilogger.SetCommand;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.events.flexevents.powersource.Communication;
import com.apcc.m11.ds.services.eventlogginggroup.EventLoggingGroup;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.snmp.PcnsTrapGenerator;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IndependentLogger
extends Thread
implements ITriggerConsumer {
    private static final Logger logger = LogManager.getLogger(IndependentLogger.class);
    private boolean theContinueLogger = true;
    private TextFileLogger theLogger;
    private BlockingQueue<ICommand> theQueue;
    private IPermanentStorage thePermanentStorage;
    private ServiceManager services;

    public IndependentLogger(IPermanentStorage iPermanentStorage, @NonNull ServiceManager serviceManager) throws IOException {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.theLogger = new TextFileLogger(this.services.getDateTimeFormatUtils());
        this.theQueue = new LinkedBlockingQueue<ICommand>();
        this.thePermanentStorage = iPermanentStorage;
    }

    public IndependentLogger(IPermanentStorage iPermanentStorage, String string, @NonNull ServiceManager serviceManager) throws IOException {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.theLogger = new TextFileLogger(string, this.services.getDateTimeFormatUtils());
        this.theQueue = new LinkedBlockingQueue<ICommand>();
        this.thePermanentStorage = iPermanentStorage;
    }

    @Override
    public void run() {
        while (this.theContinueLogger) {
            try {
                ICommand iCommand = this.theQueue.take();
                this.execute_command(iCommand);
            }
            catch (InterruptedException interruptedException) {
                this.theContinueLogger = false;
            }
        }
    }

    public void stop_logging() {
        this.theContinueLogger = false;
        this.interrupt();
    }

    @Override
    public synchronized void triggerOccurred(Event event, int n) {
        logger.debug("triggerOccurred");
        try {
            this.set(EventLoggingGroup.LogEvent.getObjectId(), event);
        }
        catch (CommunicationException communicationException) {
            logger.error("CommunicationException triggerOccurred:  bad event (ObjectId)", (Throwable)communicationException);
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.error("InvalidObjectIdException triggerOccurred:  bad event (ObjectId)", (Throwable)invalidObjectIdException);
        }
        catch (InvalidValueException invalidValueException) {
            logger.error("InvalidValueException triggerOccurred:  bad event (ObjectId)", (Throwable)invalidValueException);
        }
    }

    @Override
    public void triggerCanceled(Event event) {
        logger.debug("TriggerCanceled");
        if (event.getObjectId().equals((Object)Communication.NetCommunicationLost.getObjectId()) || event.getObjectId().equals((Object)Communication.CommunicationLostOnBattery.getObjectId())) {
            logger.debug("NetComsLost SNMP");
            ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(Locale.getDefault());
            String string = Utils.getResourceString(resourceBundleWrapper, "SNMPTRAP.NetCommsLostClear");
            PcnsTrapGenerator.getInstance(this.thePermanentStorage, this.services).clearTrap(PcnsTrapGenerator.pcnsNetworkComsLost, string);
        } else if (event.getObjectId().equals((Object)Communication.CommunicationLost.getObjectId())) {
            logger.debug("ComsLost SNMP");
            ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(Locale.getDefault());
            String string = Utils.getResourceString(resourceBundleWrapper, "SNMPTRAP.UPSCommsLostClear");
            PcnsTrapGenerator.getInstance(this.thePermanentStorage, this.services).clearTrap(PcnsTrapGenerator.pcnsNMCComsLost, string);
        }
    }

    public GetResult get(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult = new GetResult();
        GetCommand getCommand = new GetCommand(objectId, getResult);
        try {
            this.theQueue.put(getCommand);
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)interruptedException);
        }
        return getResult;
    }

    public GetResult get(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult = new GetResult();
        switch (n) {
            case 0: {
                getResult = this.get(objectId);
                break;
            }
            case 1: {
                getResult.setValue((Object)Availability.AVAILABLE);
                break;
            }
            case 2: {
                getResult.setError();
                break;
            }
            case 3: {
                getResult.setError();
                break;
            }
            default: {
                logger.trace("Get:  bad ID or type");
                throw new InvalidObjectIdException();
            }
        }
        return getResult;
    }

    public SetResult set(ObjectId objectId, Object object) throws InvalidValueException, InvalidObjectIdException, CommunicationException {
        SetResult setResult = new SetResult();
        SetCommand setCommand = new SetCommand(objectId, object, setResult);
        try {
            this.theQueue.put(setCommand);
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)interruptedException);
        }
        return setResult;
    }

    private void execute_command(ICommand iCommand) {
        if (iCommand instanceof GetCommand) {
            GetCommand getCommand = (GetCommand)iCommand;
            this.perform_get_command(getCommand.getObjectId(), getCommand.getResult());
        } else if (iCommand instanceof SetCommand) {
            SetCommand setCommand = (SetCommand)iCommand;
            this.perform_set_command(setCommand.getObjectId(), setCommand.getValue(), setCommand.getResult());
        } else {
            iCommand.setErrorResult(true);
        }
    }

    private void perform_get_command(ObjectId objectId, GetResult getResult) {
        try {
            if (objectId.equals((Object)EventLoggingGroup.LogFileMaximumSize.getObjectId())) {
                getResult.setValue((Object)this.theLogger.getLogMaximumSize());
            } else if (objectId.equals((Object)EventLoggingGroup.LogFileLocation.getObjectId())) {
                getResult.setValue((Object)this.theLogger.getLocation());
            } else if (objectId.equals((Object)EventLoggingGroup.LoggedEvents.getObjectId())) {
                getResult.setValue((Object)this.theLogger.getLoggedData());
            } else {
                getResult.setError();
            }
        }
        catch (Exception exception) {
            logger.trace("perform_get_command:  bad get (ObjectId)", (Throwable)exception);
            getResult.setError();
        }
    }

    private void perform_set_command(ObjectId objectId, Object object, SetResult setResult) {
        try {
            if (objectId.equals((Object)EventLoggingGroup.LogEvent.getObjectId())) {
                this.theLogger.log(object);
                if (object instanceof Event) {
                    Event event = (Event)object;
                    if (event.getObjectId().equals((Object)Communication.NetCommunicationLost.getObjectId()) || event.getObjectId().equals((Object)Communication.CommunicationLostOnBattery.getObjectId())) {
                        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(Locale.getDefault());
                        String string = Utils.getResourceString(resourceBundleWrapper, "SNMPTRAP.NetCommsLost");
                        PcnsTrapGenerator.getInstance(this.thePermanentStorage, this.services).startTrap(PcnsTrapGenerator.pcnsNetworkComsLost, string);
                    } else if (event.getObjectId().equals((Object)Communication.CommunicationLost.getObjectId())) {
                        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(Locale.getDefault());
                        String string = Utils.getResourceString(resourceBundleWrapper, "SNMPTRAP.UPSCommsLost");
                        PcnsTrapGenerator.getInstance(this.thePermanentStorage, this.services).startTrap(PcnsTrapGenerator.pcnsNMCComsLost, string);
                    }
                }
                setResult.setSuccessful(true);
            } else if (objectId.equals((Object)EventLoggingGroup.LogFileMaximumSize.getObjectId())) {
                this.theLogger.setLogMaximumSize((Integer)object);
                setResult.setSuccessful(true);
            } else if (objectId.equals((Object)EventLoggingGroup.LogFileLocation.getObjectId())) {
                this.theLogger.setLogLocation((String)object);
                setResult.setSuccessful(true);
            } else if (objectId.equals((Object)EventLoggingGroup.EraseLogFile.getObjectId())) {
                this.theLogger.eraseLog();
                setResult.setSuccessful(true);
            } else {
                setResult.setSuccessful(false);
            }
        }
        catch (Exception exception) {
            logger.debug("perform_set_command:  bad set (ObjectId,aValue)", (Throwable)exception);
            setResult.setSuccessful(false);
        }
    }
}

