/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.eventlogger.logger;

import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.eventlogger.logger.FileLogAccessor;
import com.apcc.m11.ds.services.eventlogginggroup.ILogAccessor;
import com.apcc.pcns.errorservice.ApplicationErrorEvent;
import com.apcc.pcns.util.DateTimeFormatUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextFileLogger {
    private static final Logger logger = LogManager.getLogger(TextFileLogger.class);
    private static final int kDefaultLogFileMaximum = 1000;
    private static final String kDefaultLogFile = "EventLog.txt";
    private String theLogFileName = "EventLog.txt";
    private int theMaximumFileSize = 1000;
    private List<String> theLoggedData;
    private DateTimeFormatUtils dateUtils;

    public TextFileLogger(@NonNull DateTimeFormatUtils dateTimeFormatUtils) throws IOException {
        if (dateTimeFormatUtils == null) {
            throw new IllegalArgumentException("dateUtils is marked non-null but is null");
        }
        this.dateUtils = dateTimeFormatUtils;
        this.theLoggedData = this.readAllData();
    }

    public TextFileLogger(String string, @NonNull DateTimeFormatUtils dateTimeFormatUtils) throws IOException {
        if (dateTimeFormatUtils == null) {
            throw new IllegalArgumentException("dateUtils is marked non-null but is null");
        }
        this.dateUtils = dateTimeFormatUtils;
        if (string == null) {
            throw new IOException();
        }
        this.theLogFileName = string;
        this.theLoggedData = this.readAllData();
    }

    public void log(Object object) {
        this.pruneLogFile();
        this.saveData(object);
    }

    public void setLogMaximumSize(int n) {
        this.theMaximumFileSize = n;
        this.pruneLogFile();
    }

    public void setLogLocation(String string) {
        this.theLogFileName = string;
    }

    public ILogAccessor getLoggedData() {
        return new FileLogAccessor(this.getAllData());
    }

    public String getLocation() {
        return this.theLogFileName;
    }

    public int getLogMaximumSize() {
        return this.theMaximumFileSize;
    }

    public void eraseLog() {
        this.deleteAllLoggedData();
        this.theLoggedData.clear();
    }

    private void saveData(Object object) {
        try {
            String string = this.getEventText(object);
            logger.debug("save_data({})", (Object)string);
            if (string != null) {
                this.appendLine(string);
                this.theLoggedData.add(string);
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
    }

    private String getEventText(Object object) {
        String string = null;
        if (object == null) {
            return string;
        }
        if (object instanceof String) {
            string = (String)object;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            try {
                Event event = (Event)object;
                if (event.getClass().equals(ApplicationErrorEvent.class)) {
                    event.setTimestamp(new Date(System.currentTimeMillis()));
                }
                Date date = event.getTimestamp();
                IFormatter iFormatter = event.getFormatter();
                if (iFormatter != null) {
                    stringBuilder.append(this.dateUtils.formatTableDate(date));
                    stringBuilder.append("\t");
                    stringBuilder.append(this.dateUtils.formatTableTime(date));
                    stringBuilder.append("\t");
                    stringBuilder.append(iFormatter.format((Object)event, Locale.getDefault()));
                    stringBuilder.append("\t");
                    stringBuilder.append(event.getObjectId());
                    string = stringBuilder.toString();
                }
            }
            catch (Exception exception) {
                logger.error("Unable to format log event due to:" + exception.toString(), (Throwable)exception);
            }
        }
        return string;
    }

    private void pruneLogFile() {
        if (this.theLoggedData.size() >= this.theMaximumFileSize) {
            logger.debug("prune now");
            List<String> list = this.getAllData();
            int n = list.size();
            this.eraseLog();
            try {
                for (int i = n - this.theMaximumFileSize + this.theMaximumFileSize / 3; i < n; ++i) {
                    this.saveData(list.get(i));
                }
            }
            catch (Exception exception) {
                logger.error((Object)exception);
            }
        }
    }

    private List<String> getAllData() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.theLoggedData);
        return arrayList;
    }

    private List<String> readAllData() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        try {
            Path path = Paths.get(this.theLogFileName, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                bufferedReader = Files.newBufferedReader(path, StandardCharsets.UTF_8);
                String string = bufferedReader.readLine();
                while (string != null) {
                    arrayList.add(string);
                    string = bufferedReader.readLine();
                }
            } else {
                logger.debug("no existing log file:" + this.theLogFileName);
            }
        }
        catch (IOException iOException) {
            logger.error((Object)iOException);
            throw new IOException("TextFileLogger read_all_data() failed");
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    logger.error((Object)iOException);
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void appendLine(String string) {
        if (string != null && !string.trim().isEmpty()) {
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = Files.newBufferedWriter(Paths.get(this.theLogFileName, new String[0]), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
            catch (IOException iOException) {
                logger.error((Object)iOException);
            }
            finally {
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {
                        logger.error((Object)iOException);
                    }
                }
            }
        }
    }

    private synchronized void deleteAllLoggedData() {
        try {
            Files.delete(Paths.get(this.theLogFileName, new String[0]));
        }
        catch (IOException iOException) {
            logger.error((Object)iOException);
        }
    }
}

