/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.omaha;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BitmaskUtils {
    private static final Logger logger = LogManager.getLogger(BitmaskUtils.class);
    private static final int MIN_EVENT_SELECTOR_BIT = 0;
    private static final int MAX_EVENT_SELECTOR_BIT = 63;
    private static final int MAX_BITMASK_LENGTH = 16;
    private static final Pattern HEX_REGEX = Pattern.compile("[0-9a-fA-F]+");
    private String bitmask;

    public BitmaskUtils(String string) {
        String string2 = BitmaskUtils.validateBitmask(string);
        if (string2 == null) {
            throw new IllegalArgumentException("Invalid bitmask.");
        }
        this.bitmask = string2;
    }

    public static String validateBitmask(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        if (HEX_REGEX.matcher(string).matches()) {
            String string2;
            int n = string.length();
            if (n <= 16) {
                string2 = string;
            } else {
                int n2 = n - 16;
                string2 = string.substring(n2);
            }
            return string2;
        }
        logger.warn("Junk data detected in UPS 'EM' field, value rejected.");
        return null;
    }

    public boolean isBitSet(int n) {
        if (n > 63 || n < 0) {
            return false;
        }
        try {
            long l = Long.parseLong(this.bitmask, 16);
            long l2 = 1L << n;
            return (l & l2) > 0L;
        }
        catch (NumberFormatException numberFormatException) {
            logger.debug("Failed to parse event selector bitmask.");
            return false;
        }
    }

    public static boolean hasCompatibleBitmasks(List<String> list) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("Can't process an empty list.");
        }
        boolean bl = true;
        long l = 0x7FFFFFL;
        long l2 = -1L;
        for (String string : list) {
            if (string == null) continue;
            try {
                long l3 = Long.parseLong(string, 16);
                if (l2 == -1L) {
                    l2 = l3 & l;
                    continue;
                }
                bl &= (l3 & l) == l2;
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    public static String combineEventMasks(List<String> list) {
        long l = 0xFFFF800000L;
        long l2 = 0L;
        long l3 = 0L;
        if (list == null || list.isEmpty()) {
            return null;
        }
        l3 = l2 = Long.parseLong(list.get(0), 16);
        for (int i = 1; i < list.size(); ++i) {
            try {
                long l4 = Long.parseLong(list.get(i), 16);
                l2 &= l4;
                l3 |= l4;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                logger.warn("EventMask from UPS has wrong format:" + list.get(i));
            }
        }
        return Long.toHexString(l2 |= l3 & l);
    }
}

