/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.omaha;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.ObjectIdTree;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataConsumer;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.arch.m11component.M11ComponentSynchronizer;
import com.apcc.m11.components.omaha.FlexEventActionList;
import com.apcc.m11.components.omaha.FlexEventGroupList;
import com.apcc.m11.components.omaha.FlexEventList;
import com.apcc.m11.components.omaha.IDataObject;
import com.apcc.m11.components.omaha.IDataSourceContainer;
import com.apcc.m11.components.omaha.OmahaComponent;
import com.apcc.m11.components.omaha.ProductVersionDataObject;
import com.apcc.m11.components.omaha.ResetApplicationToDefaults;
import com.apcc.m11.components.omaha.ResetEnvironmentToDefaults;
import com.apcc.m11.ds.services.omaha.Omaha;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataSourceAdapter
implements IDataSource,
IDataConsumer,
IDataSourceContainer {
    private static final Logger logger = LogManager.getLogger(DataSourceAdapter.class);
    private M11ComponentSynchronizer theSynchronizer;
    private IDataSource theDataSource;
    private ObjectIdTree theSupportedObjects;
    private OmahaComponent theOmahaComponent;

    DataSourceAdapter(M11ComponentSynchronizer m11ComponentSynchronizer, OmahaComponent omahaComponent) {
        this.theSynchronizer = m11ComponentSynchronizer;
        this.theDataSource = null;
        this.theSupportedObjects = new ObjectIdTree();
        this.theOmahaComponent = omahaComponent;
    }

    public synchronized GetResult get(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult = new GetResult();
        if (this.theSynchronizer.getState() == 2) {
            IDataObject iDataObject = (IDataObject)this.theSupportedObjects.findNode(objectId);
            if (iDataObject == null) {
                throw new InvalidObjectIdException();
            }
            try {
                Object object = iDataObject.getValue();
                getResult.setValue(object);
            }
            catch (CommunicationException communicationException) {
                getResult.setError();
            }
        } else {
            throw new CommunicationException();
        }
        return getResult;
    }

    public synchronized GetResult get(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult = new GetResult();
        if (this.theSynchronizer.getState() == 2) {
            IDataObject iDataObject = (IDataObject)this.theSupportedObjects.findNode(objectId);
            if (iDataObject == null) {
                throw new InvalidObjectIdException();
            }
            try {
                Object object = null;
                switch (n) {
                    case 0: {
                        object = iDataObject.getValue();
                        break;
                    }
                    case 2: {
                        object = iDataObject.getAllowedValues();
                        break;
                    }
                    case 1: {
                        object = iDataObject.getAvailability();
                        break;
                    }
                    case 3: {
                        object = iDataObject.getFormatter();
                        break;
                    }
                    default: {
                        getResult.setError();
                    }
                }
                getResult.setValue(object);
            }
            catch (CommunicationException communicationException) {
                getResult.setError();
            }
        } else {
            throw new CommunicationException();
        }
        return getResult;
    }

    public synchronized GetResult get(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        throw new InvalidObjectIdException("This component does not support this method.");
    }

    public synchronized SetResult set(ObjectId objectId, Object object) throws InvalidValueException, InvalidObjectIdException, CommunicationException {
        SetResult setResult = new SetResult();
        if (this.theSynchronizer.getState() == 2) {
            IDataObject iDataObject = (IDataObject)this.theSupportedObjects.findNode(objectId);
            if (iDataObject == null) {
                throw new InvalidObjectIdException();
            }
            try {
                iDataObject.setValue(object, setResult);
            }
            catch (CommunicationException communicationException) {
                setResult.setSuccessful(false);
            }
        } else {
            throw new CommunicationException();
        }
        return setResult;
    }

    public synchronized Enumeration<ObjectId> getSupportedOids() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.addElement(Omaha.getGroup());
        return vector.elements();
    }

    public synchronized void setDataSource(IDataSource iDataSource) {
        this.theDataSource = iDataSource;
    }

    @Override
    public synchronized IDataSource getDataSource() {
        return this.theDataSource;
    }

    public void buildObjectTree(int n) {
        this.theSupportedObjects.addNode(Omaha.ProductVersion.getObjectId(), (Object)new ProductVersionDataObject(this));
        this.theSupportedObjects.addNode(Omaha.FlexEventList.getObjectId(), (Object)new FlexEventList(this.theOmahaComponent));
        this.theSupportedObjects.addNode(Omaha.FlexEventGroupList.getObjectId(), (Object)new FlexEventGroupList());
        this.theSupportedObjects.addNode(Omaha.FlexEventActionList.getObjectId(), (Object)new FlexEventActionList());
        this.theSupportedObjects.addNode(Omaha.ResetApplicationToDefaults.getObjectId(), (Object)new ResetApplicationToDefaults(this, n));
        this.theSupportedObjects.addNode(Omaha.ResetEnvironmentToDefaults.getObjectId(), (Object)new ResetEnvironmentToDefaults(this));
    }
}

