/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.omaha;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.IAllowedValues;
import com.apcc.m11.arch.datasource.IAvailability;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.omaha.BitmaskUtils;
import com.apcc.m11.components.omaha.EventRow;
import com.apcc.m11.components.omaha.IDataObject;
import com.apcc.m11.components.omaha.OmahaComponent;
import com.apcc.m11.components.omaha.flexeventdescriptors.BatteryChargeInRangeDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.BatteryDischargedDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.BypassContactorFailedDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.BypassContactorOkDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.BypassDisabledDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.BypassEnabledDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.BypassManualEnabledDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.CommunicationEstablishedDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.CommunicationLostDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.CommunicationLostOnBatteryDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.ContactFault1Descriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.ContactFault2Descriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.ContactFault3Descriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.ContactFault4Descriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.ContactNormal1Descriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.ContactNormal2Descriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.ContactNormal3Descriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.ContactNormal4Descriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.EnvironmentCommunicationEstablishedDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.EnvironmentCommunicationLostDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.FaultBypassEnabledDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.HumidityInRangeProbe1Descriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.HumidityInRangeProbe2Descriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.HumidityOutOfRangeProbe1Descriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.HumidityOutOfRangeProbe2Descriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.InternalTempInRangeDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.MaxInternalTempExceededDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.MinLoadCapabilityLostDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.MinLoadCapabilityRegainedDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.MinRedundancyLostDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.MinRedundancyRegainedDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.NetCommunicationLostDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.OverloadDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.OverloadSolvedDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.ParallelRedundancyLostDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.ParallelRedundancyRegainedDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.PowerFailedDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.PowerRestoredDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.RunTimeExceededDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.RunTimeRemainingClearedDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.RunTimeRemainingDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.RunTimeWithinRangeDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.SinglePowerFailedDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.SinglePowerRestoredDescriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.TempInRangeProbe1Descriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.TempInRangeProbe2Descriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.TempOutOfRangeProbe1Descriptor;
import com.apcc.m11.components.omaha.flexeventdescriptors.TempOutOfRangeProbe2Descriptor;
import com.apcc.m11.ds.services.omaha.IFlexEventDescriptor;
import java.util.HashSet;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlexEventList
implements IDataObject {
    private static final int POWER_FAILED_BIT = 0;
    private static final int RUNTIME_EXCEEDED_BIT = 1;
    private static final int RUNTIME_REMAINING_THRESHOLD_BIT = 2;
    private static final int BATTERY_DISCHARGED_BIT = 3;
    private static final int FAULT_BYPASS_BIT = 4;
    private static final int BYPASS_ENABLED_BIT = 5;
    private static final int MANUAL_BYPASS_BIT = 6;
    private static final int BYPASS_CONTACTOR_BIT = 7;
    private static final int COMMUNICATIONS_LOST_ON_BATTERY_BIT = 8;
    private static final int COMMUNICATIONS_LOST_BIT = 9;
    private static final int NET_COMMUNICATIONS_LOST_BIT = 10;
    private static final int COMMUNICATIONS_ESTABLISHED_BIT = 11;
    private static final int MINIMUM_REDUNDANCY_LOST_BIT = 12;
    private static final int MINIMUM_LOAD_CAPABILITY_BIT = 13;
    private static final int MAXIMUM_INTERNAL_TEMPERATURE_BIT = 14;
    private static final int OVERLOAD_BIT = 15;
    private static final int PARALLEL_REDUNDANCY_BIT = 16;
    private static final int ENVIRONMENTAL_COMMUNICATIONS_LOST_BIT = 23;
    private static final int PROBE_ONE_TEMPERATURE_BIT = 24;
    private static final int PROBE_TWO_TEMPERATURE_BIT = 25;
    private static final int PROBE_ONE_HUMIDITY_BIT = 28;
    private static final int PROBE_TWO_HUMIDITY_BIT = 29;
    private static final int CONTACT_ONE_BIT = 32;
    private static final int CONTACT_TWO_BIT = 33;
    private static final int CONTACT_THREE_BIT = 34;
    private static final int CONTACT_FOUR_BIT = 35;
    private static final Logger logger = LogManager.getLogger(FlexEventList.class);
    private Vector<IFlexEventDescriptor> theFlexEvents;
    private static final String kSmartUPSModelType = "SMART-UPS";
    private static final String kSmartUPSRTType = " RT";
    private static final String kSmartUPSRCType = " RC";
    private static final String kSmartUPSVTType = " VT";
    private static final String kSmartUPSSRTType = " SRT";
    private static final String kSmartUPSSRCType = " SRC";
    private static final String kMstarType = ".*MGE GALAXY 3[0]\\d.*";
    private static final String kMatrixUPSType = "Matrix";
    private static final String kSymmetraUPSType = "SYMMETRA";
    private static final String kSmartUPSDP300ModelType = "DP3";
    private static final String kSmartUPSDP100ModelType = "DP ";
    private static final String kSmartUPSDPClusterModelType = "Parallel";
    private static final String kRedundantModelType = "Redundant";
    private static final String kGalaxyModelType = "GALAXY";
    private static final String kGalaxy7000ModelType = ".*GALAXY 7\\d\\d\\d.*";
    private static final String kValhalModelType = ".*GALAXY VM.*";
    private static final String kIBMUnionModelType = ".*IBM.UPS.*";
    private static final String kMStarGalaxyUPS5000ModelType = ".*MGE GALAXY 5[0]\\d\\d.*";
    private static final String kMStarGalaxyUPS5500ModelType = ".*MGE GALAXY 5[5]\\d\\d.*";
    private static final String kMStarGalaxyUPS6000ModelType = ".*MGE GALAXY 6\\d\\d\\d.*";
    private static final String kMStarGalaxyUPS9000ModelType = ".*MGE GALAXY 9\\d\\d\\d.*";
    private static final String KMStarEPS6000ModelType = ".*MGE EPS 6\\d\\d\\d.*";
    private static final String KMStarEPS7000ModelType = ".*MGE EPS 7\\d\\d\\d.*";
    private static final String KMStarEPS8000EModelType = ".*MGE EPS 8\\d\\d\\d[E].*";
    private static final String KMStarEPS8000ModelType = ".*MGE EPS 8\\d\\d\\d.*";
    private static final String kSRCModelType = ".*SRC\\W\\d\\d\\d\\d.*";
    private static final char CTRL_A = '\u0001';
    private OmahaComponent theOmahaComponent = null;
    private Vector<EventRow> theEventLists = null;

    private void add(IFlexEventDescriptor iFlexEventDescriptor, boolean[] blArray) {
        Vector<Boolean> vector = new Vector<Boolean>();
        for (boolean bl : blArray) {
            vector.add(bl);
        }
        this.theEventLists.add(new EventRow(iFlexEventDescriptor, vector));
    }

    private Vector<IFlexEventDescriptor> getEventList(int n) {
        Vector<IFlexEventDescriptor> vector = new Vector<IFlexEventDescriptor>();
        for (EventRow eventRow : this.theEventLists) {
            try {
                IFlexEventDescriptor iFlexEventDescriptor = eventRow.getDescriptor();
                Boolean bl = eventRow.getFlags().elementAt(n - 1);
                if (!bl.booleanValue()) continue;
                vector.add(iFlexEventDescriptor);
            }
            catch (ArrayIndexOutOfBoundsException | NullPointerException runtimeException) {
                logger.error("Lookup table corrupted", (Throwable)runtimeException);
            }
        }
        return vector;
    }

    private void initialise_events() {
        this.theEventLists = new Vector();
        IFlexEventDescriptor iFlexEventDescriptor = new PowerFailedDescriptor();
        boolean[] blArray = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new PowerRestoredDescriptor();
        blArray = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new RunTimeExceededDescriptor();
        blArray = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new RunTimeWithinRangeDescriptor();
        blArray = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new RunTimeRemainingDescriptor();
        blArray = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new RunTimeRemainingClearedDescriptor();
        blArray = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new BatteryDischargedDescriptor();
        blArray = new boolean[]{true, true, true, false, true, true, true, true, true, true, true, true, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new BatteryChargeInRangeDescriptor();
        blArray = new boolean[]{true, true, true, false, true, true, true, true, true, true, true, true, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new FaultBypassEnabledDescriptor();
        blArray = new boolean[]{true, true, false, true, true, true, true, true, true, true, true, true, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new BypassEnabledDescriptor();
        blArray = new boolean[]{true, true, false, true, true, true, true, true, true, true, true, true, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new BypassManualEnabledDescriptor();
        blArray = new boolean[]{true, true, false, true, true, true, true, true, true, true, true, true, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new BypassDisabledDescriptor();
        blArray = new boolean[]{true, true, false, true, true, true, true, true, true, true, true, true, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new BypassContactorFailedDescriptor();
        blArray = new boolean[]{true, true, false, false, false, false, false, false, false, true, true, false, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new BypassContactorOkDescriptor();
        blArray = new boolean[]{true, true, false, false, false, false, false, false, false, true, true, false, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new CommunicationLostOnBatteryDescriptor();
        blArray = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new CommunicationLostDescriptor();
        blArray = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new NetCommunicationLostDescriptor();
        blArray = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new CommunicationEstablishedDescriptor();
        blArray = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new MinRedundancyLostDescriptor();
        blArray = new boolean[]{true, false, false, false, false, false, false, true, false, false, false, false, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new MinRedundancyRegainedDescriptor();
        blArray = new boolean[]{true, false, false, false, false, false, false, true, false, false, false, false, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new MinLoadCapabilityLostDescriptor();
        blArray = new boolean[]{true, false, false, false, false, false, false, true, false, true, true, false, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new MinLoadCapabilityRegainedDescriptor();
        blArray = new boolean[]{true, false, false, false, false, false, false, true, false, true, true, false, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new MaxInternalTempExceededDescriptor();
        blArray = new boolean[]{true, true, true, false, false, false, true, false, false, true, false, false, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new InternalTempInRangeDescriptor();
        blArray = new boolean[]{true, true, true, false, false, false, true, false, false, true, false, false, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new OverloadDescriptor();
        blArray = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new OverloadSolvedDescriptor();
        blArray = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new ParallelRedundancyLostDescriptor();
        blArray = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, true, false};
        this.add(iFlexEventDescriptor, blArray);
        iFlexEventDescriptor = new ParallelRedundancyRegainedDescriptor();
        blArray = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, true, false};
        this.add(iFlexEventDescriptor, blArray);
    }

    private boolean isSmartUPSOnLine(String string, String string2) {
        boolean bl = false;
        if (string != null && (this.isInRange(string, 400, 499) || this.isInRange(string, 800, 809) || this.isInRange(string, 1100, 1109))) {
            bl = true;
        }
        if (string2 != null && string2.toUpperCase().indexOf(kSmartUPSModelType) >= 0 && (string2.toUpperCase().indexOf(kSmartUPSRTType) >= 0 || string2.toUpperCase().indexOf(kSmartUPSRCType) >= 0 || string2.toUpperCase().indexOf(kSmartUPSSRTType) >= 0 || string2.toUpperCase().indexOf(kSmartUPSSRCType) >= 0)) {
            bl = true;
        }
        logger.info("Omaha - UPS F/W " + string + ", return " + bl);
        return bl;
    }

    private boolean isGalaxy(String string, String string2) {
        boolean bl = false;
        if (string2 != null && string2.toUpperCase().indexOf(kGalaxyModelType) >= 0) {
            bl = true;
        }
        logger.info("Omaha - UPS F/W " + string + ", return " + bl);
        return bl;
    }

    private boolean isValhalUPS(String string, String string2) {
        boolean bl = false;
        if (string2 != null && Pattern.matches(kValhalModelType, string2.toUpperCase())) {
            bl = true;
        }
        logger.info("Omaha - UPS F/W " + string + ", return " + bl);
        return bl;
    }

    private boolean isGalaxy7xxx(String string, String string2) {
        boolean bl = false;
        if (string2 != null && Pattern.matches(kGalaxy7000ModelType, string2.toUpperCase())) {
            bl = true;
        }
        logger.info("Omaha - UPS F/W " + string + ", return " + bl);
        return bl;
    }

    private boolean isGalaxy5xxx(String string, String string2) {
        boolean bl = false;
        if (string2 != null) {
            if (Pattern.matches(kMStarGalaxyUPS5000ModelType, string2.toUpperCase())) {
                bl = true;
            } else if (Pattern.matches(kMStarGalaxyUPS5500ModelType, string2.toUpperCase())) {
                bl = true;
            }
        }
        logger.info("Omaha - UPS F/W " + string + ", return " + bl);
        return bl;
    }

    private boolean isGalaxy6xxx(String string, String string2) {
        boolean bl = false;
        if (string2 != null && Pattern.matches(kMStarGalaxyUPS6000ModelType, string2.toUpperCase())) {
            bl = true;
        }
        logger.info("Omaha - UPS F/W " + string + ", return " + bl);
        return bl;
    }

    private boolean isGalaxy9xxx(String string, String string2) {
        boolean bl = false;
        if (string2 != null && Pattern.matches(kMStarGalaxyUPS9000ModelType, string2.toUpperCase())) {
            bl = true;
        }
        logger.info("Omaha - UPS F/W " + string + ", return " + bl);
        return bl;
    }

    private boolean isEPS6xxx(String string, String string2) {
        boolean bl = false;
        if (string2 != null && Pattern.matches(KMStarEPS6000ModelType, string2.toUpperCase())) {
            bl = true;
        }
        logger.info("Omaha - UPS F/W " + string + ", return " + bl);
        return bl;
    }

    private boolean isEPS7xxx(String string, String string2) {
        boolean bl = false;
        if (string2 != null && Pattern.matches(KMStarEPS7000ModelType, string2.toUpperCase())) {
            bl = true;
        }
        logger.info("Omaha - UPS F/W " + string + ", return " + bl);
        return bl;
    }

    private boolean isEPS8xxx(String string, String string2) {
        boolean bl = false;
        if (string2 != null && Pattern.matches(KMStarEPS8000ModelType, string2.toUpperCase())) {
            bl = true;
        }
        logger.info("Omaha - UPS F/W " + string + ", return " + bl);
        return bl;
    }

    private boolean isEPS8xxxE(String string, String string2) {
        boolean bl = false;
        if (string2 != null && Pattern.matches(KMStarEPS8000EModelType, string2.toUpperCase())) {
            bl = true;
        }
        logger.info("Omaha - UPS F/W " + string + ", return " + bl);
        return bl;
    }

    private boolean isYamuna_Ganga(String string, String string2) {
        boolean bl = false;
        if (string2 != null && Pattern.matches(kSRCModelType, string2.toUpperCase())) {
            bl = true;
        }
        logger.info("Omaha - UPS F/W " + string + ", return " + bl);
        return bl;
    }

    private boolean isMStar(String string, String string2) {
        boolean bl = false;
        if (string2 != null && Pattern.matches(kMstarType, string2.toUpperCase())) {
            bl = true;
        }
        logger.info("Omaha - UPS F/W " + string + ", return " + bl);
        return bl;
    }

    private boolean isSmartUPSVT(String string, String string2) {
        boolean bl = false;
        if (string != null && this.isInRange(string, 900, 921)) {
            bl = true;
        }
        if (string2 != null && string2.toUpperCase().indexOf(kSmartUPSModelType) >= 0 && string2.toUpperCase().indexOf(kSmartUPSVTType) >= 0) {
            bl = true;
        }
        logger.info("Omaha - UPS F/W " + string + ", return " + bl);
        return bl;
    }

    private boolean isInRange(String string, int n, int n2) {
        int n3;
        boolean bl = false;
        if (string != null && (n3 = string.indexOf(46)) != -1) {
            try {
                int n4 = Integer.parseInt(string.substring(0, n3));
                if (n4 >= n && n4 <= n2) {
                    bl = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                logger.trace("FlexEventList.isInRange: invalid fw rev=" + string, (Throwable)numberFormatException);
            }
        }
        return bl;
    }

    public FlexEventList(OmahaComponent omahaComponent) {
        this.theOmahaComponent = omahaComponent;
        this.initialise_events();
    }

    public void generate_events() {
        String string = this.theOmahaComponent.getEventSelectorBitmask();
        if (string != null) {
            this.generateEventListByBitmask();
        } else {
            this.generateEventListByModelName();
        }
    }

    private void generateEventListByBitmask() {
        String string = this.theOmahaComponent.getEventSelectorBitmask();
        BitmaskUtils bitmaskUtils = new BitmaskUtils(string);
        String string2 = this.theOmahaComponent.getUPSModel();
        boolean bl = this.theOmahaComponent.isEnvironmentalCardAvailable();
        boolean bl2 = this.theOmahaComponent.isIntegratedEnvCardAvailable();
        Vector<IFlexEventDescriptor> vector = new Vector<IFlexEventDescriptor>();
        HashSet<Class> hashSet = new HashSet<Class>();
        this.theFlexEvents = new Vector();
        if (string2 != null && string2.startsWith(kRedundantModelType)) {
            logger.debug("Redundant UPS: Adding Single Power Failed and Single Power Restored Events");
            vector.addElement(new SinglePowerFailedDescriptor());
            vector.addElement(new SinglePowerRestoredDescriptor());
            hashSet.add(SinglePowerFailedDescriptor.class);
            hashSet.add(SinglePowerRestoredDescriptor.class);
        }
        if (bitmaskUtils.isBitSet(0)) {
            logger.debug("Bit 0 - Adding Power Failed/ Restored Events");
            vector.add(new PowerFailedDescriptor());
            vector.add(new PowerRestoredDescriptor());
            hashSet.add(PowerFailedDescriptor.class);
            hashSet.add(PowerRestoredDescriptor.class);
        }
        if (bitmaskUtils.isBitSet(1)) {
            logger.debug("Bit 1 - Adding Runtime Exceeded/ Within Range events");
            vector.add(new RunTimeExceededDescriptor());
            vector.add(new RunTimeWithinRangeDescriptor());
            hashSet.add(RunTimeExceededDescriptor.class);
            hashSet.add(RunTimeWithinRangeDescriptor.class);
        }
        if (bitmaskUtils.isBitSet(2)) {
            logger.debug("Bit 2 - Adding Runtime Remaining below threshold/ Runtime remaining above threshold events");
            vector.add(new RunTimeRemainingDescriptor());
            vector.add(new RunTimeRemainingClearedDescriptor());
            hashSet.add(RunTimeRemainingDescriptor.class);
            hashSet.add(RunTimeRemainingClearedDescriptor.class);
        }
        if (bitmaskUtils.isBitSet(3)) {
            logger.debug("Bit 3 - Adding Battery Discharged/ Charge in Range events");
            vector.add(new BatteryDischargedDescriptor());
            vector.add(new BatteryChargeInRangeDescriptor());
            hashSet.add(BatteryDischargedDescriptor.class);
            hashSet.add(BatteryChargeInRangeDescriptor.class);
        }
        if (bitmaskUtils.isBitSet(4)) {
            logger.debug("Bit 4 - Adding Fault Bypass/ Bypass cleared events");
            vector.add(new FaultBypassEnabledDescriptor());
            vector.add(new BypassDisabledDescriptor());
            hashSet.add(FaultBypassEnabledDescriptor.class);
            hashSet.add(BypassDisabledDescriptor.class);
        }
        if (bitmaskUtils.isBitSet(5)) {
            logger.debug("Bit 5 - Adding Bypass Enabled event");
            vector.add(new BypassEnabledDescriptor());
            hashSet.add(BypassEnabledDescriptor.class);
            if (!hashSet.contains(BypassDisabledDescriptor.class)) {
                logger.debug("Bit 5 - Adding Bypass Cleared event");
                vector.add(new BypassDisabledDescriptor());
                hashSet.add(BypassDisabledDescriptor.class);
            }
        }
        if (bitmaskUtils.isBitSet(6)) {
            logger.debug("Bit 6 - Adding Manual Bypass event");
            vector.add(new BypassManualEnabledDescriptor());
            hashSet.add(BypassManualEnabledDescriptor.class);
            if (!hashSet.contains(BypassDisabledDescriptor.class)) {
                logger.debug("Bit 6 - Adding Bypass Cleared event");
                vector.add(new BypassDisabledDescriptor());
                hashSet.add(BypassDisabledDescriptor.class);
            }
        }
        if (bitmaskUtils.isBitSet(7)) {
            logger.debug("Bit 7 - Adding Bypass Contactor Failed/ Bypass Contactor OK events");
            vector.add(new BypassContactorFailedDescriptor());
            vector.add(new BypassContactorOkDescriptor());
            hashSet.add(BypassContactorFailedDescriptor.class);
            hashSet.add(BypassContactorOkDescriptor.class);
        }
        if (bitmaskUtils.isBitSet(8)) {
            logger.debug("Bit 8 - Adding Comms Lost on Battery Event");
            vector.add(new CommunicationLostOnBatteryDescriptor());
            hashSet.add(CommunicationLostOnBatteryDescriptor.class);
        }
        if (bitmaskUtils.isBitSet(9)) {
            logger.debug("Bit 9 - Adding Comms Lost Event");
            vector.add(new CommunicationLostDescriptor());
            hashSet.add(CommunicationLostDescriptor.class);
        }
        if (bitmaskUtils.isBitSet(10)) {
            logger.debug("Bit 10 - Adding Net Communications Lost event");
            vector.add(new NetCommunicationLostDescriptor());
            hashSet.add(NetCommunicationLostDescriptor.class);
        }
        if (bitmaskUtils.isBitSet(11)) {
            logger.debug("Bit 11 - Adding Communications Established event");
            vector.add(new CommunicationEstablishedDescriptor());
            hashSet.add(CommunicationEstablishedDescriptor.class);
        }
        if (bitmaskUtils.isBitSet(12)) {
            logger.debug("Bit 12 - Adding Minimum Redundancy Lost/ Regained events");
            vector.add(new MinRedundancyLostDescriptor());
            vector.add(new MinRedundancyRegainedDescriptor());
            hashSet.add(MinRedundancyLostDescriptor.class);
            hashSet.add(MinRedundancyRegainedDescriptor.class);
        }
        if (bitmaskUtils.isBitSet(13)) {
            logger.debug("Bit 13 - Adding Minimum Load Capability Lost/ Regained events");
            vector.add(new MinLoadCapabilityLostDescriptor());
            vector.add(new MinLoadCapabilityRegainedDescriptor());
            hashSet.add(MinLoadCapabilityLostDescriptor.class);
            hashSet.add(MinLoadCapabilityRegainedDescriptor.class);
        }
        if (bitmaskUtils.isBitSet(14)) {
            logger.debug("Bit 14 - Adding Internal Temperature Exceeded/ In Range events");
            vector.add(new MaxInternalTempExceededDescriptor());
            vector.add(new InternalTempInRangeDescriptor());
            hashSet.add(MaxInternalTempExceededDescriptor.class);
            hashSet.add(InternalTempInRangeDescriptor.class);
        }
        if (bitmaskUtils.isBitSet(15)) {
            logger.debug("Bit 15 - Adding Overload/ Overload Solved events");
            vector.add(new OverloadDescriptor());
            vector.add(new OverloadSolvedDescriptor());
            hashSet.add(OverloadDescriptor.class);
            hashSet.add(OverloadSolvedDescriptor.class);
        }
        if (bitmaskUtils.isBitSet(16)) {
            logger.debug("Bit 16 - Adding Parallel Redundancy Lost/ Regained events");
            vector.add(new ParallelRedundancyLostDescriptor());
            vector.add(new ParallelRedundancyRegainedDescriptor());
            hashSet.add(ParallelRedundancyLostDescriptor.class);
            hashSet.add(ParallelRedundancyRegainedDescriptor.class);
        }
        if (bl && bitmaskUtils.isBitSet(23)) {
            logger.debug("Bit 23 - Environmental Communication Lost/ Established events");
            vector.add(new EnvironmentCommunicationLostDescriptor());
            vector.add(new EnvironmentCommunicationEstablishedDescriptor());
            hashSet.add(EnvironmentCommunicationLostDescriptor.class);
            hashSet.add(EnvironmentCommunicationEstablishedDescriptor.class);
        }
        if ((bl || bl2) && bitmaskUtils.isBitSet(24)) {
            logger.debug("Bit 24 - Adding Probe 1 Temperature Out of Range/ In Range events");
            vector.add(new TempOutOfRangeProbe1Descriptor());
            vector.add(new TempInRangeProbe1Descriptor());
            hashSet.add(TempOutOfRangeProbe1Descriptor.class);
            hashSet.add(TempInRangeProbe1Descriptor.class);
        }
        if (bl && bitmaskUtils.isBitSet(25)) {
            logger.debug("Bit 25 - Adding Probe 2 Temperature Out of Range/ In Range events");
            vector.add(new TempOutOfRangeProbe2Descriptor());
            vector.add(new TempInRangeProbe2Descriptor());
            hashSet.add(TempOutOfRangeProbe2Descriptor.class);
            hashSet.add(TempInRangeProbe2Descriptor.class);
        }
        if ((bl || bl2) && bitmaskUtils.isBitSet(28)) {
            logger.debug("Bit 28 - Adding Probe 1 Humidity Out of Range/ In Range events");
            vector.add(new HumidityOutOfRangeProbe1Descriptor());
            vector.add(new HumidityInRangeProbe1Descriptor());
            hashSet.add(HumidityOutOfRangeProbe1Descriptor.class);
            hashSet.add(HumidityInRangeProbe1Descriptor.class);
        }
        if (bl && bitmaskUtils.isBitSet(29)) {
            logger.debug("Bit 29 - Adding Probe 2 Humidity Out of Range/ In Range events");
            vector.add(new HumidityOutOfRangeProbe2Descriptor());
            vector.add(new HumidityInRangeProbe2Descriptor());
            hashSet.add(HumidityOutOfRangeProbe2Descriptor.class);
            hashSet.add(HumidityInRangeProbe2Descriptor.class);
        }
        if ((bl || bl2) && bitmaskUtils.isBitSet(32)) {
            logger.debug("Bit 32 - Adding Contact 1 Fault/ Normal events");
            vector.add(new ContactFault1Descriptor());
            vector.add(new ContactNormal1Descriptor());
            hashSet.add(ContactFault1Descriptor.class);
            hashSet.add(ContactNormal1Descriptor.class);
        }
        if ((bl || bl2) && bitmaskUtils.isBitSet(33)) {
            logger.debug("Bit 33 - Adding Contact 2 Fault/ Normal events");
            vector.add(new ContactFault2Descriptor());
            vector.add(new ContactNormal2Descriptor());
            hashSet.add(ContactFault2Descriptor.class);
            hashSet.add(ContactNormal2Descriptor.class);
        }
        if (bl && bitmaskUtils.isBitSet(34)) {
            logger.debug("Bit 34 - Adding Contact 3 Fault/ Normal events");
            vector.add(new ContactFault3Descriptor());
            vector.add(new ContactNormal3Descriptor());
            hashSet.add(ContactFault3Descriptor.class);
            hashSet.add(ContactNormal3Descriptor.class);
        }
        if (bl && bitmaskUtils.isBitSet(35)) {
            logger.debug("Bit 35 - Adding Contact 4 Fault/ Normal events");
            vector.add(new ContactFault4Descriptor());
            vector.add(new ContactNormal4Descriptor());
            hashSet.add(ContactFault4Descriptor.class);
            hashSet.add(ContactNormal4Descriptor.class);
        }
        this.theFlexEvents = vector;
    }

    private void generateEventListByModelName() {
        Vector<IFlexEventDescriptor> vector;
        this.theFlexEvents = new Vector();
        boolean bl = this.theOmahaComponent.isEnvironmentalCardAvailable();
        boolean bl2 = this.theOmahaComponent.isIntegratedEnvCardAvailable();
        String string = this.theOmahaComponent.getUPSModel();
        String string2 = this.theOmahaComponent.getFirmwareRevision();
        if (string != null) {
            logger.info("Omaha - UPS Model Name:  " + string);
        }
        if (string == null) {
            logger.info("Omaha - Add List (3) - Default to Smart-UPS");
            vector = this.getEventList(3);
        } else if (string.indexOf(kSmartUPSDPClusterModelType) >= 0) {
            if (this.isGalaxy7xxx(string2, string)) {
                logger.info("Omaha - Add Galaxy 7000 Events");
                vector = this.getEventList(1);
            } else if (this.isGalaxy5xxx(string2, string)) {
                logger.info("Omaha - Add Galaxy 5000/5500 Events");
                vector = this.getEventList(10);
            } else if (this.isGalaxy6xxx(string2, string)) {
                logger.info("Omaha - Add Galaxy 6000 Events");
                vector = this.getEventList(11);
            } else if (this.isGalaxy9xxx(string2, string)) {
                logger.info("Omaha - Add Galaxy 9000 Events");
                vector = this.getEventList(11);
            } else if (this.isEPS6xxx(string2, string)) {
                logger.info("Omaha - Add EPS 6000 Events");
                vector = this.getEventList(11);
            } else if (this.isEPS7xxx(string2, string)) {
                logger.info("Omaha - Add EPS 7000 Events");
                vector = this.getEventList(11);
            } else if (this.isEPS8xxx(string2, string)) {
                logger.info("Omaha - Add EPS 8000 Events");
                vector = this.getEventList(11);
            } else if (this.isEPS8xxxE(string2, string)) {
                logger.info("Omaha - Add EPS 8000E Events");
                vector = this.getEventList(11);
            } else if (this.isValhalUPS(string2, string)) {
                logger.info("Omaha - Add GALAXY VM(Valhal) Events");
                vector = this.getEventList(12);
            } else if (this.isYamuna_Ganga(string2, string)) {
                logger.info("Omaha - Add SRC Events");
                vector = this.getEventList(7);
            } else if (this.isMStar(string2, string)) {
                logger.info("Omaha - Add MGE Galaxy 3xx Events");
                vector = this.getEventList(8);
            } else if (this.isSmartUPSVT(string2, string) || this.isGalaxy(string2, string)) {
                logger.info("Omaha - Add Smart-UPS RT/VT Events");
                vector = this.getEventList(6);
            } else if (string.toUpperCase().indexOf(kSymmetraUPSType) >= 0) {
                logger.info("Omaha - Add Symmetra Events");
                vector = this.getEventList(1);
            } else if (this.isSmartUPSOnLine(string2, string)) {
                logger.info("Omaha - Add Smart-UPS RT/VT Events");
                vector = this.getEventList(7);
            } else {
                logger.info("Omaha - Add Parallel DP Events");
                vector = this.getEventList(5);
            }
        } else if (this.isGalaxy5xxx(string2, string)) {
            logger.info("Omaha - Add Galaxy 5000/5500 Events");
            vector = this.getEventList(10);
        } else if (this.isGalaxy6xxx(string2, string)) {
            logger.info("Omaha - Add Galaxy 6000 Events");
            vector = this.getEventList(11);
        } else if (this.isGalaxy9xxx(string2, string)) {
            logger.info("Omaha - Add Galaxy 9000 Events");
            vector = this.getEventList(11);
        } else if (this.isEPS6xxx(string2, string)) {
            logger.info("Omaha - Add EPS 6000 Events");
            vector = this.getEventList(11);
        } else if (this.isEPS7xxx(string2, string)) {
            logger.info("Omaha - Add EPS 7000 Events");
            vector = this.getEventList(11);
        } else if (this.isEPS8xxx(string2, string)) {
            logger.info("Omaha - Add EPS 8000 Events");
            vector = this.getEventList(11);
        } else if (this.isEPS8xxxE(string2, string)) {
            logger.info("Omaha - Add EPS 8000E Events");
            vector = this.getEventList(11);
        } else if (this.isValhalUPS(string2, string)) {
            logger.info("Omaha - Add GALAXY VM(Valhal) Events");
            vector = this.getEventList(9);
        } else if (this.isGalaxy7xxx(string2, string)) {
            logger.info("Omaha - Add Galaxy 7000 Events");
            vector = this.getEventList(1);
        } else if (this.isYamuna_Ganga(string2, string)) {
            logger.info("Omaha - Add SRC Events");
            vector = this.getEventList(7);
        } else if (this.isMStar(string2, string)) {
            logger.info("Omaha - Add Smartups VE Events");
            vector = this.getEventList(8);
        } else if (string.indexOf(kSmartUPSDP300ModelType) > 0) {
            logger.info("Omaha - Add Smart-UPS DP Events");
            vector = this.getEventList(4);
        } else if (string.toUpperCase().indexOf(kSymmetraUPSType) >= 0) {
            logger.info("Omaha - Add Symmetra Events");
            vector = this.getEventList(1);
        } else if (string.indexOf(kSmartUPSDP100ModelType) > 0) {
            logger.info("Omaha - Add Matrix Events (1)");
            vector = this.getEventList(2);
        } else if (string.toUpperCase().indexOf(kMatrixUPSType) >= 0) {
            logger.info("Omaha - Add Matrix Events (2)");
            vector = this.getEventList(2);
        } else if (this.isSmartUPSOnLine(string2, string) || this.isSmartUPSVT(string2, string)) {
            logger.info("Omaha - Add Smart-UPS RT/VT Events");
            vector = this.getEventList(7);
        } else if (this.isGalaxy(string2, string)) {
            logger.info("Omaha - Add Galaxy Events");
            vector = this.getEventList(7);
        } else if (Pattern.matches(kIBMUnionModelType, string.toUpperCase()) && string.indexOf(1) > 0) {
            logger.info("Omaha - Add Smart-UPS RT/VT Events");
            vector = this.getEventList(7);
        } else {
            logger.info("Omaha - Add List (3) - Default to Smart-UPS");
            vector = this.getEventList(3);
        }
        if (string != null && string.startsWith(kRedundantModelType)) {
            vector.addElement(new SinglePowerFailedDescriptor());
            vector.addElement(new SinglePowerRestoredDescriptor());
        }
        if (bl) {
            logger.info("Omaha - Add Environmental Events");
            vector.addElement(new EnvironmentCommunicationEstablishedDescriptor());
            vector.addElement(new EnvironmentCommunicationLostDescriptor());
            vector.addElement(new TempInRangeProbe1Descriptor());
            vector.addElement(new TempOutOfRangeProbe1Descriptor());
            vector.addElement(new HumidityInRangeProbe1Descriptor());
            vector.addElement(new HumidityOutOfRangeProbe1Descriptor());
            vector.addElement(new TempInRangeProbe2Descriptor());
            vector.addElement(new TempOutOfRangeProbe2Descriptor());
            vector.addElement(new HumidityInRangeProbe2Descriptor());
            vector.addElement(new HumidityOutOfRangeProbe2Descriptor());
            vector.addElement(new ContactNormal1Descriptor());
            vector.addElement(new ContactNormal2Descriptor());
            vector.addElement(new ContactNormal3Descriptor());
            vector.addElement(new ContactNormal4Descriptor());
            vector.addElement(new ContactFault1Descriptor());
            vector.addElement(new ContactFault2Descriptor());
            vector.addElement(new ContactFault3Descriptor());
            vector.addElement(new ContactFault4Descriptor());
        } else if (bl2) {
            logger.info("Omaha - Add Integrated Env Events");
            vector.addElement(new TempInRangeProbe1Descriptor());
            vector.addElement(new TempOutOfRangeProbe1Descriptor());
            vector.addElement(new HumidityInRangeProbe1Descriptor());
            vector.addElement(new HumidityOutOfRangeProbe1Descriptor());
            vector.addElement(new ContactNormal1Descriptor());
            vector.addElement(new ContactNormal2Descriptor());
            vector.addElement(new ContactFault1Descriptor());
            vector.addElement(new ContactFault2Descriptor());
        }
        this.theFlexEvents = vector;
    }

    @Override
    public Object getValue() throws CommunicationException {
        Object object = null;
        this.generate_events();
        object = this.theFlexEvents.clone();
        return object;
    }

    @Override
    public void setValue(Object object, SetResult setResult) throws InvalidValueException, CommunicationException {
        setResult.setSuccessful(false);
        throw new InvalidValueException(3);
    }

    @Override
    public IAvailability getAvailability() {
        return Availability.AVAILABLE;
    }

    @Override
    public IAllowedValues getAllowedValues() {
        return null;
    }

    @Override
    public IFormatter getFormatter() {
        return null;
    }
}

