/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.omaha;

import com.apcc.m11.components.omaha.BitmaskUtils;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModelChecks {
    private static final Logger logger = LogManager.getLogger(ModelChecks.class);
    private static final String kSymmetra = "SYMMETRA";
    private static final String kSymmetra_pattern = ".*SYMMETRA.*";
    private static final String kIBMUnion_pattern = ".*IBM.UPS.*";
    private static final String kStallion = "IBM UPS";
    private static final String kGalaxy7000_pattern = ".*GALAXY 7\\d\\d\\d.*";
    private static final String kGalaxy7000 = "GALAXY 7000";
    private static final String kGalaxy300_pattern = ".*MGE GALAXY 3\\d\\d.*";
    private static final String kGalaxy300 = "GALAXY 300";
    private static final String kGalaxy_pattern = ".*GALAXY.*";
    private static final String kGalaxy = "GALAXY";
    private static final String kSmart_ups_rt_pattern = ".*SMART-UPS RT.*";
    private static final String kSmart_ups_srt_pattern = ".*SMART-UPS SRT.*";
    private static final String kSmart_ups_rc_pattern = ".*SMART-UPS RC.*";
    private static final String kSmart_ups_rt = "SMART-UPS RT";
    private static final String kSmart_ups_vt_pattern = ".*SMART-UPS VT.*";
    private static final String kSmart_ups_vt = "SMART-UPS VT";
    private static final String kSiliconDP3_pattern = ".*DP3.*";
    private static final String kSiliconDP3 = "SILICON DP3";
    private static final String kSmart_ups_dp_pattern = ".*SMART-UPS DP .*";
    private static final String kSmart_ups_dp = "SMART-UPS DP";
    private static final String kSmart_ups_pattern = ".*SMART-UPS.*";
    private static final String kSmart_ups = "SMART-UPS";
    private static final String kMatrix_pattern = ".*MATRIX.*";
    private static final String kMatrix = "MATRIX";
    private static final String kSRC_pattern = ".*SMART-UPS SRC.*";
    private static final String kSRC = "SMART_UPS SRC";
    private static final String kSURTD = "SURTD";
    private static final String kSMX = "SMX";
    private static final char CTRL_A = '\u0001';

    public static Integer isRedundant(Vector<String> vector, Vector<String> vector2, Vector<Integer> vector3, Vector<String> vector4) {
        Integer n = 101;
        if (vector4.size() == vector.size()) {
            if (!BitmaskUtils.hasCompatibleBitmasks(vector4)) {
                n = 102;
            }
        } else {
            Object object = null;
            int n2 = 0;
            for (String string : vector) {
                String string2 = vector2.get(n2);
                if (object == null) {
                    object = ModelChecks.getSupportedFamilyName(string, string2);
                }
                if (!((String)object).equals(ModelChecks.getSupportedFamilyName(string, string2))) {
                    return 102;
                }
                ++n2;
            }
        }
        if (vector3 != null) {
            for (Integer n3 : vector3) {
                if (n3 <= 1) continue;
                return 103;
            }
        }
        return n;
    }

    public static Integer isAdvanced(Vector<String> vector, Vector<String> vector2, Vector<Integer> vector3, Vector<String> vector4) {
        logger.debug("isAdvanced() - start");
        Integer n = 101;
        if (vector4 != null && vector != null && vector4.size() == vector.size()) {
            logger.debug("isAdvanced() using feature masks {}", vector4);
            if (!BitmaskUtils.hasCompatibleBitmasks(vector4)) {
                n = 102;
            }
        } else {
            logger.debug("isAdvanced() - using model names {}", vector);
            Object object = null;
            int n2 = 0;
            for (String string : vector) {
                String string2 = vector2.get(n2);
                if (object == null) {
                    object = ModelChecks.getSupportedFamilyName(string, string2);
                } else if (!((String)object).equals(ModelChecks.getSupportedFamilyName(string, string2))) {
                    return 102;
                }
                ++n2;
            }
        }
        if (vector3 != null) {
            for (Integer n3 : vector3) {
                if (n3 <= 1) continue;
                return 109;
            }
        }
        return n;
    }

    public static Integer isParallel(Vector<String> vector, Vector<String> vector2, Vector<Integer> vector3, Vector<String> vector4) {
        Integer n = 101;
        String string = null;
        int n2 = 0;
        for (String object : vector) {
            String string2 = vector2.get(n2);
            if (string == null) {
                string = ModelChecks.getSupportedFamilyName(object, string2);
            }
            if (!string.equals(ModelChecks.getSupportedFamilyName(object, string2))) {
                return 102;
            }
            ++n2;
        }
        if (vector4 != null && !vector4.isEmpty()) {
            if (vector4.size() == vector.size()) {
                if (!BitmaskUtils.hasCompatibleBitmasks(vector4)) {
                    n = 102;
                }
            } else {
                n = 102;
            }
        }
        if (vector3 != null) {
            if (vector3.get(0) < 2) {
                return 104;
            }
            int n3 = vector3.get(0);
            for (Integer n4 : vector3) {
                if (n3 == n4) continue;
                return 107;
            }
            if (vector3.get(0).intValue() != vector.size()) {
                return 106;
            }
        }
        return n;
    }

    public static String getSupportedFamilyName(String string, String string2) {
        String string3 = "NONE";
        if (string != null) {
            if (Pattern.matches(kSymmetra_pattern, string = string.toUpperCase())) {
                string3 = kSymmetra;
            } else if (Pattern.matches(kIBMUnion_pattern, string) && string.indexOf(1) > 0) {
                string3 = kSmart_ups_rt;
            } else if (Pattern.matches(kIBMUnion_pattern, string) && string.indexOf(1) == -1) {
                string3 = kStallion;
            } else if (Pattern.matches(kGalaxy7000_pattern, string)) {
                string3 = kGalaxy7000;
            } else if (Pattern.matches(kGalaxy300_pattern, string)) {
                string3 = kGalaxy300;
            } else if (Pattern.matches(kGalaxy_pattern, string)) {
                string3 = kGalaxy;
            } else if (Pattern.matches(kSmart_ups_rt_pattern, string) && string.indexOf(1) > 0) {
                string3 = kSmart_ups_rt;
            } else if (Pattern.matches(kSmart_ups_srt_pattern, string)) {
                string3 = kSmart_ups_rt;
            } else if (Pattern.matches(kSRC_pattern, string)) {
                string3 = kSRC;
            } else if (ModelChecks.isInRange(string2, 400, 499) || ModelChecks.isInRange(string2, 800, 809) || ModelChecks.isInRange(string2, 1100, 1109) || Pattern.matches(kSmart_ups_rt_pattern, string) || Pattern.matches(kSmart_ups_rc_pattern, string)) {
                string3 = kSmart_ups_rt;
            } else if (ModelChecks.isInRange(string2, 900, 921) || Pattern.matches(kSmart_ups_vt_pattern, string)) {
                string3 = kSmart_ups_vt;
            } else if (Pattern.matches(kSiliconDP3_pattern, string)) {
                string3 = kSiliconDP3;
            } else if (Pattern.matches(kSmart_ups_dp_pattern, string)) {
                string3 = kSmart_ups_dp;
            } else if (Pattern.matches(kSmart_ups_pattern, string) && string.indexOf(1) > 0) {
                string3 = kSmart_ups;
            } else if (Pattern.matches(kSmart_ups_pattern, string)) {
                string3 = kSmart_ups;
            } else if (Pattern.matches(kMatrix_pattern, string)) {
                string3 = kMatrix;
            }
        }
        return string3;
    }

    private static boolean isInRange(String string, int n, int n2) {
        int n3;
        boolean bl = false;
        if (string != null && (n3 = string.indexOf(46)) != -1) {
            try {
                int n4 = Integer.parseInt(string.substring(0, n3));
                if (n4 >= n && n4 <= n2) {
                    bl = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                logger.warn("FlexEventList.isInRange: ignoring non-integer fw rev=" + string);
            }
        }
        return bl;
    }
}

