/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.omaha;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.RegistrationException;
import com.apcc.m11.arch.VariableBinding;
import com.apcc.m11.arch.component.ComponentFailureException;
import com.apcc.m11.arch.component.ComponentID;
import com.apcc.m11.arch.component.IComponent;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.arch.event.IEventConsumer;
import com.apcc.m11.arch.event.IEventProducer;
import com.apcc.m11.arch.m11component.IM11Component;
import com.apcc.m11.arch.m11component.M11ComponentSynchronizer;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.arch.storage.ITemporaryStorage;
import com.apcc.m11.arch.storage.StorageEntryException;
import com.apcc.m11.components.omaha.BitmaskUtils;
import com.apcc.m11.components.omaha.DataSourceAdapter;
import com.apcc.m11.ds.arch.interfaces.DataConsumer;
import com.apcc.m11.ds.arch.interfaces.DataSource;
import com.apcc.m11.ds.arch.interfaces.EventConsumer;
import com.apcc.m11.ds.arch.interfaces.M11Component;
import com.apcc.m11.ds.events.flexevents.EnvironmentalEvents;
import com.apcc.m11.ds.events.flexevents.powersource.Communication;
import com.apcc.m11.ds.events.internalEvents.application.AllComponentsStarted;
import com.apcc.m11.ds.powersource.Identification;
import com.apcc.m11.ds.services.eventlogginggroup.EventLoggingGroup;
import com.apcc.m11.ds.services.omaha.Omaha;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OmahaComponent
implements IComponent,
IM11Component,
IEventConsumer {
    private static final Logger logger = LogManager.getLogger(OmahaComponent.class);
    private static final String kOmahaComponentName = "Omaha";
    private static final String kComponentVersion = "1.0.0";
    public static final String kDebugGroupId = "Omaha";
    public static final String kDefaultsSetFlag = "DefaultValuesSetFlag";
    public static final String kCommEstablishedSetFlag = "CommEstablishedSetFlag";
    public static final String kDefaultsEnvironmentSetFlag = "DefaultEnvironmentValuesSetFlag";
    public static final String kResourceBundleEventNameBasename = "com.apcc.m11.components.omaha.i18n.OmahaEventNames";
    public static final String kResourceBundleEventDescBasename = "com.apcc.m11.components.omaha.i18n.OmahaEventDescriptions";
    public static final String kResourceBundleGroupNamesBasename = "com.apcc.m11.components.omaha.i18n.OmahaEventGroups";
    public static final String kResourceBundleEventActionNamesBasename = "com.apcc.m11.components.omaha.i18n.OmahaEventActions";
    public static final int kGroupOne = 1;
    private M11ComponentSynchronizer theSynchronizer;
    private IPermanentStorage thePermanentStorage;
    private DataSourceAdapter theDataSource;
    private Vector<IEventProducer> theEventProducers;
    private String theModelName = null;
    private String theFirmwareRevision;
    private String theEventSelectorBitmask = null;
    private boolean theEnvironmentalCardAvailability = false;
    private boolean theIntegratedEnvCardAvailability = false;
    private Integer theInstallGroup = 1;
    protected static final int kRequestTimeout = 1000;
    protected static final int kRequestRetryCount = 3;

    public OmahaComponent() {
        logger.debug("Omaha created");
        this.theSynchronizer = null;
        this.theDataSource = null;
        this.theEventProducers = new Vector();
    }

    public Object getInstanceOf(ObjectId objectId) throws InvalidObjectIdException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        OmahaComponent omahaComponent = null;
        if (!objectId.equals((Object)M11Component.kOid)) {
            throw new InvalidObjectIdException();
        }
        omahaComponent = this;
        return omahaComponent;
    }

    public void init(IPermanentStorage iPermanentStorage) throws ComponentFailureException {
        if (iPermanentStorage == null) {
            throw new ComponentFailureException("Permanent storage can't be null.");
        }
        this.thePermanentStorage = iPermanentStorage;
        this.theSynchronizer = new M11ComponentSynchronizer();
        this.theDataSource = new DataSourceAdapter(this.theSynchronizer, this);
        try {
            ComponentID componentID = new ComponentID("PacketRepeater");
            Object object = this.thePermanentStorage.readData(componentID, "InstallGroup");
            if (object instanceof Integer) {
                this.theInstallGroup = (Integer)object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.theDataSource.buildObjectTree(this.theInstallGroup);
    }

    public void start() {
        this.theSynchronizer.setState(2);
    }

    public void start(ITemporaryStorage iTemporaryStorage) {
        this.start();
    }

    public void stop() {
        this.theSynchronizer.setState(1);
    }

    public void stop(ITemporaryStorage iTemporaryStorage) {
        this.stop();
    }

    public void suspend() {
        this.theSynchronizer.setState(3);
    }

    public void resume() {
        if (this.theSynchronizer.getState() == 3) {
            this.theSynchronizer.setState(2);
        }
    }

    public Object getInterface(ObjectId objectId) throws InvalidObjectIdException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        Object object = null;
        if (objectId.equals((Object)DataSource.kOid)) {
            object = this.theDataSource;
        } else if (objectId.equals((Object)DataConsumer.kOid)) {
            object = this.theDataSource;
        } else if (objectId.equals((Object)EventConsumer.kOid)) {
            object = this;
        } else {
            throw new InvalidObjectIdException("Unsupported interface.");
        }
        return object;
    }

    public ComponentID getComponentID() {
        return new ComponentID("Omaha");
    }

    public String getComponentName() {
        return "Omaha";
    }

    public String getComponentVersion() {
        return kComponentVersion;
    }

    public void registerEventProducer(IEventProducer iEventProducer) throws RegistrationException {
        if (iEventProducer == null) {
            throw new RegistrationException("EventProducer can't be null.");
        }
        this.theEventProducers.addElement(iEventProducer);
    }

    public void unRegisterEventProducer(IEventProducer iEventProducer) throws RegistrationException {
        if (iEventProducer == null) {
            throw new RegistrationException("EventProducer can't be null.");
        }
        this.theEventProducers.removeElement(iEventProducer);
    }

    public Enumeration<ObjectId> getConsumedEvents() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.addElement(AllComponentsStarted.kOid);
        vector.addElement(Communication.MonitoringStarted.getObjectId());
        vector.addElement(Communication.CommunicationEstablished.getObjectId());
        vector.addElement(Communication.CannotCommunicateResolved.getObjectId());
        vector.addElement(EnvironmentalEvents.EnvironmentNoCommunicationSinceLastReboot.getObjectId());
        vector.addElement(EnvironmentalEvents.EnvironmentCommunicationEstablished.getObjectId());
        vector.addElement(EnvironmentalEvents.EnvironmentCommunicationLost.getObjectId());
        vector.addElement(EnvironmentalEvents.IntegratedEnvCommunicationEstablished.getObjectId());
        return vector.elements();
    }

    public void update(Event event) {
        ObjectId objectId;
        if (event != null && event.isActive() && (objectId = event.getObjectId()) != null) {
            if (objectId.equals((Object)AllComponentsStarted.kOid)) {
                this.updateDefaults(kCommEstablishedSetFlag);
            } else if (objectId.equals((Object)Communication.CommunicationEstablished.getObjectId()) || objectId.equals((Object)Communication.CannotCommunicateResolved.getObjectId()) || objectId.equals((Object)Communication.MonitoringStarted.getObjectId())) {
                IDataSource iDataSource = this.theDataSource.getDataSource();
                try {
                    GetResult getResult = iDataSource.get(Identification.ModelName.getObjectId());
                    this.theModelName = (String)getResult.getValue();
                    getResult = iDataSource.get(Identification.EventSelector.getObjectId());
                    Object object = getResult.getValue();
                    if (object instanceof String) {
                        logger.debug("Event Selector as aString");
                        this.theEventSelectorBitmask = (String)object;
                    } else if (object instanceof Vector) {
                        logger.debug("Event Selector as Vector");
                        this.theEventSelectorBitmask = BitmaskUtils.combineEventMasks((Vector)object);
                    }
                    try {
                        getResult = iDataSource.get(Identification.FirmwareRevision.getObjectId());
                        this.theFirmwareRevision = getResult.getValue() instanceof Vector ? ((Vector)getResult.getValue()).toString() : (String)getResult.getValue();
                    }
                    catch (Exception exception) {
                        logger.warn("[update] can't get F/W rev :" + this.theFirmwareRevision, (Throwable)exception);
                    }
                    this.updateDefaults(kDefaultsSetFlag);
                    this.updateDefaults(kDefaultsEnvironmentSetFlag);
                }
                catch (CommunicationException communicationException) {
                    logger.debug("[update] " + communicationException.toString());
                }
                catch (Exception exception) {
                    logger.error("[update] " + exception.toString(), (Throwable)exception);
                }
            } else if (objectId.equals((Object)EnvironmentalEvents.EnvironmentCommunicationEstablished.getObjectId()) || objectId.equals((Object)EnvironmentalEvents.EnvironmentCommunicationLost.getObjectId())) {
                this.theEnvironmentalCardAvailability = true;
            } else if (objectId.equals((Object)EnvironmentalEvents.IntegratedEnvCommunicationEstablished.getObjectId())) {
                this.theIntegratedEnvCardAvailability = true;
                IDataSource iDataSource = this.theDataSource.getDataSource();
                try {
                    iDataSource.get(Omaha.FlexEventList.getObjectId());
                }
                catch (Exception exception) {
                    logger.error((Object)exception);
                }
            }
        }
    }

    public String getUPSModel() {
        IDataSource iDataSource = this.theDataSource.getDataSource();
        try {
            GetResult getResult = iDataSource.get(Identification.ModelName.getObjectId());
            this.theModelName = (String)getResult.getValue();
        }
        catch (CommunicationException communicationException) {
            logger.debug("[update] " + communicationException.toString());
        }
        catch (Exception exception) {
            logger.error("[update] " + exception.toString(), (Throwable)exception);
        }
        return this.theModelName;
    }

    public String getFirmwareRevision() {
        return this.theFirmwareRevision;
    }

    public String getEventSelectorBitmask() {
        return this.theEventSelectorBitmask;
    }

    public boolean isEnvironmentalCardAvailable() {
        return this.theEnvironmentalCardAvailability;
    }

    public boolean isIntegratedEnvCardAvailable() {
        return this.theIntegratedEnvCardAvailability;
    }

    public Boolean getFlag(String string) {
        Boolean bl = null;
        try {
            Object object = this.thePermanentStorage.readData(this.getComponentID(), string);
            if (object instanceof Boolean) {
                bl = (Boolean)object;
            }
        }
        catch (Exception exception) {
            logger.warn("Error reading from permanent storage");
        }
        return bl;
    }

    public boolean setFlag(String string, Boolean bl) {
        boolean bl2 = true;
        try {
            this.thePermanentStorage.writeData(this.getComponentID(), string, (Object)bl);
        }
        catch (StorageEntryException storageEntryException) {
            logger.error("Error writing to permanent storage: " + storageEntryException.toString(), (Throwable)storageEntryException);
            bl2 = false;
        }
        return bl2;
    }

    private void updateDefaults(String string) {
        Boolean bl = this.getFlag(string);
        if (bl == null || !bl.booleanValue()) {
            String string2 = "Omaha: Setting Default Values";
            if (string.equals(kDefaultsEnvironmentSetFlag)) {
                string2 = "Omaha: Setting Environmental Default Values";
            }
            logger.info(string2);
            this.setDefaults(string);
            this.setFlag(string, Boolean.TRUE);
        }
    }

    public boolean isShutdownSupported() {
        boolean bl = true;
        if (this.theInstallGroup > 1) {
            bl = false;
        }
        return bl;
    }

    private void setDefaults(String string) {
        if (this.theDataSource == null) {
            return;
        }
        try {
            SetResult setResult = null;
            if (0 == string.compareTo(kDefaultsEnvironmentSetFlag)) {
                setResult = this.theDataSource.set(Omaha.ResetEnvironmentToDefaults.getObjectId(), null);
            } else if (0 == string.compareTo(kDefaultsSetFlag)) {
                setResult = this.theDataSource.set(Omaha.ResetApplicationToDefaults.getObjectId(), null);
            } else if (0 == string.compareTo(kCommEstablishedSetFlag)) {
                VariableBinding variableBinding = new VariableBinding(Communication.CommunicationEstablished.getObjectId(), (Object)0);
                setResult = this.theDataSource.set(EventLoggingGroup.RegisterEventToLog.getObjectId(), variableBinding);
            }
            if (setResult != null && !setResult.wasSuccessful()) {
                logger.debug("Setting detauls failed");
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.debug("unable to set objectID:" + invalidObjectIdException.getLocalizedMessage());
        }
        catch (Exception exception) {
            logger.error("[DefaultValueSetThread] ", (Throwable)exception);
        }
    }
}

