/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.omaha;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.VariableBinding;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.IAllowedValues;
import com.apcc.m11.arch.datasource.IAvailability;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.omaha.IDataObject;
import com.apcc.m11.components.omaha.IDataSourceContainer;
import com.apcc.m11.ds.events.flexevents.RuntimeVerifierEvents;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import com.apcc.m11.ds.events.flexevents.powersource.Battery;
import com.apcc.m11.ds.events.flexevents.powersource.LoadCapability;
import com.apcc.m11.ds.events.flexevents.powersource.MultipleEvent;
import com.apcc.m11.ds.events.flexevents.powersource.Redundancy;
import com.apcc.m11.ds.events.flexevents.powersource.Temperature;
import com.apcc.m11.ds.events.flexevents.powersource.UtilityLineStatus;
import com.apcc.m11.ds.services.RuntimeVerificationGroup;
import com.apcc.m11.ds.services.ShutdownGroup;
import com.apcc.m11.ds.services.messageBroadcastGroup.AddRule;
import com.apcc.m11.ds.services.messageBroadcastGroup.RuleObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResetApplicationToDefaults
implements IDataObject {
    private static final Logger logger = LogManager.getLogger(ResetApplicationToDefaults.class);
    private IDataSourceContainer theDataSourceContainer;
    private final int kShutdownDelayTime10Sec = 10;

    ResetApplicationToDefaults(IDataSourceContainer iDataSourceContainer) {
        this.theDataSourceContainer = iDataSourceContainer;
    }

    ResetApplicationToDefaults(IDataSourceContainer iDataSourceContainer, int n) {
        this.theDataSourceContainer = iDataSourceContainer;
    }

    @Override
    public Object getValue() throws CommunicationException {
        return null;
    }

    @Override
    public void setValue(Object object, SetResult setResult) throws InvalidValueException, CommunicationException {
        this.setShutdownDefaults();
        this.setRunTimeVerifierDefaults();
        this.setNofitierDefaults();
        setResult.setSuccessful(true);
    }

    @Override
    public IAvailability getAvailability() {
        return Availability.AVAILABLE;
    }

    @Override
    public IAllowedValues getAllowedValues() {
        return null;
    }

    @Override
    public IFormatter getFormatter() {
        return null;
    }

    private void setShutdownDefaults() {
        logger.debug("Resetting application to defaults");
        try {
            IDataSource iDataSource = this.theDataSourceContainer.getDataSource();
            VariableBinding variableBinding = new VariableBinding(ShutdownEvents.PowerSourceTurnOffInitiated.getObjectId(), (Object)0);
            SetResult setResult = iDataSource.set(ShutdownGroup.AddShutdownTrigger.getObjectId(), (Object)variableBinding);
            if (!setResult.wasSuccessful()) {
                logger.info("Unable to add ShutdownTrigger for PowerSourceTurnOffInitiated Event");
            }
            variableBinding = new VariableBinding(Battery.LowBattery.getObjectId(), (Object)0);
            setResult = iDataSource.set(ShutdownGroup.AddShutdownTrigger.getObjectId(), (Object)variableBinding);
            if (!setResult.wasSuccessful()) {
                logger.info("Unable to add ShutdownTrigger for LowBattery Event");
            }
            variableBinding = new VariableBinding(MultipleEvent.MultipleCriticalEvent.getObjectId(), (Object)10);
            setResult = iDataSource.set(ShutdownGroup.AddShutdownTrigger.getObjectId(), (Object)variableBinding);
            if (!setResult.wasSuccessful()) {
                logger.info("Unable to add ShutdownTrigger for Multiple Critical Event");
            }
            variableBinding = new VariableBinding(MultipleEvent.CriticalEvent.getObjectId(), (Object)10);
            setResult = iDataSource.set(ShutdownGroup.AddShutdownTrigger.getObjectId(), (Object)variableBinding);
            if (!setResult.wasSuccessful()) {
                logger.info("Unable to add ShutdownTrigger for Critical Event in Cluster");
            }
            variableBinding = new VariableBinding(ShutdownEvents.UPSMainOutletTurnOffInitiated.getObjectId(), (Object)0);
            setResult = iDataSource.set(ShutdownGroup.AddShutdownTrigger.getObjectId(), (Object)variableBinding);
            if (!setResult.wasSuccessful()) {
                logger.info("Unable to add ShutdownTrigger for Critical Event in Cluster");
            }
            variableBinding = new VariableBinding(ShutdownEvents.UPSOutletTurnOffInitiated.getObjectId(), (Object)0);
            setResult = iDataSource.set(ShutdownGroup.AddShutdownTrigger.getObjectId(), (Object)variableBinding);
            if (!setResult.wasSuccessful()) {
                logger.info("Unable to add ShutdownTrigger for Critical Event in Cluster");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setRunTimeVerifierDefaults() {
        try {
            IDataSource iDataSource = this.theDataSourceContainer.getDataSource();
            iDataSource.set(RuntimeVerificationGroup.VerificationFrequency.getObjectId(), (Object)30);
        }
        catch (Exception exception) {
            logger.error("[setRunTimeVerifierDefaults] " + exception.toString(), (Throwable)exception);
        }
    }

    private void setNofitierDefaults() {
        IDataSource iDataSource = this.theDataSourceContainer.getDataSource();
        try {
            RuleObject ruleObject = new RuleObject(UtilityLineStatus.PowerRestored.getObjectId(), UtilityLineStatus.PowerFailed.getObjectId());
            iDataSource.set(AddRule.kOid, (Object)ruleObject);
            ruleObject = new RuleObject(Temperature.MaxInternalTempInRange.getObjectId(), Temperature.MaxInternalTempExceeded.getObjectId());
            iDataSource.set(AddRule.kOid, (Object)ruleObject);
            ruleObject = new RuleObject(Battery.BatteryChargeInRange.getObjectId(), Battery.BatteryDischarged.getObjectId());
            iDataSource.set(AddRule.kOid, (Object)ruleObject);
            ruleObject = new RuleObject(UtilityLineStatus.OverloadSolved.getObjectId(), UtilityLineStatus.Overload.getObjectId());
            iDataSource.set(AddRule.kOid, (Object)ruleObject);
            ruleObject = new RuleObject(Redundancy.MinRedundancyRegained.getObjectId(), Redundancy.MinRedundancyLost.getObjectId());
            iDataSource.set(AddRule.kOid, (Object)ruleObject);
            ruleObject = new RuleObject(LoadCapability.MinLoadCapabilityRegained.getObjectId(), LoadCapability.MinLoadCapabilityLost.getObjectId());
            iDataSource.set(AddRule.kOid, (Object)ruleObject);
            ruleObject = new RuleObject(RuntimeVerifierEvents.RunTimeWithinRange.getObjectId(), RuntimeVerifierEvents.RunTimeExceeded.getObjectId());
            iDataSource.set(AddRule.kOid, (Object)ruleObject);
            ruleObject = new RuleObject(ShutdownEvents.ShutdownCanceled.getObjectId(), ShutdownEvents.ShutdownStarting.getObjectId());
            iDataSource.set(AddRule.kOid, (Object)ruleObject);
        }
        catch (Exception exception) {
            logger.error("[enableLogginForAllEvents] " + exception.toString(), (Throwable)exception);
        }
    }
}

