/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.omaha;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.IAllowedValues;
import com.apcc.m11.arch.datasource.IAvailability;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.omaha.IDataObject;
import com.apcc.m11.components.omaha.IDataSourceContainer;
import com.apcc.m11.ds.events.flexevents.EnvironmentalEvents;
import com.apcc.m11.ds.services.messageBroadcastGroup.AddRule;
import com.apcc.m11.ds.services.messageBroadcastGroup.RuleObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResetEnvironmentToDefaults
implements IDataObject {
    private static final Logger logger = LogManager.getLogger(ResetEnvironmentToDefaults.class);
    private IDataSourceContainer theDataSourceContainer;

    ResetEnvironmentToDefaults(IDataSourceContainer iDataSourceContainer) {
        this.theDataSourceContainer = iDataSourceContainer;
    }

    @Override
    public Object getValue() throws CommunicationException {
        return null;
    }

    @Override
    public void setValue(Object object, SetResult setResult) throws InvalidValueException, CommunicationException {
        this.setNotifierEnvironmentalDefaults();
        setResult.setSuccessful(true);
    }

    @Override
    public IAvailability getAvailability() {
        return Availability.AVAILABLE;
    }

    @Override
    public IAllowedValues getAllowedValues() {
        return null;
    }

    @Override
    public IFormatter getFormatter() {
        return null;
    }

    private void setNotifierEnvironmentalDefaults() {
        IDataSource iDataSource = this.theDataSourceContainer.getDataSource();
        try {
            RuleObject ruleObject = new RuleObject(EnvironmentalEvents.ContactNormal1.getObjectId(), EnvironmentalEvents.ContactFault1.getObjectId());
            iDataSource.set(AddRule.kOid, (Object)ruleObject);
            ruleObject = new RuleObject(EnvironmentalEvents.ContactNormal2.getObjectId(), EnvironmentalEvents.ContactFault2.getObjectId());
            iDataSource.set(AddRule.kOid, (Object)ruleObject);
            ruleObject = new RuleObject(EnvironmentalEvents.ContactNormal3.getObjectId(), EnvironmentalEvents.ContactFault3.getObjectId());
            iDataSource.set(AddRule.kOid, (Object)ruleObject);
            ruleObject = new RuleObject(EnvironmentalEvents.ContactNormal4.getObjectId(), EnvironmentalEvents.ContactFault4.getObjectId());
            iDataSource.set(AddRule.kOid, (Object)ruleObject);
            ruleObject = new RuleObject(EnvironmentalEvents.TempInRangeProbe1.getObjectId(), EnvironmentalEvents.TempOutOfRangeProbe1.getObjectId());
            iDataSource.set(AddRule.kOid, (Object)ruleObject);
            ruleObject = new RuleObject(EnvironmentalEvents.TempInRangeProbe2.getObjectId(), EnvironmentalEvents.TempOutOfRangeProbe2.getObjectId());
            iDataSource.set(AddRule.kOid, (Object)ruleObject);
            ruleObject = new RuleObject(EnvironmentalEvents.HumidityInRangeProbe1.getObjectId(), EnvironmentalEvents.HumidityOutOfRangeProbe1.getObjectId());
            iDataSource.set(AddRule.kOid, (Object)ruleObject);
            ruleObject = new RuleObject(EnvironmentalEvents.HumidityInRangeProbe2.getObjectId(), EnvironmentalEvents.HumidityOutOfRangeProbe2.getObjectId());
            iDataSource.set(AddRule.kOid, (Object)ruleObject);
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
    }
}

