/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.powersourceproxy;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.RegistrationException;
import com.apcc.m11.arch.component.ComponentFailureException;
import com.apcc.m11.arch.component.ComponentID;
import com.apcc.m11.arch.component.IComponent;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataBus;
import com.apcc.m11.arch.datasource.IDataConsumer;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.arch.event.IEventConsumer;
import com.apcc.m11.arch.event.IEventProducer;
import com.apcc.m11.arch.m11component.IM11Component;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.components.psaggregator.DataAggregatorRuleManagerAdvancedProxySide;
import com.apcc.m11.components.psaggregator.DataBusAggregator;
import com.apcc.m11.components.psaggregator.PSAggregator;
import com.apcc.m11.components.psaggregator.PSAggregatorForAdvanced;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.ds.arch.interfaces.Component;
import com.apcc.m11.ds.arch.interfaces.DataConsumer;
import com.apcc.m11.ds.arch.interfaces.DataSource;
import com.apcc.m11.ds.arch.interfaces.EventConsumer;
import com.apcc.m11.ds.arch.interfaces.EventProducer;
import com.apcc.m11.ds.arch.interfaces.M11Component;
import com.apcc.m11.ds.powersource.Configuration;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunicationMethod;
import com.apcc.m11.ds.powersourcenetworkconfig.NetworkConfig;
import com.apcc.m11.ds.powersourceproxy.Proxy;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.ConfigurationKeys;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.configservice.validation.StringSetValidator;
import com.apcc.pcns.util.HostNameLookUpTable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PowerSourceProxy
implements IM11Component,
IComponent,
IDataConsumer,
IDataSource,
IEventConsumer,
IEventProducer {
    private static final Logger logger = LogManager.getLogger(PowerSourceProxy.class);
    private static final String COMPONENT_NAME = "PowerSourceProxy";
    private static final String COMPONENT_VERSION = "1.0";
    private IPermanentStorage storage;
    private int currentState = 0;
    private int currentNetworkConfig = 1;
    private int currentIPv6NetworkConfig = 1;
    private boolean networkConfigChanged = false;
    private IDataSource dataSource;
    private IDataBus dataBus;
    private List<IEventProducer> eventProducers;
    private List<IEventConsumer> eventConsumers = new ArrayList<IEventConsumer>();
    private List<IM11Component> powerSources;
    private DataBusAggregator theAdvancedGroupDataBusAggregator;
    private boolean enrolWithNMC;
    private ServiceManager services;

    public PowerSourceProxy() {
        this.eventProducers = new ArrayList<IEventProducer>();
        this.powerSources = new ArrayList<IM11Component>();
    }

    public ComponentID getComponentID() {
        return new ComponentID(COMPONENT_NAME);
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }

    public String getComponentVersion() {
        return COMPONENT_VERSION;
    }

    public Object getInterface(ObjectId objectId) throws InvalidObjectIdException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        PowerSourceProxy powerSourceProxy = null;
        if (objectId.equals((Object)M11Component.kOid)) {
            powerSourceProxy = this;
        } else if (objectId.equals((Object)Component.kOid)) {
            powerSourceProxy = this;
        } else if (objectId.equals((Object)DataConsumer.kOid)) {
            powerSourceProxy = this;
        } else if (objectId.equals((Object)EventProducer.kOid)) {
            powerSourceProxy = this;
        } else if (objectId.equals((Object)DataSource.kOid)) {
            powerSourceProxy = this;
        } else if (objectId.equals((Object)EventConsumer.kOid)) {
            powerSourceProxy = this;
        } else {
            throw new InvalidObjectIdException("Interface Not Supported");
        }
        return powerSourceProxy;
    }

    public void init(IPermanentStorage iPermanentStorage) throws ComponentFailureException {
        if (iPermanentStorage == null) {
            throw new ComponentFailureException("IPermanentStorage cannot be null.");
        }
        this.storage = iPermanentStorage;
        this.services = ServiceManager.getInstance();
    }

    public void start() throws ComponentFailureException {
        this.loadConfiguration();
    }

    public void stop() {
        this.processStateChange(0);
    }

    public Object getInstanceOf(ObjectId objectId) throws InvalidObjectIdException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        PowerSourceProxy powerSourceProxy = null;
        if (objectId.equals((Object)M11Component.kOid)) {
            powerSourceProxy = this;
        } else if (objectId.equals((Object)Component.kOid)) {
            powerSourceProxy = this;
        } else {
            logger.warn("Invalid Instance " + objectId.toString());
            throw new InvalidObjectIdException();
        }
        return powerSourceProxy;
    }

    public void setDataSource(IDataSource iDataSource) {
        this.dataSource = iDataSource;
        if (iDataSource instanceof IDataBus) {
            this.dataBus = (IDataBus)iDataSource;
        }
    }

    public GetResult get(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        GetResult getResult = new GetResult();
        if (objectId.equals((Object)Proxy.ChangeMode.getObjectId())) {
            getResult.setValue((Object)this.currentState);
        } else if (objectId.equals((Object)NetworkConfig.ChangeMode.getObjectId())) {
            getResult.setValue((Object)this.currentNetworkConfig);
        } else if (objectId.equals((Object)TCPIPCommunicationMethod.ChangeMode.getObjectId())) {
            getResult.setValue((Object)this.currentIPv6NetworkConfig);
        } else {
            throw new InvalidObjectIdException("We don't support any gettable datapoints.");
        }
        return getResult;
    }

    public GetResult get(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        throw new InvalidObjectIdException("We don't support any gettable datapoints.");
    }

    public GetResult get(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        throw new InvalidObjectIdException("We don't support any gettable datapoints.");
    }

    public Enumeration<ObjectId> getSupportedOids() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(Proxy.ChangeMode.getObjectId());
        vector.add(NetworkConfig.ChangeMode.getObjectId());
        vector.add(TCPIPCommunicationMethod.ChangeMode.getObjectId());
        vector.add(Configuration.Update.getObjectId());
        return vector.elements();
    }

    public SetResult set(ObjectId objectId, Object object) throws InvalidValueException, InvalidObjectIdException, CommunicationException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        SetResult setResult = null;
        if (objectId.equals((Object)TCPIPCommunicationMethod.ChangeMode.getObjectId())) {
            if (!(object instanceof Integer)) {
                throw new InvalidValueException("Value must be an int");
            }
            Integer n = (Integer)object;
            switch (n) {
                case 1: {
                    this.services.getConfigurationManager().setProperty("Networking", "IPv6NetworkConfig", "unicast");
                    break;
                }
                case 2: {
                    this.services.getConfigurationManager().setProperty("Networking", "IPv6NetworkConfig", "multicast");
                    break;
                }
                default: {
                    throw new InvalidValueException("Invalid IPv6NetworkConfig value");
                }
            }
            this.processIPv6NetworkConfigChange(n);
            setResult = new SetResult();
            setResult.setSuccessful(true);
        } else if (objectId.equals((Object)NetworkConfig.ChangeMode.getObjectId())) {
            if (!(object instanceof Integer)) {
                throw new InvalidValueException("Value must be an int");
            }
            Integer n = (Integer)object;
            switch (n) {
                case 1: {
                    this.services.getConfigurationManager().setProperty("Networking", "NetworkConfig", "IPV4");
                    break;
                }
                case 2: {
                    this.services.getConfigurationManager().setProperty("Networking", "NetworkConfig", "IPV6");
                    break;
                }
                default: {
                    throw new InvalidValueException("Value is out of bounds");
                }
            }
            this.processNetworkConfigChange(n);
            setResult = new SetResult();
            setResult.setSuccessful(true);
        } else if (objectId.equals((Object)Proxy.ChangeMode.getObjectId())) {
            if (!(object instanceof Integer)) {
                throw new InvalidValueException("Value must be an int");
            }
            Integer n = (Integer)object;
            Integer n2 = 0;
            switch (n) {
                case 1: {
                    n2 = 1;
                    ConfigurationManager configurationManager = this.services.getConfigurationManager();
                    configurationManager.setProperty("NetworkManagementCard", "mode", "single");
                    break;
                }
                case 2: {
                    n2 = 2;
                    this.services.getConfigurationManager().setProperty("NetworkManagementCard", "mode", "redundant");
                    break;
                }
                case 3: {
                    n2 = 3;
                    this.services.getConfigurationManager().setProperty("NetworkManagementCard", "mode", "parallel");
                    break;
                }
                case 5: {
                    n2 = 5;
                    this.services.getConfigurationManager().setProperty("NetworkManagementCard", "mode", "advanced");
                    break;
                }
                default: {
                    throw new InvalidValueException("Value is out of bounds");
                }
            }
            this.processStateChange(n2, false);
            setResult = new SetResult();
            setResult.setSuccessful(true);
        } else if (objectId.equals((Object)Configuration.Update.getObjectId())) {
            if (!(object instanceof Integer)) {
                throw new InvalidValueException("Value must be an int");
            }
            Integer n = (Integer)object;
            if (this.powerSources != null && this.powerSources.size() > n && this.powerSources.get(n) != null) {
                ((PSAggregatorForAdvanced)this.powerSources.get(n)).configUpdate();
            }
            setResult = new SetResult();
            setResult.setSuccessful(true);
        } else {
            throw new InvalidObjectIdException("Unsupported ObjectId.");
        }
        return setResult;
    }

    public Enumeration<ObjectId> getConsumedEvents() {
        return new Vector().elements();
    }

    public void registerEventProducer(IEventProducer iEventProducer) throws RegistrationException {
        if (iEventProducer == null) {
            throw new RegistrationException("IEventProducer cannot be null");
        }
        this.eventProducers.add(iEventProducer);
    }

    public void unRegisterEventProducer(IEventProducer iEventProducer) throws RegistrationException {
        if (iEventProducer == null) {
            throw new RegistrationException("IEventProducer cannot be null");
        }
        this.eventProducers.remove(iEventProducer);
    }

    public void update(Event event) {
    }

    public void registerEventConsumer(IEventConsumer iEventConsumer) throws RegistrationException {
        if (iEventConsumer == null) {
            throw new RegistrationException("IEventConsumer cannot be null");
        }
        this.eventConsumers.add(iEventConsumer);
    }

    public void unRegisterEventConsumer(IEventConsumer iEventConsumer) throws RegistrationException {
        if (iEventConsumer == null) {
            throw new RegistrationException("IEventConsumer cannot be null");
        }
        this.eventConsumers.remove(iEventConsumer);
    }

    private void loadConfiguration() {
        String string;
        StringSetValidator stringSetValidator = new StringSetValidator("single");
        stringSetValidator.add("single");
        stringSetValidator.add("redundant");
        stringSetValidator.add("parallel");
        stringSetValidator.add("advanced");
        try {
            string = this.services.getConfigurationManager().getString("NetworkManagementCard", "mode", stringSetValidator);
        }
        catch (IllegalArgumentException | ConversionException throwable) {
            logger.error((Object)throwable);
            string = "single";
        }
        logger.debug("Reading state from INI: " + string);
        this.enrolWithNMC = this.services.getConfigurationManager().getBoolean("NetworkManagementCard", "enrolWithNMC", true);
        if (string.equalsIgnoreCase("single")) {
            this.processStateChange(1);
        } else if (string.equalsIgnoreCase("redundant")) {
            this.processStateChange(2);
        } else if (string.equalsIgnoreCase("parallel")) {
            this.processStateChange(3);
        } else if (string.equalsIgnoreCase("advanced")) {
            this.processStateChange(5);
        } else {
            logger.error("Unrecognised state string in INI: " + string);
            this.processStateChange(0);
        }
    }

    private void processNetworkConfigChange(Integer n) {
        if (this.currentNetworkConfig != n) {
            this.currentNetworkConfig = n;
            this.networkConfigChanged = true;
        }
    }

    private void processIPv6NetworkConfigChange(Integer n) {
        if (this.currentIPv6NetworkConfig != n) {
            this.currentIPv6NetworkConfig = n;
            if (this.currentNetworkConfig == 2) {
                this.networkConfigChanged = true;
            }
        }
    }

    private void processStateChange(Integer n) {
        this.processStateChange(n, this.enrolWithNMC);
    }

    private void processStateChange(Integer n, boolean bl) {
        logger.debug("Processing state change from " + this.currentState + " to " + n);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(1);
        arrayList.add(2);
        arrayList.add(3);
        arrayList.add(5);
        if (arrayList.contains(n)) {
            if (n == 5 || this.currentState != n || this.networkConfigChanged) {
                this.stopPowerSource();
                HostNameLookUpTable.getInstance().cleanLookUpTable();
                this.startPowerSource(n, bl);
                this.currentState = n;
                this.currentNetworkConfig = this.readNetworkConfig();
                this.currentIPv6NetworkConfig = this.readIPv6NetworkConfig();
                this.networkConfigChanged = false;
            }
        } else {
            this.stopPowerSource();
            this.currentState = 0;
        }
    }

    private int readNetworkConfig() {
        int n = 1;
        String string = this.services.getConfigurationManager().getString("Networking", "NetworkConfig", "IPV4");
        if (string.equalsIgnoreCase("IPV4")) {
            n = 1;
        } else if (string.equalsIgnoreCase("IPV6")) {
            n = 2;
        }
        return n;
    }

    private int readIPv6NetworkConfig() {
        int n = 1;
        String string = this.services.getConfigurationManager().getString("Networking", "IPv6NetworkConfig", "unicast");
        if (string.equalsIgnoreCase("unicast")) {
            n = 1;
        } else if (string.equalsIgnoreCase("multicast")) {
            n = 2;
        }
        return n;
    }

    private void startPowerSource(Integer n, boolean bl) {
        logger.debug("Starting powersource for " + n);
        if (1 == n) {
            var3_3 = new PowerSourceComponent();
            this.powerSources.add((IM11Component)var3_3);
        } else if (5 == n) {
            this.cleanShutdownSettings();
            this.populateAdvancedSetups();
        } else {
            var3_3 = new PSAggregator();
            this.powerSources.add((IM11Component)var3_3);
        }
        try {
            if (5 == n) {
                this.theAdvancedGroupDataBusAggregator = new DataBusAggregator(new DataAggregatorRuleManagerAdvancedProxySide(null, this.services));
                if (this.dataSource instanceof IDataBus) {
                    try {
                        ((IDataBus)this.dataSource).registerDataSource(this.theAdvancedGroupDataBusAggregator.getM11SideDataSource());
                    }
                    catch (RegistrationException registrationException) {
                        logger.error("Unable to wire up DataBusAggregator", (Throwable)registrationException);
                    }
                }
                this.dataBus = this.theAdvancedGroupDataBusAggregator.getPSSideDataBus();
            } else if (this.theAdvancedGroupDataBusAggregator != null) {
                if (this.dataSource instanceof IDataBus) {
                    try {
                        ((IDataBus)this.dataSource).unRegisterDataSource(this.theAdvancedGroupDataBusAggregator.getM11SideDataSource());
                    }
                    catch (RegistrationException registrationException) {
                        logger.warn("Unable to wire up DataBusAggregator", (Throwable)registrationException);
                    }
                }
                this.dataBus = (IDataBus)this.dataSource;
                this.theAdvancedGroupDataBusAggregator = null;
            }
            for (int i = 0; i < this.powerSources.size(); ++i) {
                this.powerSources.get(i).init(this.storage);
                this.wireEventProducers(this.powerSources.get(i), i);
                this.wireEventConsumers(this.powerSources.get(i), i);
                this.wireDataSources(this.powerSources.get(i), i);
                this.wireDataConsumers(this.powerSources.get(i), i);
                if (1 == n) {
                    ((PowerSourceComponent)this.powerSources.get(i)).start(bl);
                    continue;
                }
                if (5 == n) {
                    ((PSAggregatorForAdvanced)this.powerSources.get(i)).start(bl);
                    continue;
                }
                ((PSAggregator)this.powerSources.get(i)).start(bl);
            }
        }
        catch (ComponentFailureException componentFailureException) {
            logger.error("startPowerSource: " + String.valueOf((Object)componentFailureException));
        }
    }

    private void stopPowerSource() {
        if (this.currentState != 0) {
            for (int i = 0; i < this.powerSources.size(); ++i) {
                logger.debug("Stopping power source.");
                this.powerSources.get(i).stop();
                this.unwireDataConsumers(this.powerSources.get(i), i);
                this.unwireDataSources(this.powerSources.get(i), i);
                this.unwireEventConsumers(this.powerSources.get(i), i);
                this.unwireEventProducers(this.powerSources.get(i), i);
            }
            this.currentState = 0;
            this.powerSources.clear();
        }
    }

    private void unwireDataConsumers(IM11Component iM11Component, int n) {
        if (this.currentState == 5) {
            logger.debug("UnWiring data consumer for advanced setup: " + Integer.toString(n));
        } else {
            logger.debug("UnWiring data consumer");
        }
        try {
            IDataConsumer iDataConsumer = (IDataConsumer)iM11Component.getInterface(DataConsumer.kOid);
            if (iDataConsumer != null) {
                iDataConsumer.setDataSource(null);
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.debug((Object)invalidObjectIdException);
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
    }

    private void unwireDataSources(IM11Component iM11Component, int n) {
        if (this.currentState == 5) {
            logger.debug("unwireDataSources() - start, powerSource: " + Integer.toString(n));
        } else {
            logger.debug("unwireDataSources() - start");
        }
        try {
            IDataSource iDataSource = (IDataSource)iM11Component.getInterface(DataSource.kOid);
            if (iDataSource != null && this.dataBus != null) {
                this.dataBus.unRegisterDataSource(iDataSource);
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.debug((Object)invalidObjectIdException);
        }
        catch (RegistrationException registrationException) {
            logger.error((Object)registrationException);
        }
        logger.debug("unwireDataSources() - end");
    }

    private void unwireEventConsumers(IM11Component iM11Component, int n) {
        if (this.currentState == 5) {
            logger.debug("UnWiring event consumer for powerSource: " + Integer.toString(n));
        } else {
            logger.debug("UnWiring event consumer");
        }
        try {
            IEventConsumer iEventConsumer = (IEventConsumer)iM11Component.getInterface(EventConsumer.kOid);
            if (iEventConsumer != null) {
                for (IEventProducer iEventProducer : this.eventProducers) {
                    iEventConsumer.unRegisterEventProducer(iEventProducer);
                    iEventProducer.unRegisterEventConsumer(iEventConsumer);
                }
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
        }
        catch (RegistrationException registrationException) {
            logger.error((Object)registrationException);
        }
    }

    private void unwireEventProducers(IM11Component iM11Component, int n) {
        if (this.currentState == 5) {
            logger.debug("UnWiring event producer for powerSource: " + Integer.toString(n));
        } else {
            logger.debug("UnWiring event producer");
        }
        try {
            IEventProducer iEventProducer = (IEventProducer)iM11Component.getInterface(EventProducer.kOid);
            if (iEventProducer != null) {
                for (IEventConsumer iEventConsumer : this.eventConsumers) {
                    iEventProducer.unRegisterEventConsumer(iEventConsumer);
                }
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (RegistrationException registrationException) {
            logger.error((Object)registrationException);
        }
    }

    private void wireDataConsumers(IM11Component iM11Component, int n) {
        if (this.currentState == 5) {
            logger.debug("Wiring data consumer for powerSource: " + Integer.toString(n));
        } else {
            logger.debug("Wiring data consumer");
        }
        try {
            IDataConsumer iDataConsumer = (IDataConsumer)iM11Component.getInterface(DataConsumer.kOid);
            if (iDataConsumer != null) {
                iDataConsumer.setDataSource(this.dataSource);
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            // empty catch block
        }
    }

    private void wireDataSources(IM11Component iM11Component, int n) {
        if (this.currentState == 5) {
            logger.debug("Wiring data sources for powerSource: " + Integer.toString(n));
        } else {
            logger.debug("Wiring data sources");
        }
        try {
            IDataSource iDataSource = (IDataSource)iM11Component.getInterface(DataSource.kOid);
            if (iDataSource != null && this.dataBus != null) {
                this.dataBus.registerDataSource(iDataSource);
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.debug((Object)invalidObjectIdException);
        }
        catch (RegistrationException registrationException) {
            logger.error((Object)registrationException);
        }
    }

    private void wireEventConsumers(IM11Component iM11Component, int n) {
        if (this.currentState == 5) {
            logger.debug("Wiring event consumers for powerSource: " + Integer.toString(n));
        } else {
            logger.debug("Wiring event consumers");
        }
        try {
            IEventConsumer iEventConsumer = (IEventConsumer)iM11Component.getInterface(EventConsumer.kOid);
            if (iEventConsumer != null) {
                for (IEventProducer iEventProducer : this.eventProducers) {
                    iEventConsumer.registerEventProducer(iEventProducer);
                    iEventProducer.registerEventConsumer(iEventConsumer);
                }
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
        }
        catch (RegistrationException registrationException) {
            logger.error((Object)registrationException);
        }
    }

    private void wireEventProducers(IM11Component iM11Component, int n) {
        if (this.currentState == 5) {
            logger.debug("Wiring event producers for powerSource: " + Integer.toString(n));
        } else {
            logger.debug("Wiring event producers");
        }
        try {
            IEventProducer iEventProducer = (IEventProducer)iM11Component.getInterface(EventProducer.kOid);
            if (iEventProducer != null) {
                for (IEventConsumer iEventConsumer : this.eventConsumers) {
                    iEventProducer.registerEventConsumer(iEventConsumer);
                }
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (RegistrationException registrationException) {
            logger.error((Object)registrationException);
        }
    }

    private void populateAdvancedSetups() {
        PSAggregatorForAdvanced pSAggregatorForAdvanced;
        int n = 0;
        boolean bl = false;
        String string = null;
        ConfigurationManager configurationManager = this.services.getConfigurationManager();
        do {
            if (configurationManager.containsSection(string = ConfigurationKeys.getAdvancedSetupKey(n))) {
                pSAggregatorForAdvanced = new PSAggregatorForAdvanced(n);
                this.powerSources.add(pSAggregatorForAdvanced);
            } else {
                bl = true;
            }
            ++n;
        } while (!bl);
        if (this.powerSources.size() <= 0) {
            pSAggregatorForAdvanced = new PSAggregatorForAdvanced(0);
            this.powerSources.add(pSAggregatorForAdvanced);
        }
    }

    private void cleanShutdownSettings() {
        ConfigurationManager configurationManager = this.services.getConfigurationManager();
        configurationManager.setProperty("Shutdown", "shutdownCommandFileEnabled", Boolean.FALSE);
        configurationManager.setProperty("Shutdown", "turnOffSOG", Boolean.FALSE);
        configurationManager.setProperty("Shutdown", "turnOffUps", Boolean.FALSE);
        configurationManager.setProperty("AdvancedConfig", "SinglePowerFailed_turnOffUps", Boolean.FALSE);
    }
}

