/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator;

import com.apcc.m11.arch.ObjectId;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AggregatorState {
    private static final Logger logger = LogManager.getLogger(AggregatorState.class);
    private Map<Integer, Boolean> thePowerSourceReported;
    private Map<Integer, Boolean> theMonitoringStarted;
    private Map<Integer, Boolean> theAvailableToPowerLoad;
    private Map<Integer, Boolean> theCommEstablished;
    private Map<Integer, Boolean> theNetCommEstablished;
    private Map<Integer, Boolean> theOnBattery;
    private Map<Integer, Boolean> theLowBattery;
    private Map<Integer, Boolean> theDischarged;
    private Map<Integer, Boolean> theOverload;
    private Map<Integer, Boolean> theInternalTempOK;
    private Map<Integer, Boolean> theOnBypass;
    private Map<Integer, Boolean> theOnManualBypass;
    private Map<Integer, Integer> theOnBypassReason;
    private Map<Integer, Boolean> thePowerSourceOff;
    private Map<Integer, Boolean> theMinRedundancyLost;
    private Map<Integer, Boolean> theParallelRedundancyLost;
    private Map<Integer, Boolean> theHotStandby;
    private Map<Integer, Boolean> theBypassSwitchFailed;
    private Map<Integer, Boolean> theMinLoadCapabilityLost;
    private Map<Integer, Boolean> theUpsTurnOffInitiated;
    private Map<Integer, Boolean> theOutletTurnOffInitiated;
    private Boolean theOffInitiatedbyPCNS;
    private Map<Integer, Boolean> theOutletOff;
    private Map<Integer, Boolean> thePowerOff;
    private Map<Integer, Integer> theLoad;
    private int theUnitsRequiredForLoad;
    public static final int kByPassReasonNone = 0;
    public static final int kByPassReasonFault = 1;
    public static final int kOverloadNoReport = 0;
    public static final int kNotOverloaded = 1;
    public static final int kOverloaded = 2;
    private int theLastReportedOverloadState;
    private int theSystemRedundancyState;
    public static final int kNothing = 0;
    public static final int kCommEstablished = 1;
    public static final int kCommLost = 2;
    public static final int kNetCommLost = 3;
    public static final int kCommLostWhileOnBattery = 4;
    private int theLastReportedCommState;
    public static final int kLineNoReport = 0;
    public static final int kOnline = 1;
    public static final int kOnBattery = 2;
    public static final int kLostCommsOnBattery = 3;
    private int theLastReportedBatteryState;
    public static final int kDischargeNoReport = 0;
    public static final int kNotDischarged = 1;
    public static final int kDischarged = 2;
    private int theLastReportedDischargeState;
    public static final int kLowBatteryNotReported = 0;
    public static final int kLowBatteryReported = 1;
    public static final int kLowBatteryResolved = 2;
    private int theLastReportedLowBatteryState;
    public static final int kBypassSwitchNoReport = 0;
    public static final int kBypassSwitchFailed = 1;
    public static final int kBypassSwitchReplaced = 2;
    private int theLastReportedBypassSwitchState;
    private boolean theMonitoringStartedReportedState;
    public static final int kBypassNoReport = 0;
    public static final int kBypassEnabled = 1;
    public static final int kBypassDisabled = 2;
    public static final int kBypassManualNoReport = 0;
    public static final int kBypassManualEnabled = 1;
    public static final int kBypassManualDisabled = 2;
    private int theLastReportedBypassState;
    private int theLastReportedManualBypassState;
    public static final int kTempNoReport = 0;
    public static final int kTempOK = 1;
    public static final int kTempNotOK = 2;
    public static final int kMinLoadCapabilityNoReport = 0;
    public static final int kMinLoadCapabilityLost = 1;
    public static final int kMinLoadCapabilityRestored = 2;
    private int theLastReportedMinLoadCapabilityState;
    public static final int kMinRedundancyNoReport = 0;
    public static final int kMinRedundancyLost = 1;
    public static final int kMinRedundancyRestored = 2;
    public static final int kParallelRedundancyNoReport = 0;
    public static final int kParallelRedundancyLost = 1;
    public static final int kParallelRedundancyRestored = 2;
    private int theLastReportedMinRedundancyState;
    private int theLastReportedParallelRedundancyState;
    private int theLastReportedInternalTempState;
    public static final int kMultipleCriticalEventNoReport = 0;
    public static final int kMultipleCriticalEventOccurred = 1;
    public static final int kMultipleCriticalEventResolved = 2;
    private int theLastReportedMultipleCriticalEventState;
    public static final int kCriticalEventNoReport = 0;
    public static final int kCriticalEventOccurred = 1;
    public static final int kCriticalEventResolved = 2;
    private int theLastReportedCriticalEventState;
    public static final int kUpsTurnOffNoReport = 0;
    public static final int kUpsTurnOffInitiated = 1;
    private int theLastReportedUpsTurnOffState;
    public static final int kSinglePowerNoReport = 0;
    public static final int kSinglePowerRestored = 1;
    public static final int kSinglePowerFailed = 2;
    private int theLastReportedSinglePowerState;
    public static final int kPowerOffNoReport = 0;
    public static final int kPowerOffRestored = 1;
    public static final int kPowerOff = 2;
    private int theLastReportedPowerOffState;
    public static final int kOutletTurnOffNoReport = 0;
    public static final int kOutletTurnOffInitiated = 1;
    private int theLastReportedOutletTurnOffState;
    private int theTotalRedundantUps;
    private int aggregatorIdx;
    private boolean shutdownOnLostRedundancy;
    private String advancedGroupName;
    private Map<ObjectId, Boolean> theEventsStatus;
    private String theMonitoringStartedText = null;

    public AggregatorState() {
        logger.debug("constructor()");
        this.initializeState();
    }

    public void initializeState() {
        logger.debug("initializeState()");
        this.theEventsStatus = new HashMap<ObjectId, Boolean>();
        this.thePowerSourceReported = new HashMap<Integer, Boolean>();
        this.theMonitoringStarted = new HashMap<Integer, Boolean>();
        this.theAvailableToPowerLoad = new HashMap<Integer, Boolean>();
        this.theCommEstablished = new HashMap<Integer, Boolean>();
        this.theNetCommEstablished = new HashMap<Integer, Boolean>();
        this.theOnBattery = new HashMap<Integer, Boolean>();
        this.theLowBattery = new HashMap<Integer, Boolean>();
        this.theOverload = new HashMap<Integer, Boolean>();
        this.thePowerSourceOff = new HashMap<Integer, Boolean>();
        this.theMinRedundancyLost = new HashMap<Integer, Boolean>();
        this.theParallelRedundancyLost = new HashMap<Integer, Boolean>();
        this.theHotStandby = new HashMap<Integer, Boolean>();
        this.theInternalTempOK = new HashMap<Integer, Boolean>();
        this.theBypassSwitchFailed = new HashMap<Integer, Boolean>();
        this.theMinLoadCapabilityLost = new HashMap<Integer, Boolean>();
        this.theOnBypass = new HashMap<Integer, Boolean>();
        this.theOnManualBypass = new HashMap<Integer, Boolean>();
        this.theOnBypassReason = new HashMap<Integer, Integer>();
        this.theDischarged = new HashMap<Integer, Boolean>();
        this.theUpsTurnOffInitiated = new HashMap<Integer, Boolean>();
        this.theOutletTurnOffInitiated = new HashMap<Integer, Boolean>();
        this.theOffInitiatedbyPCNS = false;
        this.theOutletOff = new HashMap<Integer, Boolean>();
        this.thePowerOff = new HashMap<Integer, Boolean>();
        this.theLoad = new HashMap<Integer, Integer>();
        this.theLastReportedBatteryState = 0;
        this.theLastReportedBypassState = 0;
        this.theLastReportedManualBypassState = 0;
        this.theLastReportedBypassSwitchState = 0;
        this.theLastReportedCommState = 0;
        this.theLastReportedDischargeState = 0;
        this.theLastReportedInternalTempState = 0;
        this.theLastReportedLowBatteryState = 0;
        this.theLastReportedMinLoadCapabilityState = 0;
        this.theLastReportedMinRedundancyState = 0;
        this.theLastReportedParallelRedundancyState = 0;
        this.theLastReportedMultipleCriticalEventState = 0;
        this.theLastReportedCriticalEventState = 0;
        this.theLastReportedOverloadState = 0;
        this.theLastReportedPowerOffState = 0;
        this.theLastReportedSinglePowerState = 0;
        this.theLastReportedUpsTurnOffState = 0;
        this.theLastReportedOutletTurnOffState = 0;
        this.theMonitoringStartedReportedState = false;
        this.theSystemRedundancyState = 1;
        this.theUnitsRequiredForLoad = 0;
        this.theTotalRedundantUps = 0;
        this.aggregatorIdx = 0;
    }

    public synchronized void initialisePS(int n) {
        logger.debug("initialisePS:" + n);
        this.thePowerSourceReported.put(n, false);
        this.theMonitoringStarted.put(n, false);
        this.theAvailableToPowerLoad.put(n, false);
        this.theCommEstablished.put(n, false);
        this.theNetCommEstablished.put(n, true);
        this.theOnBattery.put(n, false);
        this.theLowBattery.put(n, false);
        this.theOverload.put(n, false);
        this.theInternalTempOK.put(n, true);
        this.theOnBypass.put(n, false);
        this.theOnManualBypass.put(n, false);
        this.theOnBypassReason.put(n, 0);
        this.theDischarged.put(n, false);
        this.theLoad.put(n, 0);
        this.thePowerSourceOff.put(n, false);
        this.theMinRedundancyLost.put(n, false);
        this.theParallelRedundancyLost.put(n, false);
        this.theHotStandby.put(n, false);
        this.theBypassSwitchFailed.put(n, false);
        this.theMinLoadCapabilityLost.put(n, false);
        this.theUpsTurnOffInitiated.put(n, false);
        this.theOutletTurnOffInitiated.put(n, false);
        this.theOutletOff.put(n, false);
        this.thePowerOff.put(n, false);
    }

    public synchronized void removePS(int n) {
        logger.debug("removePS:" + n);
        this.thePowerSourceReported.remove(n);
        this.theMonitoringStarted.remove(n);
        this.theAvailableToPowerLoad.remove(n);
        this.theCommEstablished.remove(n);
        this.theNetCommEstablished.remove(n);
        this.theOnBattery.remove(n);
        this.theLowBattery.remove(n);
        this.theOverload.remove(n);
        this.theInternalTempOK.remove(n);
        this.theOnBypass.remove(n);
        this.theOnManualBypass.remove(n);
        this.theOnBypassReason.remove(n);
        this.theDischarged.remove(n);
        this.theLoad.remove(n);
        this.thePowerSourceOff.remove(n);
        this.theMinRedundancyLost.remove(n);
        this.theParallelRedundancyLost.remove(n);
        this.theHotStandby.remove(n);
        this.theBypassSwitchFailed.remove(n);
        this.theMinLoadCapabilityLost.remove(n);
        this.theUpsTurnOffInitiated.remove(n);
        this.theOutletTurnOffInitiated.remove(n);
        this.theOutletOff.remove(n);
        this.thePowerOff.remove(n);
    }

    public boolean[] getPowerSourceReported() {
        return this.getBooleanArray(this.thePowerSourceReported);
    }

    public boolean[] getMonitoringStarted() {
        return this.getBooleanArray(this.theMonitoringStarted);
    }

    public boolean[] getAvailableToPowerLoad() {
        return this.getBooleanArray(this.theAvailableToPowerLoad);
    }

    public boolean[] getCommEstablished() {
        return this.getBooleanArray(this.theCommEstablished);
    }

    public Boolean isNetCommEstablished(int n) {
        return this.theNetCommEstablished.get(n);
    }

    public boolean[] getNetCommEstablished() {
        return this.getBooleanArray(this.theNetCommEstablished);
    }

    public boolean[] getOnBattery() {
        return this.getBooleanArray(this.theOnBattery);
    }

    public boolean[] getLowBattery() {
        return this.getBooleanArray(this.theLowBattery);
    }

    public boolean[] getDischarged() {
        return this.getBooleanArray(this.theDischarged);
    }

    public boolean[] getOverload() {
        return this.getBooleanArray(this.theOverload);
    }

    public boolean[] getInternalTempOK() {
        return this.getBooleanArray(this.theInternalTempOK);
    }

    public boolean[] getOnBypass() {
        return this.getBooleanArray(this.theOnBypass);
    }

    public boolean[] getOnManualBypass() {
        return this.getBooleanArray(this.theOnManualBypass);
    }

    public int[] getOnBypassReason() {
        return this.getIntegerArray(this.theOnBypassReason);
    }

    public boolean[] getPowerSourceOff() {
        return this.getBooleanArray(this.thePowerSourceOff);
    }

    public boolean[] getStatusOK() {
        boolean[] blArray = this.getNetCommEstablished();
        logger.info("netComs:" + AggregatorState.toString(blArray));
        blArray = AggregatorState.and(blArray, AggregatorState.not(this.getPowerSourceOff()));
        logger.info("PS off:" + AggregatorState.toString(blArray));
        blArray = AggregatorState.and(blArray, AggregatorState.not(this.getPowerOff()));
        logger.info("Power off:" + AggregatorState.toString(blArray));
        blArray = AggregatorState.and(blArray, this.getCommEstablished());
        logger.info("comms:" + AggregatorState.toString(blArray));
        return blArray;
    }

    public boolean[] getMinRedundancyLost() {
        return this.getBooleanArray(this.theMinRedundancyLost);
    }

    public boolean[] getParallelRedundancyLost() {
        return this.getBooleanArray(this.theParallelRedundancyLost);
    }

    public boolean[] getHotStandby() {
        return this.getBooleanArray(this.theHotStandby);
    }

    public boolean[] getBypassSwitchFailed() {
        return this.getBooleanArray(this.theBypassSwitchFailed);
    }

    public boolean[] getMinLoadCapabilityLost() {
        return this.getBooleanArray(this.theMinLoadCapabilityLost);
    }

    public boolean[] getUpsTurnOffInitiated() {
        return this.getBooleanArray(this.theUpsTurnOffInitiated);
    }

    public boolean[] getOutletTurnOffInitiated() {
        return this.getBooleanArray(this.theOutletTurnOffInitiated);
    }

    public boolean getOffInitiatedbyPCNS() {
        return this.theOffInitiatedbyPCNS;
    }

    public boolean[] getOutletOff() {
        return this.getBooleanArray(this.theOutletOff);
    }

    public boolean[] getPowerOff() {
        return this.getBooleanArray(this.thePowerOff);
    }

    public int getTotalLoad() {
        int n = 0;
        for (Integer n2 : this.theLoad.values()) {
            n += n2.intValue();
        }
        return n;
    }

    public int getUnitsRequiredForLoad() {
        return this.theUnitsRequiredForLoad;
    }

    public int getSystemRedundancyState() {
        return this.theSystemRedundancyState;
    }

    public int getLastReportedOverloadState() {
        return this.theLastReportedOverloadState;
    }

    public int getLastReportedCommState() {
        return this.theLastReportedCommState;
    }

    public int getLastReportedBatteryState() {
        return this.theLastReportedBatteryState;
    }

    public int getLastReportedLowBatteryState() {
        return this.theLastReportedLowBatteryState;
    }

    public int getLastReportedBypassState() {
        return this.theLastReportedBypassState;
    }

    public int getLastReportedManualBypassState() {
        return this.theLastReportedManualBypassState;
    }

    public int getLastReportedDischargeState() {
        return this.theLastReportedDischargeState;
    }

    public int getLastReportedInternalTempState() {
        return this.theLastReportedInternalTempState;
    }

    public int getLastReportedBypassSwitchState() {
        return this.theLastReportedBypassSwitchState;
    }

    public int getLastReportedMinLoadCapabilityState() {
        return this.theLastReportedMinLoadCapabilityState;
    }

    public int getLastReportedMinRedundancyState() {
        return this.theLastReportedMinRedundancyState;
    }

    public int getLastReportedParallelRedundancyState() {
        return this.theLastReportedParallelRedundancyState;
    }

    public int getLastReportedUpsTurnOffState() {
        return this.theLastReportedUpsTurnOffState;
    }

    public int getLastReportedOutletTurnOffState() {
        return this.theLastReportedOutletTurnOffState;
    }

    public int getLastReportedMultipleCriticalEventState() {
        return this.theLastReportedMultipleCriticalEventState;
    }

    public int getLastReportedCriticalEventState() {
        return this.theLastReportedCriticalEventState;
    }

    public int getLastReportedSinglePowerState() {
        return this.theLastReportedSinglePowerState;
    }

    public int getLastReportedPowerOffState() {
        return this.theLastReportedPowerOffState;
    }

    public boolean getMonitoringStartedReportedState() {
        return this.theMonitoringStartedReportedState;
    }

    public String getMonitoringStartedText() {
        return this.theMonitoringStartedText;
    }

    public int getTotalRedundantUps() {
        int n = 0;
        if (this.shutdownOnLostRedundancy) {
            if (this.theTotalRedundantUps > 0) {
                n = this.theTotalRedundantUps - 1;
            }
        } else {
            n = this.theTotalRedundantUps;
        }
        return n;
    }

    public boolean getShutdownOnLostRedundancy() {
        return this.shutdownOnLostRedundancy;
    }

    public void setShutdownOnLostRedundancy(boolean bl) {
        this.shutdownOnLostRedundancy = bl;
    }

    private void setValue(Map<Integer, Boolean> map, int n, boolean bl) {
        if (!map.containsKey(n)) {
            this.initialisePS(n);
        }
        map.put(n, bl);
    }

    private void setValue(Map<Integer, Integer> map, int n, int n2) {
        if (!map.containsKey(n)) {
            this.initialisePS(n);
        }
        map.put(n, n2);
    }

    public void setPowerSourceReported(int n, boolean bl) {
        this.setValue(this.thePowerSourceReported, n, bl);
    }

    public void setMonitoringStarted(int n, boolean bl) {
        this.setValue(this.theMonitoringStarted, n, bl);
    }

    public void setAvailableToPowerLoad(int n, boolean bl) {
        this.setValue(this.theAvailableToPowerLoad, n, bl);
    }

    public void setCommEstablished(int n, boolean bl) {
        this.setValue(this.theCommEstablished, n, bl);
    }

    public void setNetCommEstablished(int n, boolean bl) {
        this.setValue(this.theNetCommEstablished, n, bl);
    }

    public void setOnBattery(int n, boolean bl) {
        this.setValue(this.theOnBattery, n, bl);
    }

    public void setLowBattery(int n, boolean bl) {
        this.setValue(this.theLowBattery, n, bl);
    }

    public void setDischarged(int n, boolean bl) {
        this.setValue(this.theDischarged, n, bl);
    }

    public void setOverload(int n, boolean bl) {
        this.setValue(this.theOverload, n, bl);
    }

    public void setPowerSourceOff(int n, boolean bl) {
        this.setValue(this.thePowerSourceOff, n, bl);
    }

    public void setMinRedundancyLost(int n, boolean bl) {
        this.setValue(this.theMinRedundancyLost, n, bl);
    }

    public void setParallelRedundancyLost(int n, boolean bl) {
        this.setValue(this.theParallelRedundancyLost, n, bl);
    }

    public void setHotStandby(int n, boolean bl) {
        this.setValue(this.theHotStandby, n, bl);
    }

    public void setBypassSwitchFailed(int n, boolean bl) {
        this.setValue(this.theBypassSwitchFailed, n, bl);
    }

    public void setMinLoadCapabilityLost(int n, boolean bl) {
        this.setValue(this.theMinLoadCapabilityLost, n, bl);
    }

    public void setUpsTurnOffInitiated(int n, boolean bl) {
        this.setValue(this.theUpsTurnOffInitiated, n, bl);
    }

    public void setOutletTurnOffInitiated(int n, boolean bl) {
        this.setValue(this.theOutletTurnOffInitiated, n, bl);
    }

    public void setOutletOff(int n, boolean bl) {
        this.setValue(this.theOutletOff, n, bl);
    }

    public void setPowerOff(int n, boolean bl) {
        this.setValue(this.thePowerOff, n, bl);
    }

    public void setInternalTempOK(int n, boolean bl) {
        this.setValue(this.theInternalTempOK, n, bl);
    }

    public void setOnBypass(int n, boolean bl) {
        this.setValue(this.theOnBypass, n, bl);
    }

    public void setOnManualBypass(int n, boolean bl) {
        this.setValue(this.theOnManualBypass, n, bl);
    }

    public void setOnBypassReason(int n, int n2) {
        this.setValue(this.theOnBypassReason, n, n2);
    }

    public void setLoad(int n, int n2) {
        this.setValue(this.theLoad, n, n2);
    }

    public void setUnitsRequiredForLoad(int n) {
        this.theUnitsRequiredForLoad = n;
    }

    public void setSystemRedundacyState(int n) {
        this.theSystemRedundancyState = n;
    }

    public void setLastReportedOverloadState(int n) {
        this.theLastReportedOverloadState = n;
    }

    public void setLastReportedCommState(int n) {
        this.theLastReportedCommState = n;
    }

    public void setLastReportedBatteryState(int n) {
        this.theLastReportedBatteryState = n;
    }

    public void setLastReportedDischargeState(int n) {
        this.theLastReportedDischargeState = n;
    }

    public void setLastReportedLowBatteryState(int n) {
        this.theLastReportedLowBatteryState = n;
    }

    public void setLastReportedBypassState(int n) {
        this.theLastReportedBypassState = n;
    }

    public void setLastReportedManualBypassState(int n) {
        this.theLastReportedManualBypassState = n;
    }

    public void setLastReportedInternalTempState(int n) {
        this.theLastReportedInternalTempState = n;
    }

    public void setLastReportedMinRedundancyState(int n) {
        this.theLastReportedMinRedundancyState = n;
    }

    public void setLastReportedParallelRedundancyState(int n) {
        this.theLastReportedParallelRedundancyState = n;
    }

    public void setLastReportedUpsTurnOffState(int n) {
        this.theLastReportedUpsTurnOffState = n;
    }

    public void setLastReportedOutletTurnOffState(int n) {
        this.theLastReportedOutletTurnOffState = n;
    }

    public void setLastReportedBypassSwitchState(int n) {
        this.theLastReportedBypassSwitchState = n;
    }

    public void setLastReportedMinLoadCapabilityState(int n) {
        this.theLastReportedMinLoadCapabilityState = n;
    }

    public void setMonitoringStartedReportedState(boolean bl) {
        this.theMonitoringStartedReportedState = bl;
    }

    public void setLastReportedMultipleCriticalEventState(int n) {
        this.theLastReportedMultipleCriticalEventState = n;
    }

    public void setLastReportedCriticalEventState(int n) {
        this.theLastReportedCriticalEventState = n;
    }

    public void setLastReportedSinglePowerState(int n) {
        this.theLastReportedSinglePowerState = n;
    }

    public void setLastReportedPowerOffState(int n) {
        this.theLastReportedPowerOffState = n;
    }

    public void setMonitoringStartedText(String string) {
        this.theMonitoringStartedText = string;
    }

    public void setEventActive(ObjectId objectId, boolean bl) {
        this.theEventsStatus.put(objectId, bl);
    }

    public void setTotalRedundantUps(int n) {
        this.theTotalRedundantUps = n;
        if (this.theTotalRedundantUps < 0) {
            logger.error("Redundant UPS set to :" + n);
            this.theTotalRedundantUps = 0;
        }
    }

    public boolean isEventActive(ObjectId objectId) {
        boolean bl = false;
        Boolean bl2 = this.theEventsStatus.get(objectId);
        if (bl2 != null) {
            bl = bl2;
        }
        return bl;
    }

    private synchronized boolean[] getBooleanArray(Map<Integer, Boolean> map) {
        boolean[] blArray = new boolean[map.size()];
        for (int i = 0; i < map.size(); ++i) {
            Boolean bl = map.get(i);
            blArray[i] = bl != null ? bl : false;
        }
        return blArray;
    }

    private synchronized int[] getIntegerArray(Map<Integer, Integer> map) {
        int[] nArray = new int[map.size()];
        for (int i = 0; i < map.size(); ++i) {
            Integer n = map.get(i);
            nArray[i] = n != null ? n : 0;
        }
        return nArray;
    }

    public static boolean any(boolean[] blArray, boolean bl) {
        for (boolean bl2 : blArray) {
            if (bl2 != bl) continue;
            return true;
        }
        return false;
    }

    public static boolean all(boolean[] blArray, boolean bl) {
        for (boolean bl2 : blArray) {
            if (bl2 == bl) continue;
            return false;
        }
        return true;
    }

    public static boolean[] and(boolean[] blArray, boolean[] blArray2) {
        boolean[] blArray3 = new boolean[blArray.length];
        if (blArray.length == blArray2.length) {
            for (int i = 0; i < blArray.length; ++i) {
                blArray3[i] = blArray[i] && blArray2[i];
            }
        }
        return blArray3;
    }

    public static boolean[] or(boolean[] blArray, boolean[] blArray2) {
        boolean[] blArray3 = new boolean[blArray.length];
        if (blArray.length == blArray2.length) {
            for (int i = 0; i < blArray.length; ++i) {
                blArray3[i] = blArray[i] || blArray2[i];
            }
        }
        return blArray3;
    }

    public static boolean[] not(boolean[] blArray) {
        boolean[] blArray2 = new boolean[blArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray2[i] = !blArray[i];
        }
        return blArray2;
    }

    public static String toString(boolean[] blArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(blArray.length);
        stringBuilder.append("::");
        for (boolean bl : blArray) {
            stringBuilder.append(bl);
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public static int find_matches(boolean[] blArray, boolean bl) {
        int n = 0;
        for (boolean bl2 : blArray) {
            if (bl2 != bl) continue;
            ++n;
        }
        return n;
    }

    public static boolean not(boolean bl) {
        boolean bl2 = false;
        bl2 = !bl;
        return bl2;
    }

    public int getAggregatorIdx() {
        return this.aggregatorIdx;
    }

    public void setAggregatorIdx(int n) {
        this.aggregatorIdx = n;
    }

    public String getAdvancedGroupName() {
        return this.advancedGroupName;
    }

    public void setAdvancedGroupName(String string) {
        this.advancedGroupName = string;
    }

    public void setOffInitiatedbyPCNS(Boolean bl) {
        this.theOffInitiatedbyPCNS = bl;
    }

    public void checkOffInitiatedbyPCNS() {
        if (this.theOffInitiatedbyPCNS.booleanValue()) {
            boolean[] blArray = this.getUpsTurnOffInitiated();
            boolean[] blArray2 = this.getOutletTurnOffInitiated();
            if (AggregatorState.find_matches(blArray, true) == 0 && AggregatorState.find_matches(blArray2, true) == 0) {
                this.theOffInitiatedbyPCNS = false;
            }
        }
    }
}

