/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.IDataRule;
import com.apcc.m11.components.psaggregator.PSSide;
import com.apcc.m11.ds.powersource.Communication;
import com.apcc.pcns.ServiceManager;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DataAggregatorRuleManager {
    private static final Logger logger = LogManager.getLogger(DataAggregatorRuleManager.class);
    protected PSSide thePSSide = null;
    protected Vector<IDataRule> theDataRules = null;
    protected AggregatorState theAggregatorState = null;
    protected ServiceManager services;

    public DataAggregatorRuleManager(AggregatorState aggregatorState, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.theAggregatorState = aggregatorState;
        this.theDataRules = new Vector();
        this.initRules();
        for (IDataRule iDataRule : this.theDataRules) {
            iDataRule.setDataAggregatorRuleManager(this);
        }
    }

    protected abstract void initRules();

    public GetResult aggregateGet(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        for (IDataRule iDataRule : this.theDataRules) {
            Iterator<ObjectId> iterator = iDataRule.getOids();
            while (iterator.hasNext()) {
                ObjectId objectId2 = iterator.next();
                if (!objectId2.equals((Object)objectId) && !objectId2.isPrefixOf(objectId)) continue;
                return iDataRule.get(objectId);
            }
        }
        throw new InvalidObjectIdException();
    }

    public GetResult aggregateGet(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        for (IDataRule iDataRule : this.theDataRules) {
            Iterator<ObjectId> iterator = iDataRule.getOids();
            while (iterator.hasNext()) {
                ObjectId objectId2 = iterator.next();
                if (!objectId2.equals((Object)objectId) && !objectId2.isPrefixOf(objectId)) continue;
                return iDataRule.get(objectId, n);
            }
        }
        throw new InvalidObjectIdException();
    }

    public GetResult aggregateGet(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        for (IDataRule iDataRule : this.theDataRules) {
            Iterator<ObjectId> iterator = iDataRule.getOids();
            while (iterator.hasNext()) {
                ObjectId objectId2 = iterator.next();
                if (!objectId2.equals((Object)objectId) && !objectId2.isPrefixOf(objectId)) continue;
                return iDataRule.get(objectId, object);
            }
        }
        throw new InvalidObjectIdException();
    }

    public SetResult aggregateSet(ObjectId objectId, Object object) throws InvalidValueException, InvalidObjectIdException, CommunicationException {
        for (IDataRule iDataRule : this.theDataRules) {
            Iterator<ObjectId> iterator = iDataRule.getOids();
            while (iterator.hasNext()) {
                ObjectId objectId2 = iterator.next();
                if (!objectId2.equals((Object)objectId) && !objectId2.isPrefixOf(objectId)) continue;
                return iDataRule.set(objectId, object);
            }
        }
        throw new InvalidObjectIdException();
    }

    public Enumeration<ObjectId> aggregateGetSupportedOids() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        for (IDataRule iDataRule : this.theDataRules) {
            Iterator<ObjectId> iterator = iDataRule.getOids();
            while (iterator.hasNext()) {
                ObjectId objectId = iterator.next();
                if (vector.contains(objectId)) continue;
                vector.add(objectId);
            }
        }
        return vector.elements();
    }

    public void setPSSide(PSSide pSSide) {
        this.thePSSide = pSSide;
    }

    public IDataSource getFirstDataSource() {
        IDataSource iDataSource = null;
        if (this.thePSSide.getPSDataSources().size() > 0) {
            for (int i = 0; iDataSource == null && i < this.thePSSide.getPSDataSources().size(); ++i) {
                IDataSource iDataSource2 = this.thePSSide.getPSDataSources().get(i);
                try {
                    Integer n;
                    Object object;
                    GetResult getResult = iDataSource2.get(Communication.CommunicationStatus.getObjectId());
                    if (getResult == null || getResult.hasError() || !((object = getResult.getValue()) instanceof Integer) || (n = (Integer)object) != 1) continue;
                    iDataSource = iDataSource2;
                    continue;
                }
                catch (InvalidObjectIdException invalidObjectIdException) {
                    logger.debug("Comms Status not available from datasource:" + i);
                    continue;
                }
                catch (CommunicationException communicationException) {
                    logger.debug("Not communicating with datasource:" + i);
                }
            }
            if (iDataSource == null) {
                iDataSource = this.thePSSide.getPSDataSources().get(0);
            }
        } else {
            logger.debug("PS Data Sources Array has no elements");
            iDataSource = null;
        }
        return iDataSource;
    }

    public Vector<IDataSource> getAllDataSources() {
        return this.thePSSide.getPSDataSources();
    }
}

