/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.IDataBus;
import com.apcc.m11.arch.datasource.IDataConsumer;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.psaggregator.DataAggregatorRuleManager;
import com.apcc.m11.components.psaggregator.M11SideDataBus;
import com.apcc.m11.components.psaggregator.PSSide;
import java.util.Vector;

public class DataBusAggregator {
    private M11SideDataBus theM11Side = new M11SideDataBus();
    private PSSide thePSSide = new PSSide();
    private DataAggregatorRuleManager theDataAggregatorRuleManager = null;

    public DataBusAggregator(DataAggregatorRuleManager dataAggregatorRuleManager) {
        this.theDataAggregatorRuleManager = dataAggregatorRuleManager;
        this.thePSSide.setM11Side(this.theM11Side);
        this.theM11Side.setDataAggregatorRuleManager(this.theDataAggregatorRuleManager);
        this.theDataAggregatorRuleManager.setPSSide(this.thePSSide);
    }

    public IDataSource getM11DataSource() {
        return this.theM11Side.getM11DataSource();
    }

    public IDataSource getM11SideDataSource() {
        return this.theM11Side;
    }

    public IDataConsumer getM11SideDataConsumer() {
        return this.theM11Side;
    }

    public IDataSource getPSSideDataSource() {
        return this.thePSSide;
    }

    public IDataBus getPSSideDataBus() {
        return this.thePSSide;
    }

    public Vector<Object> gatherPSResponses(ObjectId objectId) {
        return this.thePSSide.gatherPSResponses(objectId);
    }

    public SetResult setPSData(ObjectId objectId, Object object) throws InvalidValueException, InvalidObjectIdException, CommunicationException {
        return this.theM11Side.set(objectId, object);
    }

    public void start() {
    }
}

