/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.DataBusAggregator;
import com.apcc.m11.components.psaggregator.IEventRule;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.M11SideEventBus;
import com.apcc.m11.ds.events.internalevents.powersource.OperationalEvents;
import com.apcc.m11.ds.powersource.OIdEventMapping;
import com.apcc.pcns.ServiceManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class EventAggregatorRuleManager {
    private static final Logger logger = LogManager.getLogger(EventAggregatorRuleManager.class);
    private M11SideEventBus theM11Side = null;
    private DataBusAggregator theDataBus = null;
    public AggregatorState theAggregatorState = null;
    protected List<IEventRule> theInputEventRules = null;
    protected List<IRule> theStateUpdateRules = null;
    protected List<IRule> theFiringLogicRules = null;
    protected ServiceManager services;

    public EventAggregatorRuleManager(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.theInputEventRules = new ArrayList<IEventRule>();
        this.theStateUpdateRules = new ArrayList<IRule>();
        this.theFiringLogicRules = new ArrayList<IRule>();
        this.theAggregatorState = new AggregatorState();
        OIdEventMapping oIdEventMapping = new OIdEventMapping();
        oIdEventMapping.initMap();
        this.initRules();
        for (IEventRule object : this.theInputEventRules) {
            object.setEventAggregatorRuleManager(this);
            object.setAggregatorState(this.theAggregatorState);
        }
        for (IRule iRule : this.theStateUpdateRules) {
            iRule.setEventAggregatorRuleManager(this);
            iRule.setAggregatorState(this.theAggregatorState);
        }
        for (IRule iRule : this.theFiringLogicRules) {
            iRule.setEventAggregatorRuleManager(this);
            iRule.setAggregatorState(this.theAggregatorState);
        }
    }

    public AggregatorState getTheAggregatorState() {
        return this.theAggregatorState;
    }

    protected abstract void initRules();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggregateEvent(Event event, int n) {
        ObjectId objectId = event.getObjectId();
        if (OperationalEvents.FlexRulesCompleteOnPacket.getObjectId().equals((Object)objectId)) {
            for (IRule object2 : this.theStateUpdateRules) {
                object2.calculate();
            }
            AggregatorState iEventRule = this.theAggregatorState;
            synchronized (iEventRule) {
                for (IRule iterator : this.theFiringLogicRules) {
                    logger.trace("calculate:" + iterator.getClass().getName());
                    iterator.calculate();
                }
            }
        } else if (objectId != null) {
            for (IEventRule iEventRule : this.theInputEventRules) {
                Iterator<ObjectId> iterator = iEventRule.getConsumedEvents();
                while (iterator.hasNext()) {
                    ObjectId objectId2 = iterator.next();
                    if (!objectId2.equals((Object)objectId) && !objectId2.isPrefixOf(objectId)) continue;
                    logger.debug("Running rule for event " + objectId.toString() + " from PS " + n);
                    iEventRule.update(event, n);
                }
            }
        }
    }

    public void dispatchEvent(Event event) {
        this.theAggregatorState.setEventActive(event.getObjectId(), event.isActive());
        this.theM11Side.sendEventToM11(event);
    }

    public void setM11Side(M11SideEventBus m11SideEventBus) {
        this.theM11Side = m11SideEventBus;
    }

    public void setDataBusAggregator(DataBusAggregator dataBusAggregator) {
        this.theDataBus = dataBusAggregator;
    }

    public Object dataBusGet(int n, ObjectId objectId) throws InvalidObjectIdException {
        Vector<Object> vector = this.theDataBus.gatherPSResponses(objectId);
        try {
            return vector.elementAt(n);
        }
        catch (Exception exception) {
            throw new InvalidObjectIdException();
        }
    }

    public SetResult dataBusSet(ObjectId objectId, Object object) throws InvalidValueException, InvalidObjectIdException, CommunicationException {
        SetResult setResult = this.theDataBus.setPSData(objectId, object);
        return setResult;
    }

    public IDataSource getM11DataSource() {
        return this.theDataBus.getM11DataSource();
    }
}

