/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.RegistrationException;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.arch.event.IEventConsumer;
import com.apcc.m11.arch.event.IEventProducer;
import com.apcc.m11.components.psaggregator.EventAggregatorRuleManager;
import com.apcc.m11.components.psaggregator.PSSideEventBus;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class M11SideEventBus
implements IEventProducer,
IEventConsumer {
    private static final Logger logger = LogManager.getLogger(M11SideEventBus.class);
    private PSSideEventBus thePSSide = null;
    private Vector<IEventConsumer> theM11SideConsumers = new Vector();
    private Vector<IEventProducer> theM11SideProducers = new Vector();
    private EventAggregatorRuleManager theRuleManager;

    public M11SideEventBus(EventAggregatorRuleManager eventAggregatorRuleManager) {
        this.theRuleManager = eventAggregatorRuleManager;
    }

    public void registerEventConsumer(IEventConsumer iEventConsumer) throws RegistrationException {
        this.theM11SideConsumers.add(iEventConsumer);
    }

    public void unRegisterEventConsumer(IEventConsumer iEventConsumer) throws RegistrationException {
        if (!this.theM11SideConsumers.remove(iEventConsumer)) {
            throw new RegistrationException();
        }
    }

    public void registerEventProducer(IEventProducer iEventProducer) throws RegistrationException {
        this.theM11SideProducers.add(iEventProducer);
    }

    public void unRegisterEventProducer(IEventProducer iEventProducer) throws RegistrationException {
        if (!this.theM11SideProducers.remove(iEventProducer)) {
            throw new RegistrationException();
        }
    }

    public Enumeration<ObjectId> getConsumedEvents() {
        return this.thePSSide.getEventsConsumedByPSs();
    }

    public void update(Event event) {
        if (ShutdownEvents.TurnOffUpsStarting.getObjectId().equals((Object)event.getObjectId()) || ShutdownEvents.ShutdownOnBattery.getObjectId().equals((Object)event.getObjectId())) {
            if (event instanceof AdvancedGroupEvent) {
                AdvancedGroupEvent advancedGroupEvent = (AdvancedGroupEvent)event;
                if (this.theRuleManager.theAggregatorState.getAggregatorIdx() == advancedGroupEvent.getGroup()) {
                    this.theRuleManager.theAggregatorState.setOffInitiatedbyPCNS(event.isActive());
                }
            } else if (ShutdownEvents.TurnOffUpsStarting.getObjectId().equals((Object)event.getObjectId())) {
                this.theRuleManager.theAggregatorState.setOffInitiatedbyPCNS(event.isActive());
            }
        }
        this.thePSSide.routeEvent(event);
    }

    Enumeration<ObjectId> getEventsConsumedByM11() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        for (IEventConsumer iEventConsumer : this.theM11SideConsumers) {
            Enumeration enumeration = iEventConsumer.getConsumedEvents();
            while (enumeration.hasMoreElements()) {
                ObjectId objectId = (ObjectId)enumeration.nextElement();
                if (vector.contains(objectId)) continue;
                vector.add(objectId);
            }
        }
        return vector.elements();
    }

    void setPSSide(PSSideEventBus pSSideEventBus) {
        this.thePSSide = pSSideEventBus;
    }

    void sendEventToM11(Event event) {
        logger.trace("sendEventToM11");
        for (IEventConsumer iEventConsumer : this.theM11SideConsumers) {
            logger.trace("Update:" + event.toString() + " on " + iEventConsumer.getClass().getSimpleName());
            iEventConsumer.update(event);
        }
    }
}

