/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator;

import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.component.ComponentFailureException;
import com.apcc.m11.arch.component.ComponentID;
import com.apcc.m11.arch.component.IComponent;
import com.apcc.m11.arch.factory.ComponentFactory;
import com.apcc.m11.arch.m11component.IM11Component;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.arch.storage.ITemporaryStorage;
import com.apcc.m11.components.psaggregator.DataAggregatorRuleManagerParallel;
import com.apcc.m11.components.psaggregator.DataAggregatorRuleManagerRedundant;
import com.apcc.m11.components.psaggregator.DataBusAggregator;
import com.apcc.m11.components.psaggregator.EventAggregatorRuleManager;
import com.apcc.m11.components.psaggregator.EventAggregatorRuleManagerParallel;
import com.apcc.m11.components.psaggregator.EventAggregatorRuleManagerRedundant;
import com.apcc.m11.components.psaggregator.EventBusAggregator;
import com.apcc.m11.components.psaggregator.PowerSourceManager;
import com.apcc.m11.ds.arch.interfaces.Component;
import com.apcc.m11.ds.arch.interfaces.DataConsumer;
import com.apcc.m11.ds.arch.interfaces.DataSource;
import com.apcc.m11.ds.arch.interfaces.EventConsumer;
import com.apcc.m11.ds.arch.interfaces.EventProducer;
import com.apcc.m11.ds.arch.interfaces.M11Component;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.validation.StringSetValidator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PSAggregator
implements IM11Component,
IComponent {
    private static final Logger logger = LogManager.getLogger(PSAggregator.class);
    private static final String kComponentName = "PSAggregator";
    private static final ComponentID kComponentID = new ComponentID("PSAggregator");
    private static final String kComponentVersion = "1.0.0";
    protected static final String kPSAggregator_File = "psaggregator.m11";
    private static final String kParallelResourceBundleBasename = "com.apcc.m11.components.psaggregator.i18n.PSAggregatorParallel";
    protected static final String kMultipleResourceBundleBasename = "com.apcc.m11.components.psaggregator.i18n.PSAggregatorMultiple";
    protected static String resourceBundleName;
    protected ComponentFactory thePowerSourceComponentFactory = null;
    protected DataBusAggregator theDataBusAggregator = null;
    protected EventBusAggregator theEventBusAggregator = null;
    protected boolean enrolWithNMC = true;
    protected ServiceManager services;

    public PSAggregator() {
        logger.debug("PSAggregator()");
    }

    public static synchronized void setResourceBundleName(String string) {
        resourceBundleName = string;
    }

    public static synchronized String getResourceBundleName() {
        return resourceBundleName;
    }

    public Object getInstanceOf(ObjectId objectId) throws InvalidObjectIdException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        PSAggregator pSAggregator = null;
        if (objectId.equals((Object)M11Component.kOid)) {
            pSAggregator = this;
        } else if (objectId.equals((Object)Component.kOid)) {
            pSAggregator = this;
        } else {
            logger.warn("Invalid Instance " + objectId.toString());
            throw new InvalidObjectIdException();
        }
        return pSAggregator;
    }

    public void init(IPermanentStorage iPermanentStorage) throws ComponentFailureException {
        logger.debug("init");
        if (iPermanentStorage == null) {
            throw new ComponentFailureException("Permanent storage can't be null.");
        }
        this.services = ServiceManager.getInstance();
        String string = null;
        StringSetValidator stringSetValidator = new StringSetValidator(this.getDefaultMode());
        stringSetValidator.add("parallel");
        stringSetValidator.add("redundant");
        stringSetValidator.add("single");
        try {
            string = this.services.getConfigurationManager().getString("NetworkManagementCard", "mode", stringSetValidator);
        }
        catch (IllegalArgumentException | NoSuchElementException | ConversionException throwable) {
            logger.error((Object)throwable);
            string = this.getDefaultMode();
        }
        this.enrolWithNMC = this.services.getConfigurationManager().getBoolean("NetworkManagementCard", "enrolWithNMC", true);
        EventAggregatorRuleManager eventAggregatorRuleManager = null;
        if (string != null && string.equalsIgnoreCase("parallel")) {
            logger.debug("Switching to Parallel from:" + string);
            PSAggregator.setResourceBundleName(kParallelResourceBundleBasename);
            eventAggregatorRuleManager = new EventAggregatorRuleManagerParallel(this.services);
            this.theDataBusAggregator = new DataBusAggregator(new DataAggregatorRuleManagerParallel(eventAggregatorRuleManager.getTheAggregatorState(), this.services));
        } else if (string != null && string.equalsIgnoreCase("redundant")) {
            logger.debug("Switching to redundant from:" + string);
            PSAggregator.setResourceBundleName(kMultipleResourceBundleBasename);
            eventAggregatorRuleManager = new EventAggregatorRuleManagerRedundant(this.services);
            this.theDataBusAggregator = new DataBusAggregator(new DataAggregatorRuleManagerRedundant(eventAggregatorRuleManager.getTheAggregatorState(), this.services));
        } else {
            logger.error("Invalid aggregation mode.  Using Multiple as default");
            PSAggregator.setResourceBundleName(kMultipleResourceBundleBasename);
            eventAggregatorRuleManager = new EventAggregatorRuleManagerRedundant(this.services);
            this.theDataBusAggregator = new DataBusAggregator(new DataAggregatorRuleManagerRedundant(eventAggregatorRuleManager.getTheAggregatorState(), this.services));
        }
        this.theEventBusAggregator = new EventBusAggregator(eventAggregatorRuleManager);
        this.theEventBusAggregator.setDataBusAggregator(this.theDataBusAggregator);
        PowerSourceManager.getInstance(0, iPermanentStorage, this.theEventBusAggregator, this.theDataBusAggregator, eventAggregatorRuleManager.getTheAggregatorState(), this.services);
        this.thePowerSourceComponentFactory = new ComponentFactory();
        this.thePowerSourceComponentFactory.setComponentFile(kPSAggregator_File);
        Vector vector = this.thePowerSourceComponentFactory.createAll();
        if (vector.size() != 1) {
            throw new ComponentFailureException("Exactly 1 PowerSource must be found in the power source component directory");
        }
        PowerSourceManager powerSourceManager = PowerSourceManager.getCurrentInstance(0);
        if (powerSourceManager != null) {
            powerSourceManager.addComponents(vector);
        }
        int n = 0;
        Set<String> set = this.services.getConfigurationManager().getSectionKeys("NetworkManagementCard");
        for (String string2 : set) {
            if (!string2.startsWith("IP_") || string2.endsWith("_Outlet") || string2.endsWith("_Outlets")) continue;
            try {
                String string3 = this.services.getConfigurationManager().getString("NetworkManagementCard", string2);
                if (string3 == null || string3.equals("")) continue;
                ++n;
            }
            catch (ConversionException conversionException) {
                logger.error((Object)conversionException);
            }
        }
        if (powerSourceManager != null) {
            powerSourceManager.setNumberOfComponents(n);
        }
    }

    protected String getDefaultMode() {
        return "parallel";
    }

    public void start() throws ComponentFailureException {
        this.start(this.enrolWithNMC);
    }

    public void start(boolean bl) throws ComponentFailureException {
        logger.debug("start()");
        PowerSourceManager powerSourceManager = PowerSourceManager.getCurrentInstance(0);
        if (powerSourceManager != null) {
            powerSourceManager.start(bl);
        }
    }

    public void start(ITemporaryStorage iTemporaryStorage) throws ComponentFailureException {
        logger.debug("start(ITemporaryStorage)");
        this.start();
    }

    public void stop() {
        logger.debug("stop()");
        PowerSourceManager powerSourceManager = PowerSourceManager.getCurrentInstance(0);
        if (powerSourceManager != null) {
            powerSourceManager.stop();
            PowerSourceManager.unloadInstance(0);
        }
    }

    public void stop(ITemporaryStorage iTemporaryStorage) {
        this.stop();
    }

    public void suspend() {
        logger.debug("suspend()");
    }

    public void resume() {
        logger.debug("resume()");
    }

    public Object getInterface(ObjectId objectId) throws InvalidObjectIdException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        PSAggregator pSAggregator = null;
        if (objectId.equals((Object)M11Component.kOid)) {
            pSAggregator = this;
        } else if (objectId.equals((Object)Component.kOid)) {
            pSAggregator = this;
        } else if (objectId.equals((Object)DataConsumer.kOid)) {
            pSAggregator = this.theDataBusAggregator.getM11SideDataConsumer();
        } else if (objectId.equals((Object)EventProducer.kOid)) {
            pSAggregator = this.theEventBusAggregator.getM11SideEventProducer();
        } else if (objectId.equals((Object)DataSource.kOid)) {
            pSAggregator = this.theDataBusAggregator.getM11SideDataSource();
        } else if (objectId.equals((Object)EventConsumer.kOid)) {
            pSAggregator = this.theEventBusAggregator.getM11SideEventConsumer();
        } else {
            throw new InvalidObjectIdException("Interface Not Supported");
        }
        return pSAggregator;
    }

    public String getComponentName() {
        return kComponentName;
    }

    public ComponentID getComponentID() {
        return kComponentID;
    }

    public String getComponentVersion() {
        return kComponentVersion;
    }
}

