/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator;

import com.apcc.m11.arch.component.ComponentFailureException;
import com.apcc.m11.arch.factory.ComponentFactory;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.components.psaggregator.DataAggregatorRuleManagerAdvanced;
import com.apcc.m11.components.psaggregator.DataBusAggregator;
import com.apcc.m11.components.psaggregator.EventAggregatorRuleManager;
import com.apcc.m11.components.psaggregator.EventAggregatorRuleManagerAdvanced;
import com.apcc.m11.components.psaggregator.EventBusAggregator;
import com.apcc.m11.components.psaggregator.PSAggregator;
import com.apcc.m11.components.psaggregator.PowerSourceManager;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.ConfigurationKeys;
import com.apcc.pcns.configservice.validation.StringSetValidator;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PSAggregatorForAdvanced
extends PSAggregator {
    private static final Logger logger = LogManager.getLogger(PSAggregatorForAdvanced.class);
    private int advanced_ups_setup_idx = 0;
    private EventListener<ConfigurationEvent> configListener;
    EventAggregatorRuleManager ruleManager = null;

    public PSAggregatorForAdvanced(int n) {
        this.advanced_ups_setup_idx = n;
        logger.debug("PSGroupAggregator() [" + Integer.toString(this.advanced_ups_setup_idx) + "] initialized.");
    }

    @Override
    public void init(IPermanentStorage iPermanentStorage) throws ComponentFailureException {
        UPSSetup uPSSetup;
        logger.debug("init: " + Integer.toString(this.advanced_ups_setup_idx) + "]");
        if (iPermanentStorage == null) {
            throw new ComponentFailureException("Permanent storage can't be null.");
        }
        this.services = ServiceManager.getInstance();
        String string = null;
        StringSetValidator stringSetValidator = new StringSetValidator(this.getDefaultMode());
        stringSetValidator.add("advanced");
        try {
            string = this.services.getConfigurationManager().getString("NetworkManagementCard", "mode", stringSetValidator);
        }
        catch (IllegalArgumentException | NoSuchElementException | ConversionException throwable) {
            logger.error((Object)throwable);
            string = this.getDefaultMode();
        }
        this.enrolWithNMC = this.services.getConfigurationManager().getBoolean("NetworkManagementCard", "enrolWithNMC", true);
        if (string != null && string.equalsIgnoreCase("advanced")) {
            logger.debug("Switching to Advanced from:" + string);
            PSAggregatorForAdvanced.setResourceBundleName("com.apcc.m11.components.psaggregator.i18n.PSAggregatorMultiple");
            this.ruleManager = new EventAggregatorRuleManagerAdvanced(this.services);
            this.theDataBusAggregator = new DataBusAggregator(new DataAggregatorRuleManagerAdvanced(this.ruleManager.getTheAggregatorState(), this.services));
        } else {
            logger.error("Invalid aggregation mode.  Using Advanced as default");
            PSAggregatorForAdvanced.setResourceBundleName("com.apcc.m11.components.psaggregator.i18n.PSAggregatorMultiple");
            this.ruleManager = new EventAggregatorRuleManagerAdvanced(this.services);
            this.theDataBusAggregator = new DataBusAggregator(new DataAggregatorRuleManagerAdvanced(this.ruleManager.getTheAggregatorState(), this.services));
        }
        this.theEventBusAggregator = new EventBusAggregator(this.ruleManager);
        this.theEventBusAggregator.setDataBusAggregator(this.theDataBusAggregator);
        PowerSourceManager.getInstance(this.advanced_ups_setup_idx, iPermanentStorage, this.theEventBusAggregator, this.theDataBusAggregator, this.ruleManager.getTheAggregatorState(), this.services);
        String string2 = this.services.getAdvancedSetupHelper().readGroupNameFromConfig(this.advanced_ups_setup_idx);
        this.ruleManager.getTheAggregatorState().setAdvancedGroupName(string2);
        this.thePowerSourceComponentFactory = new ComponentFactory();
        this.thePowerSourceComponentFactory.setComponentFile("psaggregator.m11");
        Vector vector = this.thePowerSourceComponentFactory.createAll();
        if (vector.size() != 1) {
            throw new ComponentFailureException("Exactly 1 PowerSource must be found in the power source component directory");
        }
        PowerSourceManager powerSourceManager = PowerSourceManager.getCurrentInstance(this.advanced_ups_setup_idx);
        if (powerSourceManager != null) {
            powerSourceManager.addComponents(vector);
        }
        if ((uPSSetup = this.services.getAdvancedSetupHelper().readUPSSetupFromConfig(this.advanced_ups_setup_idx)) == null) {
            throw new ComponentFailureException("Unable to read ups setup from config file for setup:" + this.advanced_ups_setup_idx);
        }
        if (powerSourceManager != null) {
            powerSourceManager.setNumberOfComponents(uPSSetup.getNMCList().size());
        }
        this.setRedundancy(uPSSetup);
    }

    private void setRedundancy(UPSSetup uPSSetup) {
        if (uPSSetup.getUpsRequiredForLoad() <= 0) {
            logger.error("PSGroupAggregator: Ups required for load");
        } else if (uPSSetup.getNMCList().size() <= 0) {
            logger.error("PSGroupAggregator: IP count cannot be <= 0");
        } else {
            this.ruleManager.getTheAggregatorState().setTotalRedundantUps(uPSSetup.getNMCList().size() - uPSSetup.getUpsRequiredForLoad());
            this.ruleManager.getTheAggregatorState().setShutdownOnLostRedundancy(uPSSetup.getRedundancyLostShutdownEnabled());
            this.ruleManager.getTheAggregatorState().setUnitsRequiredForLoad(uPSSetup.getUpsRequiredForLoad());
        }
    }

    public void configUpdate() {
        PowerSourceManager powerSourceManager = PowerSourceManager.getCurrentInstance(this.advanced_ups_setup_idx);
        if (powerSourceManager != null) {
            powerSourceManager.configUpdate();
        }
    }

    @Override
    public void start(boolean bl) throws ComponentFailureException {
        logger.debug("start()");
        if (this.configListener == null) {
            this.configListener = new EventListener<ConfigurationEvent>(){

                public void onEvent(ConfigurationEvent configurationEvent) {
                    try {
                        if (!configurationEvent.isBeforeUpdate()) {
                            UPSSetup uPSSetup;
                            String string = ConfigurationKeys.getAdvancedSetupKey(PSAggregatorForAdvanced.this.advanced_ups_setup_idx);
                            String string2 = configurationEvent.getPropertyName();
                            if (StringUtils.startsWith((CharSequence)string2, (CharSequence)string) && StringUtils.endsWithAny((CharSequence)string2, (CharSequence[])new CharSequence[]{"ups_required_for_load", "shutdownOnLostRedundancy"}) && (uPSSetup = PSAggregatorForAdvanced.this.services.getAdvancedSetupHelper().readUPSSetupFromConfig(PSAggregatorForAdvanced.this.advanced_ups_setup_idx)) != null) {
                                PSAggregatorForAdvanced.this.setRedundancy(uPSSetup);
                            }
                        }
                    }
                    catch (Exception exception) {
                        logger.error("onEvent", (Throwable)exception);
                    }
                }
            };
        }
        this.services.getConfigurationManager().addEventListener(ConfigurationEvent.SET_PROPERTY, this.configListener);
        PowerSourceManager powerSourceManager = PowerSourceManager.getCurrentInstance(this.advanced_ups_setup_idx);
        if (powerSourceManager != null) {
            powerSourceManager.start(bl);
        }
    }

    @Override
    public void stop() {
        logger.debug("stop()");
        this.services.getConfigurationManager().removeEventListener(ConfigurationEvent.SET_PROPERTY, this.configListener);
        PowerSourceManager powerSourceManager = PowerSourceManager.getCurrentInstance(this.advanced_ups_setup_idx);
        if (powerSourceManager != null) {
            powerSourceManager.stop();
            PowerSourceManager.unloadInstance(this.advanced_ups_setup_idx);
        }
    }

    @Override
    protected String getDefaultMode() {
        return "advanced";
    }
}

