/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.RegistrationException;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.arch.event.IEventConsumer;
import com.apcc.m11.arch.event.IEventProducer;
import com.apcc.m11.components.psaggregator.EventAggregatorRuleManager;
import com.apcc.m11.components.psaggregator.M11SideEventBus;
import java.util.Enumeration;
import java.util.Vector;

public class PSSideEventBus
implements IEventProducer {
    private Vector<IEventConsumer> thePSSideConsumers = new Vector();
    private Vector<IEventProducer> thePSSideProducers = new Vector();
    private M11SideEventBus theM11Side = null;
    private EventAggregatorRuleManager theEventAggregatorRuleManager = null;

    public void registerEventConsumer(IEventConsumer iEventConsumer) throws RegistrationException {
        this.thePSSideConsumers.add(iEventConsumer);
    }

    public void unRegisterEventConsumer(IEventConsumer iEventConsumer) throws RegistrationException {
        if (!this.thePSSideConsumers.remove(iEventConsumer)) {
            throw new RegistrationException();
        }
    }

    public void registerEventProducer(IEventProducer iEventProducer) throws RegistrationException {
        this.thePSSideProducers.add(iEventProducer);
    }

    public void unRegisterEventProducer(IEventProducer iEventProducer) throws RegistrationException {
        if (!this.thePSSideProducers.remove(iEventProducer)) {
            throw new RegistrationException();
        }
    }

    public Enumeration<ObjectId> getConsumedEvents() {
        return this.theM11Side.getEventsConsumedByM11();
    }

    public void update(Event event, int n) {
        this.theEventAggregatorRuleManager.aggregateEvent(event, n);
    }

    Enumeration<ObjectId> getEventsConsumedByPSs() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        for (IEventConsumer iEventConsumer : this.thePSSideConsumers) {
            Enumeration enumeration = iEventConsumer.getConsumedEvents();
            while (enumeration.hasMoreElements()) {
                ObjectId objectId = (ObjectId)enumeration.nextElement();
                if (vector.contains(objectId)) continue;
                vector.add(objectId);
            }
        }
        return vector.elements();
    }

    void routeEvent(Event event) {
        block0: for (IEventConsumer iEventConsumer : this.thePSSideConsumers) {
            Enumeration enumeration = iEventConsumer.getConsumedEvents();
            while (enumeration.hasMoreElements()) {
                ObjectId objectId = (ObjectId)enumeration.nextElement();
                if (!objectId.isPrefixOf(event.getObjectId()) && !objectId.equals((Object)event.getObjectId())) continue;
                iEventConsumer.update(event);
                continue block0;
            }
        }
    }

    void setM11Side(M11SideEventBus m11SideEventBus) {
        this.theM11Side = m11SideEventBus;
    }

    void setEventAggregatorRuleManager(EventAggregatorRuleManager eventAggregatorRuleManager) {
        this.theEventAggregatorRuleManager = eventAggregatorRuleManager;
    }
}

