/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator;

import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.component.ComponentFailureException;
import com.apcc.m11.arch.datasource.IDataConsumer;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.arch.event.IEventConsumer;
import com.apcc.m11.arch.event.IEventProducer;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.DataBusAggregator;
import com.apcc.m11.components.psaggregator.EventBusAggregator;
import com.apcc.m11.components.psaggregator.PermanentStorageFacade;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.ds.arch.interfaces.DataConsumer;
import com.apcc.m11.ds.arch.interfaces.DataSource;
import com.apcc.m11.ds.arch.interfaces.EventConsumer;
import com.apcc.m11.ds.arch.interfaces.EventProducer;
import com.apcc.m11.ds.events.internalEvents.application.AllComponentsStarted;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import com.apcc.pcns.ServiceManager;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Future;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PowerSourceManager {
    private static final Logger logger = LogManager.getLogger(PowerSourceManager.class);
    private static Map<Integer, PowerSourceManager> pcmMap;
    private Vector<PowerSourceComponent> theComponents = new Vector();
    private int thePowerSourceCount = 0;
    private DataBusAggregator theDataBusAggregator;
    private EventBusAggregator theEventBusAggregator;
    private IPermanentStorage thePermanentStorage;
    private AggregatorState theAggregatorState;
    private boolean enrolWithNMC = true;
    private ServiceManager services;

    public static synchronized PowerSourceManager getInstance(int n, IPermanentStorage iPermanentStorage, EventBusAggregator eventBusAggregator, DataBusAggregator dataBusAggregator, AggregatorState aggregatorState, ServiceManager serviceManager) {
        PowerSourceManager powerSourceManager = null;
        if (pcmMap == null) {
            pcmMap = new HashMap<Integer, PowerSourceManager>();
        }
        if (pcmMap.get(n) == null) {
            powerSourceManager = new PowerSourceManager(n, iPermanentStorage, eventBusAggregator, dataBusAggregator, aggregatorState, serviceManager);
            pcmMap.put(n, powerSourceManager);
        } else {
            powerSourceManager = pcmMap.get(n);
        }
        return powerSourceManager;
    }

    public static synchronized PowerSourceManager getCurrentInstance(int n) {
        if (pcmMap != null && pcmMap.get(n) != null) {
            return pcmMap.get(n);
        }
        return null;
    }

    public static synchronized void unloadInstance(int n) {
        if (pcmMap != null && pcmMap.get(n) != null) {
            pcmMap.remove(n);
            if (pcmMap.isEmpty()) {
                pcmMap = null;
            }
        }
    }

    private PowerSourceManager(int n, IPermanentStorage iPermanentStorage, EventBusAggregator eventBusAggregator, DataBusAggregator dataBusAggregator, AggregatorState aggregatorState, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.theDataBusAggregator = dataBusAggregator;
        this.theEventBusAggregator = eventBusAggregator;
        this.theAggregatorState = aggregatorState;
        this.thePermanentStorage = iPermanentStorage;
        this.theAggregatorState.setAggregatorIdx(n);
    }

    public void addComponents(Vector<PowerSourceComponent> vector) {
        Enumeration<PowerSourceComponent> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PowerSourceComponent powerSourceComponent = enumeration.nextElement();
            this.addComponent(powerSourceComponent);
        }
    }

    public void startComponents() {
        this.enrolWithNMC = this.services.getConfigurationManager().getBoolean("NetworkManagementCard", "enrolWithNMC", true);
        this.startComponents(this.enrolWithNMC);
    }

    public void startComponents(boolean bl) {
        Vector vector = new Vector();
        for (PowerSourceComponent powerSourceComponent : this.theComponents) {
            Future<?> future = ServiceManager.getInstance().getThreadService().submit(new StartComponentWorker(powerSourceComponent, bl));
            vector.add(future);
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logger.trace("All Started");
    }

    public void setNumberOfComponents(int n) {
        logger.debug("> setNumberOfComponents from:" + this.theComponents.size() + " to:" + n);
        for (int i = this.theComponents.size() - 1; i < n; ++i) {
            this.theAggregatorState.initialisePS(i);
        }
        while (this.theComponents.size() < n) {
            logger.debug("add from:" + this.theComponents.size() + " to:" + n);
            PowerSourceComponent powerSourceComponent = this.theComponents.elementAt(0);
            try {
                this.addComponent((PowerSourceComponent)powerSourceComponent.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (InstantiationException instantiationException) {
                logger.error((Object)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.error((Object)illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.error((Object)illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                logger.error((Object)invocationTargetException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                logger.error((Object)noSuchMethodException);
            }
            catch (SecurityException securityException) {
                logger.error((Object)securityException);
            }
        }
        if (n == 0) {
            n = 1;
        }
        while (this.theComponents.size() > n) {
            logger.debug("remove from:" + this.theComponents.size() + " to:" + n);
            this.removeLastComponent();
        }
        logger.debug("< setNumberOfComponents from:" + this.theComponents.size() + " to:" + n);
    }

    private void addComponent(PowerSourceComponent powerSourceComponent) {
        try {
            if (powerSourceComponent != null) {
                PermanentStorageFacade permanentStorageFacade = new PermanentStorageFacade(this.thePermanentStorage, Integer.toString(++this.thePowerSourceCount));
                this.theComponents.add(powerSourceComponent);
                powerSourceComponent.setAdvancedUpsSetupIndex(this.theAggregatorState.getAggregatorIdx());
                powerSourceComponent.setAdvancedUpsSetupName(this.theAggregatorState.getAdvancedGroupName());
                powerSourceComponent.setThePSIndex(this.theComponents.size() - 1);
                powerSourceComponent.init(permanentStorageFacade);
                this.wireInterfaces(powerSourceComponent);
            }
        }
        catch (Exception exception) {
            logger.error("Exception while adding Component", (Throwable)exception);
        }
    }

    private synchronized void removeLastComponent() {
        int n = this.theComponents.size() - 1;
        PowerSourceComponent powerSourceComponent = this.theComponents.remove(n);
        this.theAggregatorState.removePS(n);
        try {
            if (powerSourceComponent != null) {
                powerSourceComponent.stop();
                this.unwireInterfaces(powerSourceComponent);
                powerSourceComponent.removeConfiguration();
            }
        }
        catch (Exception exception) {
            logger.error("Exception while removing Component", (Throwable)exception);
        }
    }

    private void wireInterfaces(PowerSourceComponent powerSourceComponent) {
        IEventProducer iEventProducer;
        IEventConsumer iEventConsumer;
        try {
            iEventConsumer = (IEventConsumer)powerSourceComponent.getInterface(EventConsumer.kOid);
            if (iEventConsumer != null) {
                iEventProducer = this.theEventBusAggregator.getPSSideEventProducer();
                iEventConsumer.registerEventProducer(iEventProducer);
                iEventProducer.registerEventConsumer(iEventConsumer);
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.debug((Object)invalidObjectIdException);
        }
        catch (Exception exception) {
            logger.error("PowerSourceManager.wireInterfaces(): Exception while wiring Event Consumers", (Throwable)exception);
        }
        try {
            iEventConsumer = (IDataSource)powerSourceComponent.getInterface(DataSource.kOid);
            if (iEventConsumer != null) {
                this.theDataBusAggregator.getPSSideDataBus().registerDataSource((IDataSource)iEventConsumer);
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.debug((Object)invalidObjectIdException);
        }
        catch (Exception exception) {
            logger.error("PowerSourceManager.wireInterfaces(): Exception while wiring Data Sources", (Throwable)exception);
        }
        try {
            iEventConsumer = (IEventProducer)powerSourceComponent.getInterface(EventProducer.kOid);
            if (iEventConsumer != null) {
                iEventProducer = this.theEventBusAggregator.getPSSideEventConsumer(powerSourceComponent);
                iEventConsumer.registerEventConsumer((IEventConsumer)iEventProducer);
                iEventProducer.registerEventProducer((IEventProducer)iEventConsumer);
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.debug((Object)invalidObjectIdException);
        }
        catch (ClassCastException classCastException) {
            logger.debug((Object)classCastException);
        }
        catch (Exception exception) {
            logger.error("PowerSourceManager.wireInterfaces(): Exception while wiring Event Producers", (Throwable)exception);
        }
        try {
            iEventConsumer = (IDataConsumer)powerSourceComponent.getInterface(DataConsumer.kOid);
            if (iEventConsumer != null) {
                iEventConsumer.setDataSource(this.theDataBusAggregator.getPSSideDataSource());
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.debug((Object)invalidObjectIdException);
        }
        catch (Exception exception) {
            logger.error("PowerSourceManager.wireInterfaces(): Exception while wiring Data Consumers", (Throwable)exception);
        }
    }

    private void unwireInterfaces(PowerSourceComponent powerSourceComponent) {
        IEventProducer iEventProducer;
        IEventConsumer iEventConsumer;
        logger.debug("unwireInterfaces()");
        try {
            iEventConsumer = (IEventConsumer)powerSourceComponent.getInterface(EventConsumer.kOid);
            if (iEventConsumer != null) {
                iEventProducer = this.theEventBusAggregator.getPSSideEventProducer();
                iEventProducer.unRegisterEventConsumer(iEventConsumer);
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.debug((Object)invalidObjectIdException);
        }
        catch (Exception exception) {
            logger.error("PowerSourceManager.unwireInterfaces(): Exception while unwiring Event Consumers", (Throwable)exception);
        }
        try {
            iEventConsumer = (IDataSource)powerSourceComponent.getInterface(DataSource.kOid);
            if (iEventConsumer != null) {
                this.theDataBusAggregator.getPSSideDataBus().unRegisterDataSource((IDataSource)iEventConsumer);
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.debug((Object)invalidObjectIdException);
        }
        catch (Exception exception) {
            logger.error("PowerSourceManager.unwireInterfaces(): Exception while unwiring Data Sources", (Throwable)exception);
        }
        try {
            iEventConsumer = (IEventProducer)powerSourceComponent.getInterface(EventProducer.kOid);
            if (iEventConsumer != null) {
                iEventProducer = this.theEventBusAggregator.getPSSideEventConsumer(powerSourceComponent);
                iEventProducer.unRegisterEventProducer((IEventProducer)iEventConsumer);
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.debug((Object)invalidObjectIdException);
        }
        catch (ClassCastException classCastException) {
            logger.debug((Object)classCastException);
        }
        catch (Exception exception) {
            logger.error("PowerSourceManager.unwireInterfaces(): Exception while wiring Event Producers", (Throwable)exception);
        }
        try {
            iEventConsumer = (IDataConsumer)powerSourceComponent.getInterface(DataConsumer.kOid);
            if (iEventConsumer != null) {
                iEventConsumer.setDataSource(null);
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.debug((Object)invalidObjectIdException);
        }
        catch (Exception exception) {
            logger.error("PowerSourceManager.unwireInterfaces(): Exception while wiring Data Consumers", (Throwable)exception);
        }
    }

    public void start() throws ComponentFailureException {
        this.start(this.enrolWithNMC);
    }

    public void start(boolean bl) throws ComponentFailureException {
        logger.debug("start()");
        this.theDataBusAggregator.start();
        this.theEventBusAggregator.start();
        this.startComponents(bl);
    }

    public void stop() {
        logger.debug("stop()");
        Enumeration<PowerSourceComponent> enumeration = this.theComponents.elements();
        while (enumeration.hasMoreElements()) {
            PowerSourceComponent powerSourceComponent = enumeration.nextElement();
            powerSourceComponent.stop();
            this.unwireInterfaces(powerSourceComponent);
        }
    }

    public Enumeration<PowerSourceComponent> getComponents() {
        return this.theComponents.elements();
    }

    public Vector<Object> gatherEventPorts() {
        Vector<Object> vector = this.theDataBusAggregator.gatherPSResponses(TCPIPCommunication.EventReceiverPort.getObjectId());
        for (Object object : vector) {
            if (object instanceof Integer) continue;
            vector.remove(object);
        }
        return vector;
    }

    public void configUpdate() {
        UPSSetup uPSSetup = this.services.getAdvancedSetupHelper().readUPSSetupFromConfig(this.theAggregatorState.getAggregatorIdx());
        if (uPSSetup == null) {
            logger.error("Unable to load configuration for setup:" + this.theAggregatorState.getAggregatorIdx() + " from ini file");
            return;
        }
        this.theAggregatorState.setTotalRedundantUps(uPSSetup.getNMCList().size() - uPSSetup.getUpsRequiredForLoad());
        this.theAggregatorState.setShutdownOnLostRedundancy(uPSSetup.getRedundancyLostShutdownEnabled());
        this.theAggregatorState.setUnitsRequiredForLoad(uPSSetup.getUpsRequiredForLoad());
    }

    private static class StartComponentWorker
    implements Runnable {
        PowerSourceComponent ps;
        boolean enrollWithNMC;

        public StartComponentWorker(PowerSourceComponent powerSourceComponent, boolean bl) {
            this.ps = powerSourceComponent;
            this.enrollWithNMC = bl;
        }

        @Override
        public void run() {
            logger.trace("started");
            try {
                this.ps.start(this.enrollWithNMC);
                IEventConsumer iEventConsumer = (IEventConsumer)this.ps.getInterface(EventConsumer.kOid);
                iEventConsumer.update(new Event(AllComponentsStarted.kOid));
            }
            catch (ComponentFailureException componentFailureException) {
                logger.error("Unable to start PowerSource", (Throwable)componentFailureException);
            }
            catch (InvalidObjectIdException invalidObjectIdException) {
                logger.error("Unable to start PowerSource", (Throwable)invalidObjectIdException);
            }
            logger.trace("completed");
        }
    }
}

