/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.FormatterException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.arch.VariableBinding;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.MultipleCriticalEventFormatter;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import com.apcc.m11.ds.events.flexevents.powersource.Battery;
import com.apcc.m11.ds.events.flexevents.powersource.Bypass;
import com.apcc.m11.ds.events.flexevents.powersource.Communication;
import com.apcc.m11.ds.events.flexevents.powersource.LoadCapability;
import com.apcc.m11.ds.events.flexevents.powersource.MultipleEvent;
import com.apcc.m11.ds.events.flexevents.powersource.Redundancy;
import com.apcc.m11.ds.events.flexevents.powersource.Temperature;
import com.apcc.m11.ds.events.flexevents.powersource.UtilityLineStatus;
import com.apcc.m11.ds.services.ShutdownGroup;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MultipleCriticalEventFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final Logger logger = LogManager.getLogger(MultipleCriticalEventFiringLogicRule.class);
    private static final String kLowBatteryLogMsg = "LowBatteryLogMsg";
    private static final String kOnBatteryLogMsg = "OnBatteryLogMsg";
    private static final String kOverloadLogMsg = "OverloadLogMsg";
    private static final String kDiscahegedLogMsg = "DischargedLogMsg";
    private static final String kBatteryNeedsReplacingLogMsg = "BatteryNeedsReplacingLogMsg";
    private static final String kNetCommLostLogMsg = "NetCommLostLogMsg";
    private static final String kCommLostLogMsg = "CommLostLogMsg";
    private static final String kCommLostWhileOnBattLogMsg = "CommLostWhileOnBattLogMsg";
    protected static final String kPowerOffLogMsg = "PowerOffLogMsg";
    protected static final String kOutletOffLogMsg = "OutletOffLogMsg";
    private static final String kBatteryDisconnectedLogMsg = "BatteryDisconnectedLogMsg";
    private static final String kBypassSwitchFailedLogMsg = "BypassSwitchFailedLogMsg";
    private static final String kBypassEnabledLogMsg = "BypassEnabledLogMsg";
    private static final String kBypassManualEnabledLogMsg = "BypassManualEnabledLogMsg";
    private static final String kFanFailureLogMsg = "FanFailureLogMsg";
    private static final String kMinimumLoadCapabilityLostLogMsg = "MinimumLoadCapabilityLostLogMsg";
    private static final String kMinimumRedundancyLostLogMsg = "MinimumRedundancyLostLogMsg";
    private static final String kPowerModuleFailedLogMsg = "PowerModuleFailedLogMsg";
    private static final String kInternalTemperatureExceededLogMsg = "InternalTemperatureExceededLogMsg";
    private static final String kUPSTurnOffInitiatedMsg = "UPSTurnOffInitiatedMsg";
    private static final String kMultipleCriticalEventMsg = "MultipleCriticalEventFlexEvent";
    private static final String kMultipleCriticalEventResolvedMsg = "MultipleCriticalEventResolvedFlexEvent";
    private static final String kOutletTurnOffInitiatedMsg = "OutletTurnOffInitiatedMsg";
    private String theMultipleEventMsg;
    private String theSentMultipleEventMsg;
    String[] criticalEventName = null;
    private boolean advancedMode = false;

    public MultipleCriticalEventFiringLogicRule() {
        this.advancedMode = false;
    }

    public MultipleCriticalEventFiringLogicRule(boolean bl) {
        this.advancedMode = bl;
    }

    @Override
    public void calculate() {
        boolean bl = this.isEventOccur();
        logger.debug("A Multiple critical event has occurred: " + bl);
        if (bl) {
            if (!this.theMultipleEventMsg.equals(this.theSentMultipleEventMsg)) {
                logger.info("MultipleCriticalEventFiringLogicRule.calculate(): firing MultipleCriticalEvent event ");
                if (this.theState.getLastReportedMultipleCriticalEventState() == 2) {
                    if (!this.advancedMode) {
                        this.theManager.dispatchEvent(new Event(MultipleEvent.MultipleCriticalEventResolved.getObjectId(), false));
                    } else {
                        this.theManager.dispatchEvent(new AdvancedGroupEvent(MultipleEvent.MultipleCriticalEventResolved.getObjectId(), false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
                    }
                }
                if (!this.advancedMode) {
                    this.theManager.dispatchEvent(new DetailedEvent(MultipleEvent.MultipleCriticalEvent.getObjectId(), true, new MultipleCriticalEventFormatter(kMultipleCriticalEventMsg, this.theMultipleEventMsg), false, MultipleEvent.MultipleCriticalEvent.getEventId()));
                } else {
                    this.theManager.dispatchEvent(new AdvancedGroupEvent(MultipleEvent.MultipleCriticalEvent.getObjectId(), true, new MultipleCriticalEventFormatter(kMultipleCriticalEventMsg, this.theMultipleEventMsg), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), false, MultipleEvent.MultipleCriticalEvent.getEventId()));
                }
                this.theState.setLastReportedMultipleCriticalEventState(1);
                this.theSentMultipleEventMsg = this.theMultipleEventMsg;
            }
        } else {
            this.theSentMultipleEventMsg = "";
            if (!this.theState.getOffInitiatedbyPCNS() && this.theState.getLastReportedMultipleCriticalEventState() == 1) {
                logger.info("MultipleCriticalEventFiringLogicRule.calculate(): firing MultipleCriticalEventResolved event ");
                if (!this.advancedMode) {
                    this.theManager.dispatchEvent(new Event(MultipleEvent.MultipleCriticalEvent.getObjectId(), false));
                } else {
                    this.theManager.dispatchEvent(new AdvancedGroupEvent(MultipleEvent.MultipleCriticalEvent.getObjectId(), false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
                }
                if (!this.advancedMode) {
                    this.theManager.dispatchEvent(new DetailedEvent(MultipleEvent.MultipleCriticalEventResolved.getObjectId(), true, new EventMessageFormatter(kMultipleCriticalEventResolvedMsg), true, MultipleEvent.MultipleCriticalEventResolved.getEventId()));
                } else {
                    this.theManager.dispatchEvent(new AdvancedGroupEvent(MultipleEvent.MultipleCriticalEventResolved.getObjectId(), true, new EventMessageFormatter(kMultipleCriticalEventResolvedMsg), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), true, MultipleEvent.MultipleCriticalEventResolved.getEventId()));
                }
                this.theState.setLastReportedMultipleCriticalEventState(2);
            }
        }
    }

    private boolean isEventOccur() {
        int n;
        boolean bl = false;
        boolean[] blArray = this.theState.getLowBattery();
        boolean[] blArray2 = this.theState.getOnBattery();
        boolean[] blArray3 = AggregatorState.not(this.theState.getNetCommEstablished());
        boolean[] blArray4 = AggregatorState.not(this.theState.getCommEstablished());
        boolean[] blArray5 = this.theState.getPowerSourceReported();
        blArray4 = AggregatorState.and(blArray5, blArray4);
        boolean[] blArray6 = this.theState.getOverload();
        boolean[] blArray7 = this.theState.getDischarged();
        boolean[] blArray8 = this.theState.getPowerOff();
        boolean[] blArray9 = this.theState.getOutletOff();
        boolean[] blArray10 = this.theState.getBypassSwitchFailed();
        boolean[] blArray11 = this.theState.getOnBypass();
        boolean[] blArray12 = this.theState.getOnManualBypass();
        boolean[] blArray13 = this.theState.getMinLoadCapabilityLost();
        boolean[] blArray14 = this.theState.getMinRedundancyLost();
        boolean[] blArray15 = this.theState.getInternalTempOK();
        boolean[] blArray16 = this.theState.getUpsTurnOffInitiated();
        boolean[] blArray17 = this.theState.getOutletTurnOffInitiated();
        int n2 = this.theState.getTotalRedundantUps();
        int n3 = blArray2.length;
        if (AggregatorState.find_matches(AggregatorState.or(blArray8, blArray9), true) == n3) {
            return false;
        }
        boolean[] blArray18 = new boolean[n3];
        for (int i = 0; i < n3; ++i) {
            blArray18[i] = false;
        }
        this.criticalEventName = new String[n3];
        try {
            GetResult getResult = this.theManager.getM11DataSource().get(ShutdownGroup.ShutdownTriggers.getObjectId());
            Vector vector = (Vector)getResult.getValue();
            if (vector == null) {
                vector = new Vector();
            }
            for (int i = 0; i < vector.size(); ++i) {
                int n4;
                boolean[] blArray19 = new boolean[n3];
                String string = "unknown";
                VariableBinding variableBinding = (VariableBinding)vector.elementAt(i);
                ObjectId objectId = variableBinding.getObjectId();
                if (objectId.equals((Object)Battery.LowBattery.getObjectId())) {
                    blArray19 = blArray;
                    string = kLowBatteryLogMsg;
                } else if (objectId.equals((Object)UtilityLineStatus.PowerFailed.getObjectId())) {
                    blArray19 = blArray2;
                    string = kOnBatteryLogMsg;
                } else if (objectId.equals((Object)UtilityLineStatus.Overload.getObjectId())) {
                    blArray19 = blArray6;
                    string = kOverloadLogMsg;
                } else if (objectId.equals((Object)Battery.BatteryDischarged.getObjectId())) {
                    blArray19 = blArray7;
                    string = kDiscahegedLogMsg;
                } else if (objectId.equals((Object)Communication.NetCommunicationLost.getObjectId())) {
                    blArray19 = blArray3;
                    string = kNetCommLostLogMsg;
                } else if (objectId.equals((Object)Communication.CommunicationLost.getObjectId())) {
                    blArray19 = blArray4;
                    string = kCommLostLogMsg;
                } else if (objectId.equals((Object)Communication.CommunicationLostOnBattery.getObjectId())) {
                    blArray19 = blArray4;
                    string = kCommLostWhileOnBattLogMsg;
                    for (int j = 0; j < n3; ++j) {
                        if ((!blArray4[j] || !blArray2[j]) && (!blArray3[j] || !blArray2[j])) continue;
                        this.criticalEventName[j] = string;
                        blArray18[j] = true;
                    }
                } else if (objectId.equals((Object)Bypass.BypassContactorFailed.getObjectId())) {
                    blArray19 = blArray10;
                    string = kBypassSwitchFailedLogMsg;
                } else if (objectId.equals((Object)Bypass.BypassEnabled.getObjectId())) {
                    blArray19 = blArray11;
                    string = kBypassEnabledLogMsg;
                } else if (objectId.equals((Object)Bypass.BypassManualEnabled.getObjectId())) {
                    blArray19 = blArray12;
                    string = kBypassManualEnabledLogMsg;
                } else if (objectId.equals((Object)LoadCapability.MinLoadCapabilityLost.getObjectId())) {
                    blArray19 = blArray13;
                    string = kMinimumLoadCapabilityLostLogMsg;
                } else if (objectId.equals((Object)Redundancy.MinRedundancyLost.getObjectId())) {
                    blArray19 = blArray14;
                    string = kMinimumRedundancyLostLogMsg;
                } else if (objectId.equals((Object)Temperature.MaxInternalTempExceeded.getObjectId())) {
                    blArray19 = AggregatorState.not(blArray15);
                    string = kInternalTemperatureExceededLogMsg;
                } else if (objectId.equals((Object)ShutdownEvents.PowerSourceTurnOffInitiated.getObjectId())) {
                    blArray19 = blArray16;
                    string = kUPSTurnOffInitiatedMsg;
                } else if (objectId.equals((Object)ShutdownEvents.UPSOutletTurnOffInitiated.getObjectId())) {
                    blArray19 = blArray17;
                    string = kOutletTurnOffInitiatedMsg;
                } else {
                    logger.debug("unknown critical event:" + String.valueOf(objectId));
                }
                logger.debug("Eventname:" + string + " status:" + AggregatorState.toString(blArray19));
                boolean[] blArray20 = this.theState.getMonitoringStarted();
                logger.debug("Check that monitoring has started:" + AggregatorState.toString(blArray20));
                blArray19 = AggregatorState.and(blArray20, blArray19);
                logger.debug("Eventname:" + string + " status:" + AggregatorState.toString(blArray19));
                if (this.isCriticalEventMatch(blArray19) && !objectId.equals((Object)Communication.CommunicationLostOnBattery.getObjectId())) {
                    for (n4 = 0; n4 < n3; ++n4) {
                        if (!blArray19[n4] || blArray18[n4] || blArray[n4] && !string.equals(kLowBatteryLogMsg)) continue;
                        this.criticalEventName[n4] = string;
                        blArray18[n4] = true;
                    }
                }
                if (AggregatorState.find_matches(blArray19, true) > 1 && (objectId.equals((Object)UtilityLineStatus.PowerFailed.getObjectId()) || objectId.equals((Object)Communication.NetCommunicationLost.getObjectId()) || objectId.equals((Object)Communication.CommunicationLost.getObjectId()))) {
                    for (n4 = 0; n4 < n3; ++n4) {
                        if (blArray19[n4] && !blArray18[n4]) {
                            if (blArray[n4] && !string.equals(kLowBatteryLogMsg)) continue;
                            this.criticalEventName[n4] = string;
                            blArray18[n4] = true;
                            continue;
                        }
                        if (!blArray19[n4] || !this.criticalEventName[n4].equals(kCommLostLogMsg) || !string.equals(kNetCommLostLogMsg)) continue;
                        this.criticalEventName[n4] = string;
                        blArray18[n4] = true;
                    }
                }
                logger.debug("CriticalEventCount:" + AggregatorState.toString(blArray18));
            }
        }
        catch (CommunicationException communicationException) {
            logger.trace("isEventOccur Exception", (Throwable)communicationException);
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.error("error Setting Outlet", (Throwable)invalidObjectIdException);
        }
        catch (Exception exception) {
            logger.error("isEventOccur Exception", (Throwable)exception);
        }
        logger.debug("Check outlet off:" + AggregatorState.toString(blArray9));
        for (n = 0; n < n3; ++n) {
            if (!blArray9[n]) continue;
            this.criticalEventName[n] = kOutletOffLogMsg;
            blArray18[n] = true;
        }
        logger.debug("CriticalEventCount:" + AggregatorState.toString(blArray18));
        logger.debug("Check power off:" + AggregatorState.toString(blArray8));
        for (n = 0; n < n3; ++n) {
            if (!blArray8[n]) continue;
            this.criticalEventName[n] = kPowerOffLogMsg;
            blArray18[n] = true;
        }
        logger.debug("CriticalEventCount:" + AggregatorState.toString(blArray18));
        if (this.aggregate(blArray18, this.criticalEventName)) {
            this.theMultipleEventMsg = this.eventLogMessage(this.criticalEventName);
            bl = true;
        }
        return bl;
    }

    protected boolean isCriticalEventMatch(boolean[] blArray) {
        return AggregatorState.find_matches(blArray, true) > 0;
    }

    protected abstract boolean aggregate(boolean[] var1, String[] var2);

    protected boolean checkDifferentEvent(String[] stringArray) {
        logger.debug("Checking for different events on :" + Arrays.toString(stringArray));
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : stringArray) {
            if (string == null) continue;
            hashSet.add(string);
        }
        boolean bl = hashSet.size() > 1;
        logger.debug("Found different events: " + bl);
        return bl;
    }

    protected String eventLogMessage(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (string == null) continue;
            EventMessageFormatter eventMessageFormatter = new EventMessageFormatter(string);
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            try {
                stringBuilder.append(eventMessageFormatter.format(string));
            }
            catch (FormatterException formatterException) {
                logger.error((Object)formatterException);
            }
            catch (UnsupportedLocaleException unsupportedLocaleException) {
                logger.error((Object)unsupportedLocaleException);
            }
        }
        return stringBuilder.toString();
    }
}

