/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.advanced;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.IEventRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.powersource.Battery;
import java.util.Iterator;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BatteryChargeInputEventRule
extends PSAggregatorRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(BatteryChargeInputEventRule.class);

    @Override
    public Iterator<ObjectId> getConsumedEvents() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(Battery.BatteryChargeInRange.getObjectId());
        vector.add(Battery.BatteryDischarged.getObjectId());
        return vector.iterator();
    }

    @Override
    public void update(Event event, int n) {
        if (event.isActive()) {
            if (event.getObjectId().equals((Object)Battery.BatteryDischarged.getObjectId())) {
                logger.info("BatteryDischarged: got an update from PS " + n);
                this.theState.setDischarged(n, true);
            } else {
                logger.info("BatteryChargeInRange: got an update from PS " + n);
                this.theState.setDischarged(n, false);
            }
        }
    }
}

