/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.advanced;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.ds.events.flexevents.powersource.Battery;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BatteryDischargedFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final ObjectId kBatteryChargeInRangeOid = Battery.BatteryChargeInRange.getObjectId();
    private static final String kBatteryDischargedMsg = "BatteryDischargedFlexEvent";
    private static final ObjectId kBatteryDischargedOid = Battery.BatteryDischarged.getObjectId();
    private static final Logger logger = LogManager.getLogger(BatteryDischargedFiringLogicRule.class);

    @Override
    public void calculate() {
        boolean[] blArray = this.theState.getDischarged();
        if (AggregatorState.find_matches(blArray, true) > this.theState.getTotalRedundantUps() && (this.theState.getLastReportedDischargeState() == 0 || this.theState.getLastReportedDischargeState() == 1)) {
            logger.debug("BatteryDischargedFiringLogicRule.calculate(): firing BatteryDischarged event ");
            if (this.theState.getLastReportedDischargeState() == 1) {
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kBatteryChargeInRangeOid, false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
            }
            this.theManager.dispatchEvent(new AdvancedGroupEvent(kBatteryDischargedOid, true, new EventMessageFormatter(kBatteryDischargedMsg), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), false, Battery.BatteryDischarged.getEventId()));
            this.theState.setLastReportedDischargeState(2);
        }
    }
}

