/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.advanced;

import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.ds.events.flexevents.powersource.Bypass;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BypassFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kBypassDisabledMsg = "BypassDisabledFlexEvent";
    private static final ObjectId kBypassDisabledOid = Bypass.BypassDisabled.getObjectId();
    private static final String kMaintBypassEnabledMsg = "MaintenanceBypassEnabledFlexEvent";
    private static final ObjectId kBypassEnabledOid = Bypass.BypassEnabled.getObjectId();
    private static final String kFaultBypassEnabledMsg = "FaultBypassEnabledFlexEvent";
    private static final ObjectId kFaultBypassEnabledOid = Bypass.FaultBypassEnabled.getObjectId();
    private static final Logger logger = LogManager.getLogger(BypassFiringLogicRule.class);

    @Override
    public void calculate() {
        boolean bl = this.theState.isEventActive(kBypassEnabledOid) || this.theState.isEventActive(kFaultBypassEnabledOid);
        logger.info("BypassFiringLogicRule: wasInBypass:" + bl + " Enabled:" + this.theState.isEventActive(kBypassEnabledOid) + " Fault:" + this.theState.isEventActive(kFaultBypassEnabledOid));
        this.doEventReason(1, kFaultBypassEnabledOid, kFaultBypassEnabledMsg, Bypass.FaultBypassEnabled.getEventId());
        boolean bl2 = this.theState.isEventActive(kFaultBypassEnabledOid);
        if (!bl2) {
            this.doEventIgnoreReason();
        }
        bl2 = this.theState.isEventActive(kBypassEnabledOid) || this.theState.isEventActive(kFaultBypassEnabledOid);
        logger.info("BypassFiringLogicRule: isInBypass:" + bl2 + " Enabled:" + this.theState.isEventActive(kBypassEnabledOid) + " Fault:" + this.theState.isEventActive(kFaultBypassEnabledOid));
        if (bl && !bl2) {
            logger.info("BypassFiringLogicRule: firing BypassDisabledEvent");
            this.theManager.dispatchEvent(new AdvancedGroupEvent(kBypassDisabledOid, true, new EventMessageFormatter(kBypassDisabledMsg), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), true, Bypass.BypassDisabled.getEventId()));
        }
        if (this.theState.isEventActive(kBypassDisabledOid) && bl2) {
            this.theManager.dispatchEvent(new AdvancedGroupEvent(kBypassDisabledOid, false, (IFormatter)new EventMessageFormatter(kBypassDisabledMsg), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
        }
    }

    private void doEventIgnoreReason() {
        boolean[] blArray = this.theState.getOnBypass();
        int n = 0;
        for (boolean bl : blArray) {
            if (!bl) continue;
            ++n;
        }
        if (n > this.theState.getTotalRedundantUps()) {
            if (!this.theState.isEventActive(kBypassEnabledOid)) {
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kBypassEnabledOid, true, new EventMessageFormatter(kMaintBypassEnabledMsg), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), false, Bypass.BypassEnabled.getEventId()));
            }
        } else if (this.theState.isEventActive(kBypassEnabledOid)) {
            this.theManager.dispatchEvent(new AdvancedGroupEvent(kBypassEnabledOid, false, (IFormatter)new EventMessageFormatter(kMaintBypassEnabledMsg), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
        }
    }

    private void doEventReason(int n, ObjectId objectId, String string, String string2) {
        int[] nArray = this.theState.getOnBypassReason();
        boolean[] blArray = this.theState.getOnBypass();
        int n2 = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i] || nArray[i] != n) continue;
            ++n2;
        }
        if (n2 > this.theState.getTotalRedundantUps()) {
            if (!this.theState.isEventActive(objectId)) {
                this.theManager.dispatchEvent(new AdvancedGroupEvent(objectId, true, new EventMessageFormatter(string), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), false, string2));
            }
        } else if (this.theState.isEventActive(objectId)) {
            this.theManager.dispatchEvent(new AdvancedGroupEvent(objectId, false, (IFormatter)new EventMessageFormatter(string), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
        }
    }
}

