/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.advanced;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.ds.events.flexevents.powersource.Bypass;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BypassSwitchFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kBypassSwitchFailedMsg = "BypassContactorFailedFlexEvent";
    private static final ObjectId kBypassSwitchFailedOid = Bypass.BypassContactorFailed.getObjectId();
    private static final String kBypassSwitchOkMsg = "BypassContactorOkFlexEvent";
    private static final ObjectId kBypassSwitchOkOid = Bypass.BypassContactorOk.getObjectId();
    private static final Logger logger = LogManager.getLogger(BypassSwitchFiringLogicRule.class);

    @Override
    public void calculate() {
        boolean[] blArray = this.theState.getBypassSwitchFailed();
        if (AggregatorState.find_matches(blArray, true) > this.theState.getTotalRedundantUps()) {
            if (this.theState.getLastReportedBypassSwitchState() != 1) {
                logger.info("BypassSwitchFiringLogicRule.calculate(): firing BypassSwitchFailed event ");
                if (this.theState.getLastReportedBypassSwitchState() == 2) {
                    this.theManager.dispatchEvent(new AdvancedGroupEvent(kBypassSwitchOkOid, false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
                }
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kBypassSwitchFailedOid, true, new EventMessageFormatter(kBypassSwitchFailedMsg), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), false, Bypass.BypassContactorFailed.getEventId()));
                this.theState.setLastReportedBypassSwitchState(1);
            }
        } else if (this.theState.getLastReportedBypassSwitchState() != 2) {
            if (this.theState.getLastReportedBypassSwitchState() == 1) {
                logger.info("BypassSwitchFiringLogicRule.calculate(): firing BypassSwitchOk event ");
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kBypassSwitchFailedOid, false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kBypassSwitchOkOid, true, new EventMessageFormatter(kBypassSwitchOkMsg), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), true, Bypass.BypassContactorOk.getEventId()));
            }
            this.theState.setLastReportedBypassSwitchState(2);
        }
    }
}

