/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.advanced;

import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.ds.events.flexevents.powersource.Communication;
import com.apcc.m11.ds.powersource.Output;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.ConfigurationKeys;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommEstablishedFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kCommEstablishedMsg = "CommunicationEstablishedFlexEvent";
    private static final ObjectId kCommEstablishedOid = Communication.CommunicationEstablished.getObjectId();
    private static final ObjectId kCommLostOid = Communication.CommunicationLost.getObjectId();
    private static final ObjectId kCommLostWhileOnBatteryOid = Communication.CommunicationLostOnBattery.getObjectId();
    private static final ObjectId kNetCommLostOid = Communication.NetCommunicationLost.getObjectId();
    private static final Logger logger = LogManager.getLogger(CommEstablishedFiringLogicRule.class);

    public CommEstablishedFiringLogicRule(ServiceManager serviceManager) {
        this.setServices(serviceManager);
    }

    @Override
    public void calculate() {
        if (this.isEventOccur()) {
            logger.info("CommEstablishedFiringLogicRule.calculate(): firing CommEstablished event ");
            if (this.theState.getLastReportedCommState() == 2) {
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kCommLostOid, false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
            } else if (this.theState.getLastReportedCommState() == 4) {
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kCommLostWhileOnBatteryOid, false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
            } else if (this.theState.getLastReportedCommState() == 3) {
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kNetCommLostOid, false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
            }
            try {
                Object object;
                if ((this.services.getVirtualConfigurationManager().isManagedHost() || this.services.getVirtualConfigurationManager().isNutanixAHV()) && !this.services.getAdvancedSetupHelper().isAdvancedShutdownMode() && (object = this.theManager.dataBusGet(ConfigurationKeys.DEFAULTSHUTDOWNINDEX, Output.OutputState.getObjectId())) != null && object instanceof Integer) {
                    int n = (Integer)object;
                    boolean bl = false;
                    if (this.services.getVirtualConfigurationManager().isESXi()) {
                        bl = this.services.getVirtualConfigurationManager().isPCNSInstalledOnVMA();
                    }
                    if (!bl && n == 1) {
                        this.theState.setOffInitiatedbyPCNS(false);
                    }
                }
            }
            catch (InvalidObjectIdException invalidObjectIdException) {
                logger.error((Object)invalidObjectIdException);
            }
            this.theManager.dispatchEvent(new AdvancedGroupEvent(kCommEstablishedOid, true, new EventMessageFormatter(kCommEstablishedMsg), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), true, Communication.CommunicationEstablished.getEventId()));
            this.theState.setLastReportedCommState(1);
        }
    }

    private boolean isEventOccur() {
        boolean bl = false;
        int n = 0;
        logger.info("isEventOccur  CommEstablished length:" + this.theState.getCommEstablished().length);
        if (this.theState.getCommEstablished().length == 0) {
            return false;
        }
        n = this.services.getAdvancedSetupHelper().isShutdownOnRedundancyLostEnabled(this.theState.getAggregatorIdx()) ? this.theState.getUnitsRequiredForLoad() + 1 : this.theState.getUnitsRequiredForLoad();
        if (this.theState.getLastReportedCommState() == 0 && AggregatorState.all(this.theState.getCommEstablished(), true) && AggregatorState.all(this.theState.getNetCommEstablished(), true) && AggregatorState.all(this.theState.getPowerSourceReported(), true)) {
            bl = true;
        } else if (this.theState.getLastReportedCommState() != 0 && this.theState.getLastReportedCommState() != 1 && AggregatorState.find_matches(this.theState.getCommEstablished(), true) >= n && AggregatorState.find_matches(this.theState.getNetCommEstablished(), true) >= n && AggregatorState.find_matches(this.theState.getPowerSourceReported(), true) >= n) {
            bl = true;
            logger.info(" true: " + this.theState.getTotalRedundantUps() + ", " + AggregatorState.find_matches(this.theState.getCommEstablished(), true) + ", " + AggregatorState.find_matches(this.theState.getNetCommEstablished(), true) + ", " + AggregatorState.find_matches(this.theState.getPowerSourceReported(), true));
        }
        return bl;
    }
}

