/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.advanced;

import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.CannotCommunicateFormatter;
import com.apcc.m11.components.psaggregator.IEventRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.ds.events.flexevents.powersource.Communication;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import com.apcc.pcns.util.HostNameLookUpTable;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommEstablishedInputEventRule
extends PSAggregatorRule
implements IEventRule {
    private static final String kCannotCommunicateResolvedMsg = "CannotCommunicateResolvedFlexEvent";
    private static final ObjectId kCannotCommunicateResolvedOid = Communication.CannotCommunicateResolved.getObjectId();
    private static final Logger logger = LogManager.getLogger(CommEstablishedInputEventRule.class);

    @Override
    public Iterator<ObjectId> getConsumedEvents() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(Communication.CommunicationEstablished.getObjectId());
        return vector.iterator();
    }

    @Override
    public void update(Event event, int n) {
        if (event.isActive()) {
            logger.info("CommunicationEstablished: got an update from PS " + n);
            logger.info(AggregatorState.find_matches(this.theState.getCommEstablished(), true) + ", " + AggregatorState.find_matches(this.theState.getNetCommEstablished(), true) + ", " + AggregatorState.find_matches(this.theState.getPowerSourceReported(), true));
            try {
                InetAddress inetAddress = (InetAddress)this.theManager.dataBusGet(n, TCPIPCommunication.IpAddress.getObjectId());
                logger.info("CommEstablishedInputEventRule: firing for PS " + n);
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kCannotCommunicateResolvedOid, true, new CannotCommunicateFormatter(kCannotCommunicateResolvedMsg, HostNameLookUpTable.getInstance().lookUp(inetAddress)), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), true, Communication.CannotCommunicateResolved.getEventId()));
            }
            catch (InvalidObjectIdException invalidObjectIdException) {
                logger.info((Object)invalidObjectIdException);
            }
            this.theState.setPowerSourceReported(n, true);
            this.theState.setCommEstablished(n, true);
            this.theState.setNetCommEstablished(n, true);
        }
    }
}

