/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.advanced;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.ds.events.flexevents.powersource.Temperature;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InternalTempFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kInternalTempExceededMsg = "InternalTempExceededFlexEvent";
    private static final ObjectId kInternalTempExceededOid = Temperature.MaxInternalTempExceeded.getObjectId();
    private static final String kInternalTempInRangeMsg = "InternalTempInRangeFlexEvent";
    private static final ObjectId kInternalTempInRangeOid = Temperature.MaxInternalTempInRange.getObjectId();
    private static final Logger logger = LogManager.getLogger(InternalTempFiringLogicRule.class);

    @Override
    public void calculate() {
        boolean[] blArray = AggregatorState.not(this.theState.getInternalTempOK());
        if (AggregatorState.find_matches(blArray, true) > this.theState.getTotalRedundantUps()) {
            if (this.theState.getLastReportedInternalTempState() != 2) {
                logger.info("InternalTempFiringLogicRule.calculate(): firing InternalTempExceeded event ");
                if (this.theState.getLastReportedInternalTempState() == 1) {
                    this.theManager.dispatchEvent(new AdvancedGroupEvent(kInternalTempInRangeOid, false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
                }
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kInternalTempExceededOid, true, new EventMessageFormatter(kInternalTempExceededMsg), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), false, Temperature.MaxInternalTempExceeded.getEventId()));
                this.theState.setLastReportedInternalTempState(2);
            }
        } else if (this.theState.getLastReportedInternalTempState() != 1) {
            if (this.theState.getLastReportedInternalTempState() == 2) {
                logger.info("InternalTempFiringLogicRule.calculate(): firing InternalTempInRange event ");
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kInternalTempExceededOid, false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kInternalTempInRangeOid, true, new EventMessageFormatter(kInternalTempInRangeMsg), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), true, Temperature.MaxInternalTempInRange.getEventId()));
            }
            this.theState.setLastReportedInternalTempState(1);
        }
    }
}

