/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.advanced;

import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.ds.events.flexevents.powersource.Battery;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LowBatteryFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kLowBatteryMsg = "LowBatteryFlexEvent";
    private static final ObjectId kLowBatteryOid = Battery.LowBattery.getObjectId();
    private static final ObjectId kReturnFromLowBatteryOid = Battery.ReturnFromLowBattery.getObjectId();
    private static final Logger logger = LogManager.getLogger(LowBatteryFiringLogicRule.class);

    @Override
    public void calculate() {
        boolean[] blArray = this.theState.getLowBattery();
        if (AggregatorState.find_matches(blArray, true) > this.theState.getTotalRedundantUps() && (this.theState.getLastReportedLowBatteryState() == 0 || this.theState.getLastReportedLowBatteryState() == 2)) {
            logger.debug("LowBatteryFiringLogicRule.calculate(): firing LowBattery event ");
            if (this.theState.getLastReportedLowBatteryState() == 2) {
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kReturnFromLowBatteryOid, false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
            }
            this.theManager.dispatchEvent(new AdvancedGroupEvent(kLowBatteryOid, true, (IFormatter)new EventMessageFormatter(kLowBatteryMsg), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
            this.theState.setLastReportedLowBatteryState(1);
        }
    }
}

