/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.advanced;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.IEventRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.powersource.Battery;
import java.util.Iterator;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LowBatteryInputEventRule
extends PSAggregatorRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(LowBatteryInputEventRule.class);

    @Override
    public Iterator<ObjectId> getConsumedEvents() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(Battery.ReturnFromLowBattery.getObjectId());
        vector.add(Battery.LowBattery.getObjectId());
        return vector.iterator();
    }

    @Override
    public void update(Event event, int n) {
        if (event.isActive()) {
            if (event.getObjectId().equals((Object)Battery.LowBattery.getObjectId())) {
                logger.info("LowBattery: got an update from PS " + n);
                this.theState.setLowBattery(n, true);
            } else {
                logger.info("ReturnFromLowBattery: got an update from PS " + n);
                this.theState.setLowBattery(n, false);
            }
        }
    }
}

