/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.advanced;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.ds.events.flexevents.powersource.LoadCapability;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MinLoadCapFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kMinLoadCapLostMsg = "MinLoadCapabilityLostFlexEvent";
    private static final ObjectId kMinLoadCapLostOid = LoadCapability.MinLoadCapabilityLost.getObjectId();
    private static final String kMinLoadCapRegainedMsg = "MinLoadCapabilityRegainedFlexEvent";
    private static final ObjectId kMinLoadCapRegainedOid = LoadCapability.MinLoadCapabilityRegained.getObjectId();
    private static final Logger logger = LogManager.getLogger(MinLoadCapFiringLogicRule.class);

    @Override
    public void calculate() {
        boolean[] blArray = this.theState.getMinLoadCapabilityLost();
        if (AggregatorState.find_matches(blArray, true) > this.theState.getTotalRedundantUps()) {
            if (this.theState.getLastReportedMinLoadCapabilityState() != 1) {
                logger.info("MinLoadCapFiringLogicRule.calculate(): firing MinimumLoadCapabilityLost event ");
                if (this.theState.getLastReportedMinLoadCapabilityState() == 2) {
                    this.theManager.dispatchEvent(new AdvancedGroupEvent(kMinLoadCapRegainedOid, false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
                }
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kMinLoadCapLostOid, true, new EventMessageFormatter(kMinLoadCapLostMsg), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), false, LoadCapability.MinLoadCapabilityLost.getEventId()));
                this.theState.setLastReportedMinLoadCapabilityState(1);
            }
        } else if (this.theState.getLastReportedMinLoadCapabilityState() != 2) {
            if (this.theState.getLastReportedMinLoadCapabilityState() == 1) {
                logger.info("MinLoadCapFiringLogicRule.calculate(): firing MinimumLoadCapabilityRegained event ");
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kMinLoadCapLostOid, false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kMinLoadCapRegainedOid, true, new EventMessageFormatter(kMinLoadCapRegainedMsg), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), true, LoadCapability.MinLoadCapabilityRegained.getEventId()));
            }
            this.theState.setLastReportedMinLoadCapabilityState(2);
        }
    }
}

