/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.advanced;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.ds.events.flexevents.powersource.Redundancy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MinRedundancyFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kMinRedundancyLostMsg = "MinRedundancyLostFlexEvent";
    private static final ObjectId kMinRedundancyLostOid = Redundancy.MinRedundancyLost.getObjectId();
    private static final String kMinRedundancyRegainedMsg = "MinRedundancyRegainedFlexEvent";
    private static final ObjectId kMinRedundancyRegainedOid = Redundancy.MinRedundancyRegained.getObjectId();
    private static final Logger logger = LogManager.getLogger(MinRedundancyFiringLogicRule.class);

    @Override
    public void calculate() {
        boolean[] blArray = this.theState.getMinRedundancyLost();
        logger.debug("Number Lost Redundancy:" + AggregatorState.find_matches(blArray, true));
        if (AggregatorState.find_matches(blArray, true) > this.theState.getTotalRedundantUps()) {
            if (this.theState.getLastReportedMinRedundancyState() != 1) {
                logger.info("MinRedundancyFiringLogicRule.calculate(): firing MinimumRedundancyLost event ");
                if (this.theState.getLastReportedMinRedundancyState() == 2) {
                    this.theManager.dispatchEvent(new AdvancedGroupEvent(kMinRedundancyRegainedOid, false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
                }
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kMinRedundancyLostOid, true, new EventMessageFormatter(kMinRedundancyLostMsg), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), false, Redundancy.MinRedundancyLost.getEventId()));
                this.theState.setLastReportedMinRedundancyState(1);
            }
        } else if (this.theState.getLastReportedMinRedundancyState() != 2) {
            if (this.theState.getLastReportedMinRedundancyState() == 1) {
                logger.info("MinRedundancyFiringLogicRule.calculate(): firing MinimumRedundancyRegained event ");
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kMinRedundancyLostOid, false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kMinRedundancyRegainedOid, true, new EventMessageFormatter(kMinRedundancyRegainedMsg), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), true, Redundancy.MinRedundancyRegained.getEventId()));
            }
            this.theState.setLastReportedMinRedundancyState(2);
        }
    }
}

