/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.advanced;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.RawFormatter;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.ds.events.flexevents.powersource.Communication;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MonitoringStartedFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final ObjectId kMonitoringStartedOid = Communication.MonitoringStarted.getObjectId();
    private static final Logger logger = LogManager.getLogger(MonitoringStartedFiringLogicRule.class);

    @Override
    public void calculate() {
        if (this.theState.getMonitoringStarted().length > 0 && AggregatorState.all(this.theState.getMonitoringStarted(), true) && !this.theState.getMonitoringStartedReportedState()) {
            logger.info("MonitoringStartedFiringLogicRule.calculate(): firing MonitoringStarted event ");
            String string = this.theState.getMonitoringStartedText();
            if (string != null) {
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kMonitoringStartedOid, true, new RawFormatter(string), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), true, Communication.MonitoringStarted.getEventId()));
                this.theState.setMonitoringStartedReportedState(true);
            }
        }
    }
}

