/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.advanced;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.ds.events.flexevents.powersource.Communication;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetCommLostFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final ObjectId kCommEstablishedOid = Communication.CommunicationEstablished.getObjectId();
    private static final ObjectId kCommLostOid = Communication.CommunicationLost.getObjectId();
    private static final String kNetCommLostMsg = "NetworkCommunicationLostFlexEvent";
    private static final ObjectId kNetCommLostOid = Communication.NetCommunicationLost.getObjectId();
    private static final Logger logger = LogManager.getLogger(NetCommLostFiringLogicRule.class);

    @Override
    public void calculate() {
        if (AggregatorState.find_matches(this.theState.getNetCommEstablished(), false) > this.theState.getTotalRedundantUps() && this.theState.getLastReportedCommState() != 3 && this.theState.getLastReportedCommState() != 4) {
            logger.info("NetCommLostFiringLogicRule.calculate(): firing NetCommLost event state=" + this.theState.getLastReportedCommState());
            if (this.theState.getLastReportedCommState() == 1) {
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kCommEstablishedOid, false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
            } else if (this.theState.getLastReportedCommState() == 2) {
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kCommLostOid, false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
            }
            this.theManager.dispatchEvent(new AdvancedGroupEvent(kNetCommLostOid, true, new EventMessageFormatter(kNetCommLostMsg), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), false, Communication.NetCommunicationLost.getEventId()));
            this.theState.setLastReportedCommState(3);
        }
    }
}

