/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.advanced;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.IEventRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.PSAggregatorUtils;
import com.apcc.m11.components.psaggregator.SinglePowerFormatter;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupOutletEvent;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import com.apcc.m11.ds.events.flexevents.powersource.MultipleEvent;
import com.apcc.m11.ds.events.flexevents.powersource.UtilityLineStatus;
import com.apcc.pcns.ServiceManager;
import java.util.Iterator;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutletOffInputEventRule
extends PSAggregatorRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(OutletOffInputEventRule.class);
    private static final String kSingleOutletOffMsg = "SingleOutletOffFlexEvent";
    private static final ObjectId kSingleOutletOffOid = MultipleEvent.SingleOutletOff.getObjectId();
    private static final ObjectId kSingleOutletRestoredOid = MultipleEvent.SingleOutletRestored.getObjectId();
    private static final ObjectId kOutletTurnOffInitiatedOid = ShutdownEvents.UPSOutletTurnOffInitiated.getObjectId();

    public OutletOffInputEventRule(ServiceManager serviceManager) {
        this.setServices(serviceManager);
    }

    @Override
    public Iterator<ObjectId> getConsumedEvents() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(UtilityLineStatus.OutletOff.getObjectId());
        return vector.iterator();
    }

    @Override
    public void update(Event event, int n) {
        UPSSetup uPSSetup = this.services.getAdvancedSetupHelper().readUPSSetupFromConfig(this.theState.getAggregatorIdx());
        if (uPSSetup == null) {
            return;
        }
        if (event instanceof AdvancedGroupOutletEvent && !uPSSetup.hasHostsOnOutlets()) {
            logger.debug("no hosts mapped for advancedGroupOutlet events");
            return;
        }
        if (!(event instanceof AdvancedGroupOutletEvent) && uPSSetup.hasHostsOnOutlets()) {
            logger.debug("hosts mapped for advancedGroupOutlet events, ignore standard Outlet Event");
            return;
        }
        if (uPSSetup.hasHostsOnOutlets() && !uPSSetup.isVirtualHostsShutdownEnabled()) {
            AdvancedGroupOutletEvent advancedGroupOutletEvent;
            logger.debug("hosts mapped to outlets");
            if (event instanceof AdvancedGroupOutletEvent && !uPSSetup.getHosts((advancedGroupOutletEvent = (AdvancedGroupOutletEvent)event).getOutletNumber()).isEmpty()) {
                logger.debug("hosts mapped to THIS outlet.  Passing on event");
                this.theManager.dispatchEvent(event);
            }
        } else {
            logger.debug("No hosts mapped or virtual host shutdown enabled, using old aggregation");
            if (event.isActive()) {
                logger.trace("OutletOffInputEventRule: got an update from PS " + n);
                if (!this.theState.getOutletOff()[n]) {
                    logger.debug("PS=" + n + " sending outlet off");
                    this.theManager.dispatchEvent(new AdvancedGroupEvent(kSingleOutletRestoredOid, false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
                    this.theManager.dispatchEvent(new AdvancedGroupEvent(kSingleOutletOffOid, true, new SinglePowerFormatter(kSingleOutletOffMsg, PSAggregatorUtils.getAddress(n, this.theManager)), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), false, MultipleEvent.SingleOutletOff.getEventId()));
                    this.theState.setOutletOff(n, true);
                    this.theState.setOutletTurnOffInitiated(n, false);
                    this.theState.checkOffInitiatedbyPCNS();
                }
            }
        }
    }
}

