/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.advanced;

import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutletTurnOffInitiatedFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kOutletTurnOffInitiatedMsg = "OutletTurnOffInitiatedFlexEvent";
    private static final ObjectId kOutletTurnOffInitiatedOid = ShutdownEvents.UPSOutletTurnOffInitiated.getObjectId();
    private static final Logger logger = LogManager.getLogger(OutletTurnOffInitiatedFiringLogicRule.class);

    @Override
    public void calculate() {
        boolean[] blArray = this.theState.getOutletTurnOffInitiated();
        int n = AggregatorState.find_matches(blArray, true);
        if (n > this.theState.getTotalRedundantUps()) {
            if (this.theState.getLastReportedOutletTurnOffState() == 0) {
                logger.info("firing OutletTurnOffInitiated event for: " + this.theState.getAdvancedGroupName());
                logger.debug("outletTurnOffInit: " + String.valueOf(blArray));
                logger.debug("lastReportedState: " + this.theState.getLastReportedOutletTurnOffState());
                if (AggregatorState.find_matches(blArray, true) == 1) {
                    logger.debug("Turn Off event fired by input event rule");
                } else {
                    this.theManager.dispatchEvent(new AdvancedGroupEvent(kOutletTurnOffInitiatedOid, true, (IFormatter)new EventMessageFormatter(kOutletTurnOffInitiatedMsg), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
                }
                this.theState.setLastReportedOutletTurnOffState(1);
            }
        } else if (n == 0 && this.theState.getLastReportedOutletTurnOffState() == 1) {
            logger.info("Clear OutletTurnOffInitiated state for: " + this.theState.getAdvancedGroupName());
            this.theManager.dispatchEvent(new AdvancedGroupEvent(kOutletTurnOffInitiatedOid, false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
            this.theState.setLastReportedOutletTurnOffState(0);
        }
    }
}

