/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.advanced;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.IEventRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.PSAggregatorUtils;
import com.apcc.m11.components.psaggregator.SinglePowerFormatter;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupOutletEvent;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import com.apcc.m11.ds.events.flexevents.powersource.MultipleEvent;
import com.apcc.pcns.ServiceManager;
import java.util.Iterator;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutletTurnOffInitiatedInputEventRule
extends PSAggregatorRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(OutletTurnOffInitiatedInputEventRule.class);
    private static final String kSingleOutletTurnOffInitiatedMsg = "SingleOutletTurnOffInitiatedFlexEvent";
    private static final String kSingleOutletTurnOffClearedMsg = "SingleOutletTurnOffClearedFlexEvent";

    public OutletTurnOffInitiatedInputEventRule(ServiceManager serviceManager) {
        this.setServices(serviceManager);
    }

    @Override
    public Iterator<ObjectId> getConsumedEvents() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(ShutdownEvents.UPSOutletTurnOffInitiated.getObjectId());
        return vector.iterator();
    }

    @Override
    public void update(Event event, int n) {
        logger.debug("OutletturnOffInitiated: got an update from PS " + n + ", event is active: " + event.isActive());
        UPSSetup uPSSetup = this.services.getAdvancedSetupHelper().readUPSSetupFromConfig(this.theState.getAggregatorIdx());
        if (uPSSetup == null) {
            return;
        }
        if (event instanceof AdvancedGroupOutletEvent && !uPSSetup.hasHostsOnOutlets()) {
            logger.debug("no hosts mapped for advancedGroupOutlet events");
            return;
        }
        if (!(event instanceof AdvancedGroupOutletEvent) && uPSSetup.hasHostsOnOutlets()) {
            logger.debug("hosts mapped for advancedGroupOutlet events, ignore standard Outlet Event");
            return;
        }
        if (uPSSetup.hasHostsOnOutlets() && !uPSSetup.isVirtualHostsShutdownEnabled()) {
            AdvancedGroupOutletEvent advancedGroupOutletEvent;
            logger.debug("hosts mapped to outlets");
            if (event instanceof AdvancedGroupOutletEvent && !uPSSetup.getHosts((advancedGroupOutletEvent = (AdvancedGroupOutletEvent)event).getOutletNumber()).isEmpty()) {
                logger.debug("hosts mapped to THIS outlet.  Passing on event");
                this.theManager.dispatchEvent(event);
            }
        } else {
            logger.debug("No hosts mapped or virtual host shutdown enabled, using old aggregation");
            if (event.isActive()) {
                if (!this.theState.getOutletTurnOffInitiated()[n]) {
                    if (this.theState.getTotalRedundantUps() >= 1) {
                        logger.debug("OutletTurnOffInitiatedInputEventRule - firing SingleUPSEvent for logging SingleOutletTurnOffInitiated");
                        this.theManager.dispatchEvent(new AdvancedGroupEvent(MultipleEvent.SingleUPSEvent.getObjectId(), true, new SinglePowerFormatter(kSingleOutletTurnOffInitiatedMsg, PSAggregatorUtils.getAddress(n, this.theManager)), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), false, MultipleEvent.SingleUPSEvent.getEventId()));
                    } else {
                        logger.debug("OutletTurnOffInitiatedInputEventRule - firing UPSOutletTurnOffInitiated");
                        this.theManager.dispatchEvent(new AdvancedGroupEvent(ShutdownEvents.UPSOutletTurnOffInitiated.getObjectId(), true, new SinglePowerFormatter(kSingleOutletTurnOffInitiatedMsg, PSAggregatorUtils.getAddress(n, this.theManager)), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), false, ShutdownEvents.UPSOutletTurnOffInitiated.getEventId()));
                    }
                }
                this.theState.setOutletTurnOffInitiated(n, true);
            } else {
                if (this.theState.getOutletTurnOffInitiated()[n]) {
                    logger.debug("OutletTurnOffInitiatedInputEventRule - firing SingleUPSEvent for logging SingleOutletTurnOffCleared");
                    this.theManager.dispatchEvent(new AdvancedGroupEvent(MultipleEvent.SingleUPSEvent.getObjectId(), true, new SinglePowerFormatter(kSingleOutletTurnOffClearedMsg, PSAggregatorUtils.getAddress(n, this.theManager)), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), true, MultipleEvent.SingleUPSEvent.getEventId()));
                }
                this.theState.setOutletTurnOffInitiated(n, false);
                this.theState.checkOffInitiatedbyPCNS();
            }
        }
    }
}

